/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractCmisService;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryDiscoveryServiceImpl;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryMultiFilingServiceImpl;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryNavigationServiceImpl;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryObjectServiceImpl;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryRepositoryServiceImpl;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryVersioningServiceImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryService
extends AbstractCmisService {
    private static final Log LOG = LogFactory.getLog((String)InMemoryService.class.getName());
    private StoreManager storeManager;
    private CallContext context;
    private InMemoryRepositoryServiceImpl fRepSvc;
    private InMemoryObjectServiceImpl fObjSvc;
    private InMemoryNavigationServiceImpl fNavSvc;
    private InMemoryVersioningServiceImpl fVerSvc;
    private InMemoryDiscoveryServiceImpl fDisSvc;
    private InMemoryMultiFilingServiceImpl fMultiSvc;

    public StoreManager getStoreManager() {
        return this.storeManager;
    }

    public InMemoryService(Map<String, String> parameters, StoreManager sm) {
        this.storeManager = sm;
        this.fRepSvc = new InMemoryRepositoryServiceImpl(this.storeManager);
        this.fNavSvc = new InMemoryNavigationServiceImpl(this.storeManager);
        this.fObjSvc = new InMemoryObjectServiceImpl(this.storeManager);
        this.fVerSvc = new InMemoryVersioningServiceImpl(this.storeManager, this.fObjSvc);
        this.fDisSvc = new InMemoryDiscoveryServiceImpl(this.storeManager, this.fRepSvc, this.fNavSvc);
        this.fMultiSvc = new InMemoryMultiFilingServiceImpl(this.storeManager);
    }

    public CallContext getCallContext() {
        return this.context;
    }

    public void setCallContext(CallContext context) {
        this.context = context;
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        return this.fRepSvc.getRepositoryInfos(this.getCallContext(), extension);
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        return this.fRepSvc.getRepositoryInfo(this.getCallContext(), repositoryId, extension);
    }

    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.fRepSvc.getTypeChildren(this.getCallContext(), repositoryId, typeId, includePropertyDefinitions, maxItems, skipCount, extension);
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        return this.fRepSvc.getTypeDefinition(this.getCallContext(), repositoryId, typeId, extension);
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        return this.fRepSvc.getTypeDescendants(this.getCallContext(), repositoryId, typeId, depth, includePropertyDefinitions, extension);
    }

    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.fNavSvc.getCheckedOutDocs(this.getCallContext(), repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount, extension, (ObjectInfoHandler)this);
    }

    public ObjectInFolderList getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.fNavSvc.getChildren(this.getCallContext(), repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, maxItems, skipCount, extension, (ObjectInfoHandler)this);
    }

    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        return this.fNavSvc.getDescendants(this.getCallContext(), repositoryId, folderId, depth, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, extension, (ObjectInfoHandler)this);
    }

    public ObjectData getFolderParent(String repositoryId, String folderId, String filter, ExtensionsData extension) {
        return this.fNavSvc.getFolderParent(this.getCallContext(), repositoryId, folderId, filter, extension, (ObjectInfoHandler)this);
    }

    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        return this.fNavSvc.getFolderTree(this.getCallContext(), repositoryId, folderId, depth, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, extension, (ObjectInfoHandler)this);
    }

    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        return this.fNavSvc.getObjectParents(this.getCallContext(), repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includeRelativePathSegment, extension, (ObjectInfoHandler)this);
    }

    public String create(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, ExtensionsData extension) {
        String id = this.fObjSvc.create(this.getCallContext(), repositoryId, properties, folderId, contentStream, versioningState, policies, extension, (ObjectInfoHandler)this);
        return id;
    }

    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.fObjSvc.createDocument(this.getCallContext(), repositoryId, properties, folderId, contentStream, versioningState, policies, addAces, removeAces, extension);
    }

    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.fObjSvc.createDocumentFromSource(this.getCallContext(), repositoryId, sourceId, properties, folderId, versioningState, policies, addAces, removeAces, extension);
    }

    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.fObjSvc.createFolder(this.getCallContext(), repositoryId, properties, folderId, policies, addAces, removeAces, extension);
    }

    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.fObjSvc.createPolicy(this.getCallContext(), repositoryId, properties, folderId, policies, addAces, removeAces, extension);
    }

    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.fObjSvc.createRelationship(this.getCallContext(), repositoryId, properties, policies, addAces, removeAces, extension);
    }

    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        this.fObjSvc.deleteContentStream(this.getCallContext(), repositoryId, objectId, changeToken, extension);
    }

    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.fObjSvc.deleteObjectOrCancelCheckOut(this.getCallContext(), repositoryId, objectId, allVersions, extension);
    }

    public void deleteObjectOrCancelCheckOut(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.fObjSvc.deleteObjectOrCancelCheckOut(this.getCallContext(), repositoryId, objectId, allVersions, extension);
    }

    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        return this.fObjSvc.deleteTree(this.getCallContext(), repositoryId, folderId, allVersions, unfileObjects, continueOnFailure, extension);
    }

    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        return this.fObjSvc.getAllowableActions(this.getCallContext(), repositoryId, objectId, extension);
    }

    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        return this.fObjSvc.getContentStream(this.getCallContext(), repositoryId, objectId, streamId, offset, length, extension);
    }

    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        return this.fObjSvc.getObject(this.getCallContext(), repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension, (ObjectInfoHandler)this);
    }

    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        return this.fObjSvc.getObjectByPath(this.getCallContext(), repositoryId, path, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension, (ObjectInfoHandler)this);
    }

    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        return this.fObjSvc.getProperties(this.getCallContext(), repositoryId, objectId, filter, extension);
    }

    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.fObjSvc.getRenditions(this.getCallContext(), repositoryId, objectId, renditionFilter, maxItems, skipCount, extension);
    }

    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        this.fObjSvc.moveObject(this.getCallContext(), repositoryId, objectId, targetFolderId, sourceFolderId, extension, (ObjectInfoHandler)this);
    }

    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        this.fObjSvc.setContentStream(this.getCallContext(), repositoryId, objectId, overwriteFlag, changeToken, contentStream, extension);
    }

    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        this.fObjSvc.updateProperties(this.getCallContext(), repositoryId, objectId, changeToken, properties, null, extension, (ObjectInfoHandler)this);
    }

    public void cancelCheckOut(String repositoryId, String objectId, ExtensionsData extension) {
        this.fVerSvc.cancelCheckOut(this.getCallContext(), repositoryId, objectId, extension);
    }

    public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.fVerSvc.checkIn(this.getCallContext(), repositoryId, objectId, major, properties, contentStream, checkinComment, policies, addAces, removeAces, extension, (ObjectInfoHandler)this);
    }

    public void checkOut(String repositoryId, Holder<String> objectId, ExtensionsData extension, Holder<Boolean> contentCopied) {
        this.fVerSvc.checkOut(this.getCallContext(), repositoryId, objectId, extension, contentCopied, (ObjectInfoHandler)this);
    }

    public ObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        return this.fVerSvc.getObjectOfLatestVersion(this.getCallContext(), repositoryId, objectId, versionSeriesId, major, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension, (ObjectInfoHandler)this);
    }

    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        return this.fVerSvc.getPropertiesOfLatestVersion(this.getCallContext(), repositoryId, objectId, versionSeriesId, major, filter, extension);
    }

    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        return this.fVerSvc.getAllVersions(this.getCallContext(), repositoryId, objectId, versionSeriesId, filter, includeAllowableActions, extension, (ObjectInfoHandler)this);
    }

    public ObjectList getContentChanges(String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeAcl, BigInteger maxItems, ExtensionsData extension) {
        return this.fDisSvc.getContentChanges(this.getCallContext(), repositoryId, changeLogToken, includeProperties, filter, includePolicyIds, includeAcl, maxItems, extension, (ObjectInfoHandler)this);
    }

    public ObjectList query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.fDisSvc.query(this.getCallContext(), repositoryId, statement, searchAllVersions, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount, extension);
    }

    public void addObjectToFolder(String repositoryId, String objectId, String folderId, Boolean allVersions, ExtensionsData extension) {
        this.fMultiSvc.addObjectToFolder(this.getCallContext(), repositoryId, objectId, folderId, allVersions, extension, (ObjectInfoHandler)this);
    }

    public void removeObjectFromFolder(String repositoryId, String objectId, String folderId, ExtensionsData extension) {
        this.fMultiSvc.removeObjectFromFolder(this.getCallContext(), repositoryId, objectId, folderId, extension, (ObjectInfoHandler)this);
    }

    public ObjectList getObjectRelationships(String repositoryId, String objectId, Boolean includeSubRelationshipTypes, RelationshipDirection relationshipDirection, String typeId, String filter, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return super.getObjectRelationships(repositoryId, objectId, includeSubRelationshipTypes, relationshipDirection, typeId, filter, includeAllowableActions, maxItems, skipCount, extension);
    }

    public Acl applyAcl(String repositoryId, String objectId, Acl aces, AclPropagation aclPropagation) {
        return super.applyAcl(repositoryId, objectId, aces, aclPropagation);
    }

    public Acl applyAcl(String repositoryId, String objectId, Acl addAces, Acl removeAces, AclPropagation aclPropagation, ExtensionsData extension) {
        return super.applyAcl(repositoryId, objectId, addAces, removeAces, aclPropagation, extension);
    }

    public Acl getAcl(String repositoryId, String objectId, Boolean onlyBasicPermissions, ExtensionsData extension) {
        return super.getAcl(repositoryId, objectId, onlyBasicPermissions, extension);
    }

    public void applyPolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        super.applyPolicy(repositoryId, policyId, objectId, extension);
    }

    public List<ObjectData> getAppliedPolicies(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        return super.getAppliedPolicies(repositoryId, objectId, filter, extension);
    }

    public void removePolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        super.removePolicy(repositoryId, policyId, objectId, extension);
    }
}

