/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyBoolean;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CmisExtensionElementImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FailedToDeleteDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.inmemory.DataObjectCreator;
import org.apache.chemistry.opencmis.inmemory.FilterParser;
import org.apache.chemistry.opencmis.inmemory.NameValidator;
import org.apache.chemistry.opencmis.inmemory.server.AtomLinkInfoProvider;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryAbstractServiceImpl;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryServiceFactoryImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Content;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Document;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Filing;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Folder;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;
import org.apache.chemistry.opencmis.inmemory.types.InMemoryDocumentTypeDefinition;
import org.apache.chemistry.opencmis.inmemory.types.InMemoryFolderTypeDefinition;
import org.apache.chemistry.opencmis.inmemory.types.InMemoryPolicyTypeDefinition;
import org.apache.chemistry.opencmis.inmemory.types.InMemoryRelationshipTypeDefinition;
import org.apache.chemistry.opencmis.inmemory.types.PropertyCreationHelper;
import org.apache.chemistry.opencmis.server.support.TypeValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryObjectServiceImpl
extends InMemoryAbstractServiceImpl {
    private static final Log LOG = LogFactory.getLog((String)InMemoryServiceFactoryImpl.class.getName());
    AtomLinkInfoProvider fAtomLinkProvider;

    public InMemoryObjectServiceImpl(StoreManager storeManager) {
        super(storeManager);
        this.fAtomLinkProvider = new AtomLinkInfoProvider(this.fStoreManager);
    }

    public String createDocument(CallContext context, String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        LOG.debug((Object)"start createDocument()");
        StoredObject so = this.createDocumentIntern(context, repositoryId, properties, folderId, contentStream, versioningState, policies, addAces, removeAces, extension);
        LOG.debug((Object)"stop createDocument()");
        return so.getId();
    }

    public String createDocumentFromSource(CallContext context, String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        LOG.debug((Object)"start createDocumentFromSource()");
        StoredObject so = this.validator.createDocumentFromSource(context, repositoryId, sourceId, folderId, extension);
        ContentStream content = this.getContentStream(context, repositoryId, sourceId, null, BigInteger.valueOf(-1L), BigInteger.valueOf(-1L), null);
        if (so == null) {
            throw new CmisObjectNotFoundException("Unknown object id: " + sourceId);
        }
        List<String> requestedIds = FilterParser.getRequestedIdsFromFilter("*");
        TypeDefinition td = this.fStoreManager.getTypeById(repositoryId, so.getTypeId()).getTypeDefinition();
        Properties existingProps = PropertyCreationHelper.getPropertiesFromObject(so, td, requestedIds, true);
        PropertiesImpl newPD = new PropertiesImpl();
        for (PropertyData prop : existingProps.getProperties().values()) {
            newPD.addProperty(prop);
        }
        for (PropertyData prop : properties.getProperties().values()) {
            newPD.addProperty(prop);
        }
        String res = this.createDocument(context, repositoryId, (Properties)newPD, folderId, content, versioningState, policies, addAces, removeAces, null);
        LOG.debug((Object)"stop createDocumentFromSource()");
        return res;
    }

    public String createFolder(CallContext context, String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        LOG.debug((Object)"start createFolder()");
        Folder folder = this.createFolderIntern(context, repositoryId, properties, folderId, policies, addAces, removeAces, extension);
        LOG.debug((Object)"stop createFolder()");
        return folder.getId();
    }

    public String createPolicy(CallContext context, String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        LOG.debug((Object)"start createPolicy()");
        StoredObject so = this.createPolicyIntern(context, repositoryId, properties, folderId, policies, addAces, removeAces, extension);
        LOG.debug((Object)"stop createPolicy()");
        return so == null ? null : so.getId();
    }

    public String createRelationship(CallContext context, String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        LOG.debug((Object)"start createRelationship()");
        StoredObject so = this.createRelationshipIntern(context, repositoryId, properties, policies, addAces, removeAces, extension);
        LOG.debug((Object)"stop createRelationship()");
        return so == null ? null : so.getId();
    }

    public String create(CallContext context, String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        String typeId;
        if (null == properties || null == properties.getProperties()) {
            throw new CmisInvalidArgumentException("Cannot create object, without properties.");
        }
        PropertyData pd = (PropertyData)properties.getProperties().get("cmis:objectTypeId");
        String string = typeId = pd == null ? null : (String)pd.getFirstValue();
        if (null == typeId) {
            throw new CmisInvalidArgumentException("Cannot create object, without a type (no property with id CMIS_OBJECT_TYPE_ID).");
        }
        TypeDefinitionContainer typeDefC = this.fStoreManager.getTypeById(repositoryId, typeId);
        if (typeDefC == null) {
            throw new CmisInvalidArgumentException("Cannot create object, a type with id " + typeId + " is unknown");
        }
        BaseTypeId typeBaseId = typeDefC.getTypeDefinition().getBaseTypeId();
        StoredObject so = null;
        if (typeBaseId.equals((Object)InMemoryDocumentTypeDefinition.getRootDocumentType().getBaseTypeId())) {
            so = this.createDocumentIntern(context, repositoryId, properties, folderId, contentStream, versioningState, null, null, null, null);
        } else if (typeBaseId.equals((Object)InMemoryFolderTypeDefinition.getRootFolderType().getBaseTypeId())) {
            so = this.createFolderIntern(context, repositoryId, properties, folderId, null, null, null, null);
        } else if (typeBaseId.equals((Object)InMemoryPolicyTypeDefinition.getRootPolicyType().getBaseTypeId())) {
            so = this.createPolicyIntern(context, repositoryId, properties, folderId, null, null, null, null);
        } else if (typeBaseId.equals((Object)InMemoryRelationshipTypeDefinition.getRootRelationshipType().getBaseTypeId())) {
            so = this.createRelationshipIntern(context, repositoryId, properties, null, null, null, null);
        } else {
            LOG.error((Object)"The type contains an unknown base object id, object can't be created");
        }
        TypeDefinition td = typeDefC.getTypeDefinition();
        ObjectData od = PropertyCreationHelper.getObjectData(td, so, null, context.getUsername(), false, IncludeRelationships.NONE, null, false, false, extension);
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, so, od, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        return so != null ? so.getId() : null;
    }

    public void deleteContentStream(CallContext context, String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        LOG.debug((Object)"start deleteContentStream()");
        StoredObject so = this.validator.deleteContentStream(context, repositoryId, objectId, extension);
        if (so == null) {
            throw new CmisObjectNotFoundException("Unknown object id: " + objectId);
        }
        if (!(so instanceof Content)) {
            throw new CmisObjectNotFoundException("Id" + objectId + " does not refer to a document, but only documents can have content");
        }
        ((Content)((Object)so)).setContent(null, true);
        LOG.debug((Object)"stop deleteContentStream()");
    }

    public void deleteObjectOrCancelCheckOut(CallContext context, String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        LOG.debug((Object)"start deleteObject()");
        this.validator.deleteObjectOrCancelCheckOut(context, repositoryId, objectId, extension);
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        LOG.debug((Object)("delete object for id: " + objectId));
        if (objectId.equals(objectStore.getRootFolder().getId())) {
            throw new CmisNotSupportedException("You can't delete a root folder");
        }
        objectStore.deleteObject(objectId);
        LOG.debug((Object)"stop deleteObject()");
    }

    public FailedToDeleteData deleteTree(CallContext context, String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        LOG.debug((Object)"start deleteTree()");
        StoredObject so = this.validator.deleteTree(context, repositoryId, folderId, allVersions, unfileObjects, extension);
        ArrayList<String> failedToDeleteIds = new ArrayList<String>();
        FailedToDeleteDataImpl result = new FailedToDeleteDataImpl();
        if (null == allVersions) {
            allVersions = true;
        }
        if (null == unfileObjects) {
            unfileObjects = UnfileObject.DELETE;
        }
        if (null == continueOnFailure) {
            continueOnFailure = false;
        }
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        if (null == so) {
            throw new CmisInvalidArgumentException("Cannot delete object with id  " + folderId + ". Object does not exist.");
        }
        if (!(so instanceof Folder)) {
            throw new CmisInvalidArgumentException("deleteTree can only be invoked on a folder, but id " + folderId + " does not refer to a folder");
        }
        if (unfileObjects == UnfileObject.UNFILE) {
            throw new CmisNotSupportedException("This repository does not support unfile operations.");
        }
        if (folderId.equals(objectStore.getRootFolder().getId())) {
            throw new CmisNotSupportedException("You can't delete a root folder");
        }
        this.deleteRecursive(objectStore, (Folder)so, continueOnFailure, allVersions, failedToDeleteIds);
        result.setIds(failedToDeleteIds);
        LOG.debug((Object)"stop deleteTree()");
        return result;
    }

    public AllowableActions getAllowableActions(CallContext context, String repositoryId, String objectId, ExtensionsData extension) {
        LOG.debug((Object)"start getAllowableActions()");
        StoredObject so = this.validator.getAllowableActions(context, repositoryId, objectId, extension);
        this.fStoreManager.getObjectStore(repositoryId);
        if (so == null) {
            throw new CmisObjectNotFoundException("Unknown object id: " + objectId);
        }
        String user = context.getUsername();
        AllowableActions allowableActions = DataObjectCreator.fillAllowableActions(so, user);
        LOG.debug((Object)"stop getAllowableActions()");
        return allowableActions;
    }

    public ContentStream getContentStream(CallContext context, String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        LOG.debug((Object)"start getContentStream()");
        StoredObject so = this.validator.getContentStream(context, repositoryId, objectId, streamId, extension);
        if (so == null) {
            throw new CmisObjectNotFoundException("Unknown object id: " + objectId);
        }
        if (!(so instanceof Content)) {
            throw new CmisConstraintException("Id" + objectId + " does not refer to a document or version, but only those can have content");
        }
        ContentStream csd = this.getContentStream(so, streamId, offset, length);
        if (null == csd) {
            throw new CmisConstraintException("Object " + so.getId() + " does not have content.");
        }
        LOG.debug((Object)"stop getContentStream()");
        return csd;
    }

    public ObjectData getObject(CallContext context, String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        LOG.debug((Object)"start getObject()");
        StoredObject so = this.validator.getObject(context, repositoryId, objectId, extension);
        if (so == null) {
            throw new CmisObjectNotFoundException("Unknown object id: " + objectId);
        }
        String user = context.getUsername();
        TypeDefinition td = this.fStoreManager.getTypeById(repositoryId, so.getTypeId()).getTypeDefinition();
        ObjectData od = PropertyCreationHelper.getObjectData(td, so, filter, user, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, so, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        String ns = "http://apache.org/opencmis/inmemory";
        ArrayList<CmisExtensionElementImpl> extElements = new ArrayList<CmisExtensionElementImpl>();
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("type", so.getTypeId());
        extElements.add(new CmisExtensionElementImpl(ns, "objectId", attr, objectId));
        extElements.add(new CmisExtensionElementImpl(ns, "name", null, so.getName()));
        od.setExtensions(Collections.singletonList(new CmisExtensionElementImpl(ns, "exampleExtension", null, extElements)));
        LOG.debug((Object)"stop getObject()");
        return od;
    }

    public ObjectData getObjectByPath(CallContext context, String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        LOG.debug((Object)"start getObjectByPath()");
        this.validator.getObjectByPath(context, repositoryId, path, extension);
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        StoredObject so = objectStore.getObjectByPath(path);
        if (so == null) {
            throw new CmisObjectNotFoundException("Unknown path: " + path);
        }
        String user = context.getUsername();
        TypeDefinition td = this.fStoreManager.getTypeById(repositoryId, so.getTypeId()).getTypeDefinition();
        ObjectData od = PropertyCreationHelper.getObjectData(td, so, filter, user, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
        LOG.debug((Object)"stop getObjectByPath()");
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, so, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        return od;
    }

    public Properties getProperties(CallContext context, String repositoryId, String objectId, String filter, ExtensionsData extension) {
        LOG.debug((Object)"start getProperties()");
        StoredObject so = this.validator.getProperties(context, repositoryId, objectId, extension);
        if (so == null) {
            throw new CmisObjectNotFoundException("Unknown object id: " + objectId);
        }
        List<String> requestedIds = FilterParser.getRequestedIdsFromFilter(filter);
        TypeDefinition td = this.fStoreManager.getTypeById(repositoryId, so.getTypeId()).getTypeDefinition();
        Properties props = PropertyCreationHelper.getPropertiesFromObject(so, td, requestedIds, true);
        LOG.debug((Object)"stop getProperties()");
        return props;
    }

    public List<RenditionData> getRenditions(CallContext context, String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        LOG.debug((Object)"start getRenditions()");
        this.validator.getRenditions(context, repositoryId, objectId, extension);
        LOG.debug((Object)"stop getRenditions()");
        return null;
    }

    public ObjectData moveObject(CallContext context, String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        LOG.debug((Object)"start moveObject()");
        StoredObject[] sos = this.validator.moveObject(context, repositoryId, objectId, targetFolderId, sourceFolderId, extension);
        StoredObject so = sos[0];
        Folder targetFolder = null;
        Folder sourceFolder = null;
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        Filing spo = null;
        if (null == so) {
            throw new CmisObjectNotFoundException("Unknown object: " + (String)objectId.getValue());
        }
        if (!(so instanceof Filing)) {
            throw new CmisInvalidArgumentException("Object must be folder or document: " + (String)objectId.getValue());
        }
        spo = (Filing)((Object)so);
        StoredObject soTarget = objectStore.getObjectById(targetFolderId);
        if (null == soTarget) {
            throw new CmisObjectNotFoundException("Unknown target folder: " + targetFolderId);
        }
        if (!(soTarget instanceof Folder)) {
            throw new CmisNotSupportedException("Destination " + targetFolderId + " of a move operation must be a folder");
        }
        targetFolder = (Folder)soTarget;
        StoredObject soSource = objectStore.getObjectById(sourceFolderId);
        if (null == soSource) {
            throw new CmisObjectNotFoundException("Unknown source folder: " + sourceFolderId);
        }
        if (!(soSource instanceof Folder)) {
            throw new CmisNotSupportedException("Source " + sourceFolderId + " of a move operation must be a folder");
        }
        sourceFolder = (Folder)soSource;
        boolean foundOldParent = false;
        for (Folder parent : spo.getParents()) {
            if (!parent.getId().equals(soSource.getId())) continue;
            foundOldParent = true;
            break;
        }
        if (!foundOldParent) {
            throw new CmisNotSupportedException("Cannot move object, source folder " + sourceFolderId + "is not a parent of object " + (String)objectId.getValue());
        }
        if (so instanceof Folder && this.hasDescendant((Folder)so, targetFolder)) {
            throw new CmisNotSupportedException("Destination of a move cannot be a subfolder of the source");
        }
        spo.move(sourceFolder, targetFolder);
        objectId.setValue((Object)so.getId());
        LOG.debug((Object)"stop moveObject()");
        TypeDefinition td = this.fStoreManager.getTypeById(repositoryId, so.getTypeId()).getTypeDefinition();
        String user = context.getUsername();
        ObjectData od = PropertyCreationHelper.getObjectData(td, so, null, user, false, IncludeRelationships.NONE, null, false, false, extension);
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, so, od, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        return od;
    }

    public void setContentStream(CallContext context, String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        StoredObject content;
        LOG.debug((Object)"start setContentStream()");
        StoredObject so = this.validator.setContentStream(context, repositoryId, objectId, overwriteFlag, extension);
        if (!(so instanceof Document || so instanceof VersionedDocument || so instanceof DocumentVersion)) {
            throw new CmisObjectNotFoundException("Id" + objectId + " does not refer to a document, but only documents can have content");
        }
        if (so instanceof Document) {
            content = (Document)so;
        } else if (so instanceof DocumentVersion) {
            String user = context.getUsername();
            this.testHasProperCheckedOutStatus(so, user);
            content = (DocumentVersion)so;
        } else {
            throw new IllegalArgumentException("Content cannot be set on this object (must be document or version)");
        }
        if (!overwriteFlag.booleanValue() && content.getContent(0L, -1L) != null) {
            throw new CmisContentAlreadyExistsException("cannot overwrite existing content if overwrite flag is not set");
        }
        content.setContent(contentStream, true);
        LOG.debug((Object)"stop setContentStream()");
    }

    public void updateProperties(CallContext context, String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, Acl acl, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        LOG.debug((Object)"start updateProperties()");
        StoredObject so = this.validator.updateProperties(context, repositoryId, objectId, extension);
        TypeDefinition typeDef = this.getTypeDefinition(repositoryId, so);
        boolean isCheckedOut = false;
        if (so instanceof VersionedDocument || so instanceof DocumentVersion) {
            String user = context.getUsername();
            this.testHasProperCheckedOutStatus(so, user);
            isCheckedOut = true;
        }
        Map<String, PropertyData<?>> oldProperties = so.getProperties();
        TypeValidator.validateProperties((TypeDefinition)typeDef, (Properties)properties, (boolean)false);
        if (changeToken != null && changeToken.getValue() != null && Long.valueOf(so.getChangeToken()) > Long.valueOf((String)changeToken.getValue())) {
            throw new CmisUpdateConflictException(" updateProperties failed: outdated changeToken");
        }
        boolean hasUpdatedName = false;
        boolean hasUpdatedOtherProps = false;
        for (String key : properties.getProperties().keySet()) {
            if (key.equals("cmis:name")) continue;
            PropertyData value = (PropertyData)properties.getProperties().get(key);
            PropertyDefinition propDef = (PropertyDefinition)typeDef.getPropertyDefinitions().get(key);
            if (value.getValues() == null || value.getFirstValue() == null) {
                if (propDef.isRequired().booleanValue()) {
                    throw new CmisConstraintException("updateProperties failed, following property can't be deleted, because it is required: " + key);
                }
                oldProperties.remove(key);
                hasUpdatedOtherProps = true;
                continue;
            }
            if (propDef.getUpdatability().equals((Object)Updatability.WHENCHECKEDOUT) && !isCheckedOut) {
                throw new CmisConstraintException("updateProperties failed, following property can't be updated, because it is not checked-out: " + key);
            }
            if (!propDef.getUpdatability().equals((Object)Updatability.READWRITE)) {
                throw new CmisConstraintException("updateProperties failed, following property can't be updated, because it is not writable: " + key);
            }
            oldProperties.put(key, value);
            hasUpdatedOtherProps = true;
        }
        PropertyData pd = (PropertyData)properties.getProperties().get("cmis:name");
        if (pd != null && so instanceof Filing) {
            String newName = (String)pd.getFirstValue();
            List<Folder> parents = ((Filing)((Object)so)).getParents();
            if (so instanceof Folder && parents.isEmpty()) {
                throw new CmisConstraintException("updateProperties failed, you cannot rename the root folder");
            }
            if (newName == null || newName.equals("")) {
                throw new CmisConstraintException("updateProperties failed, name must not be empty.");
            }
            so.rename((String)pd.getFirstValue());
            hasUpdatedName = true;
        }
        if (hasUpdatedOtherProps) {
            String user = context.getUsername();
            if (user == null) {
                user = "unknown";
            }
            so.updateSystemBasePropertiesWhenModified(properties.getProperties(), user);
            so.persist();
        }
        if (hasUpdatedName || hasUpdatedOtherProps) {
            objectId.setValue((Object)so.getId());
            if (null != changeToken) {
                String changeTokenVal = so.getChangeToken();
                LOG.debug((Object)("updateProperties(), new change token is: " + changeTokenVal));
                changeToken.setValue((Object)changeTokenVal);
            }
        }
        if (null != acl) {
            LOG.warn((Object)"Setting ACLs is currently not supported by this implementation, acl is ignored");
        }
        TypeDefinition td = this.fStoreManager.getTypeById(repositoryId, so.getTypeId()).getTypeDefinition();
        String user = context.getUsername();
        ObjectData od = PropertyCreationHelper.getObjectData(td, so, null, user, false, IncludeRelationships.NONE, null, false, false, extension);
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, so, od, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        LOG.debug((Object)"stop updateProperties()");
    }

    private StoredObject createDocumentIntern(CallContext context, String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        String user = context.getUsername();
        this.validator.createDocument(context, repositoryId, folderId, extension);
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        Map<String, PropertyData<?>> propMap = properties.getProperties();
        PropertyData pd = (PropertyData)propMap.get("cmis:name");
        String name = (String)pd.getFirstValue();
        TypeValidator.validateRequiredSystemProperties((Properties)properties);
        TypeDefinition typeDef = this.getTypeDefinition(repositoryId, properties);
        Folder folder = null;
        if (null != folderId) {
            StoredObject so = objectStore.getObjectById(folderId);
            if (null == so) {
                throw new CmisInvalidArgumentException(" Cannot create document, folderId: " + folderId + " is invalid");
            }
            if (!(so instanceof Folder)) {
                throw new CmisInvalidArgumentException("Can't creat document, folderId does not refer to a folder: " + folderId);
            }
            folder = (Folder)so;
            TypeValidator.validateAllowedChildObjectTypes((TypeDefinition)typeDef, folder.getAllowedChildObjectTypeIds());
        }
        if (!typeDef.getBaseTypeId().equals((Object)BaseTypeId.CMIS_DOCUMENT)) {
            throw new CmisInvalidArgumentException("Cannot create a document, with a non-document type: " + typeDef.getId());
        }
        if (!NameValidator.isValidId(name)) {
            throw new CmisInvalidArgumentException("Id contains illegal characters, allowed are 'a'..'z', 'A'..'Z', '0'..'9', '-', '_', '.', ' '");
        }
        TypeValidator.validateVersionStateForCreate((DocumentTypeDefinition)((DocumentTypeDefinition)typeDef), (VersioningState)versioningState);
        Map<String, PropertyData<?>> propMapNew = this.setDefaultProperties(typeDef, propMap);
        if (propMapNew != propMap) {
            properties = new PropertiesImpl(propMapNew.values());
            propMap = propMapNew;
        }
        TypeValidator.validateProperties((TypeDefinition)typeDef, (Properties)properties, (boolean)true);
        if (user == null) {
            user = "unknown";
        }
        StoredObject so = null;
        if (null != contentStream && (contentStream.getFileName() == null || contentStream.getFileName().length() == 0 || contentStream.getMimeType() == null || contentStream.getMimeType().length() == 0)) {
            ContentStreamImpl cs = new ContentStreamImpl();
            cs.setStream(contentStream.getStream());
            if (contentStream.getFileName() == null || contentStream.getFileName().length() == 0) {
                cs.setFileName(name);
            } else {
                cs.setFileName(contentStream.getFileName());
            }
            cs.setLength(contentStream.getBigLength());
            if (contentStream.getMimeType() == null || contentStream.getMimeType().length() == 0) {
                cs.setMimeType("application/octet-stream");
            } else {
                cs.setMimeType(contentStream.getMimeType());
            }
            cs.setExtensions(contentStream.getExtensions());
            contentStream = cs;
        }
        if (((DocumentTypeDefinition)typeDef).isVersionable().booleanValue()) {
            VersionedDocument verDoc = this.fStoreManager.getObjectStore(repositoryId).createVersionedDocument(name);
            verDoc.createSystemBasePropertiesWhenCreated(properties.getProperties(), user);
            verDoc.setCustomProperties(properties.getProperties());
            DocumentVersion version = verDoc.addVersion(contentStream, versioningState, user);
            if (null != folder) {
                folder.addChildDocument(verDoc);
            } else {
                verDoc.persist();
            }
            version.createSystemBasePropertiesWhenCreated(propMap, user);
            version.setCustomProperties(propMap);
            version.persist();
            so = version;
        } else {
            Document doc = this.fStoreManager.getObjectStore(repositoryId).createDocument(name);
            doc.setContent(contentStream, false);
            doc.createSystemBasePropertiesWhenCreated(propMap, user);
            doc.setCustomProperties(propMap);
            if (null != folder) {
                folder.addChildDocument(doc);
            } else {
                doc.persist();
            }
            so = doc;
        }
        return so;
    }

    private Folder createFolderIntern(CallContext context, String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        String user = context.getUsername();
        this.validator.createFolder(context, repositoryId, folderId, extension);
        ObjectStore fs = this.fStoreManager.getObjectStore(repositoryId);
        StoredObject so = null;
        Folder parent = null;
        PropertyData pd = (PropertyData)properties.getProperties().get("cmis:name");
        String folderName = (String)pd.getFirstValue();
        if (null == folderName || folderName.length() == 0) {
            throw new CmisInvalidArgumentException("Cannot create a folder without a name.");
        }
        if (!NameValidator.isValidId(folderName)) {
            throw new CmisInvalidArgumentException("Id contains illegal characters, allowed are 'a'..'z', 'A'..'Z', '0'..'9', '-', '_', '.', ' '");
        }
        TypeValidator.validateRequiredSystemProperties((Properties)properties);
        TypeDefinition typeDef = this.getTypeDefinition(repositoryId, properties);
        if (!typeDef.getBaseTypeId().equals((Object)BaseTypeId.CMIS_FOLDER)) {
            throw new CmisInvalidArgumentException("Cannot create a folder, with a non-folder type: " + typeDef.getId());
        }
        Map propMap = properties.getProperties();
        Map<String, PropertyData<?>> propMapNew = this.setDefaultProperties(typeDef, propMap);
        if (propMapNew != propMap) {
            properties = new PropertiesImpl(propMapNew.values());
        }
        TypeValidator.validateProperties((TypeDefinition)typeDef, (Properties)properties, (boolean)true);
        try {
            LOG.debug((Object)("get folder for id: " + folderId));
            so = fs.getObjectById(folderId);
        }
        catch (Exception e) {
            throw new CmisObjectNotFoundException("Failed to retrieve folder.", (Throwable)e);
        }
        if (!(so instanceof Folder)) {
            throw new CmisInvalidArgumentException("Can't create folder, folderId does not refer to a folder: " + folderId);
        }
        parent = (Folder)so;
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        Folder newFolder = objStore.createFolder(folderName);
        if (user == null) {
            user = "unknown";
        }
        newFolder.createSystemBasePropertiesWhenCreated(properties.getProperties(), user);
        newFolder.setCustomProperties(properties.getProperties());
        parent.addChildFolder(newFolder);
        LOG.debug((Object)"stop createFolder()");
        return newFolder;
    }

    private StoredObject createPolicyIntern(CallContext context, String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.validator.createPolicy(context, repositoryId, folderId, extension);
        throw new CmisNotSupportedException("createPolicy is not supported.");
    }

    private StoredObject createRelationshipIntern(CallContext context, String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.validator.createRelationship(context, repositoryId, extension);
        throw new CmisNotSupportedException("createRelationship is not supported.");
    }

    private boolean hasDescendant(Folder sourceFolder, Folder targetFolder) {
        String sourceId = sourceFolder.getId();
        String targetId = targetFolder.getId();
        while (targetId != null) {
            if (targetId.equals(sourceId)) {
                return true;
            }
            if (null != (targetFolder = targetFolder.getParent())) {
                targetId = targetFolder.getId();
                continue;
            }
            targetId = null;
        }
        return false;
    }

    private boolean deleteRecursive(ObjectStore folderStore, Folder parentFolder, boolean continueOnFailure, boolean allVersions, List<String> failedToDeleteIds) {
        List<StoredObject> children = parentFolder.getChildren(-1, -1);
        if (null == children) {
            return true;
        }
        for (StoredObject child : children) {
            if (child instanceof Folder) {
                boolean mustContinue = this.deleteRecursive(folderStore, (Folder)child, continueOnFailure, allVersions, failedToDeleteIds);
                if (mustContinue || continueOnFailure) continue;
                return false;
            }
            try {
                folderStore.deleteObject(child.getId());
            }
            catch (Exception e) {
                failedToDeleteIds.add(child.getId());
            }
        }
        folderStore.deleteObject(parentFolder.getId());
        return true;
    }

    private ContentStream getContentStream(StoredObject so, String streamId, BigInteger offset, BigInteger length) {
        if (streamId != null) {
            return null;
        }
        long lOffset = offset == null ? 0L : offset.longValue();
        long lLength = length == null ? -1L : length.longValue();
        ContentStream csd = ((Content)((Object)so)).getContent(lOffset, lLength);
        return csd;
    }

    private Map<String, PropertyData<?>> setDefaultProperties(TypeDefinition typeDef, Map<String, PropertyData<?>> properties) {
        Map propDefs = typeDef.getPropertyDefinitions();
        boolean hasCopied = false;
        for (PropertyDefinition propDef : propDefs.values()) {
            String propId = propDef.getId();
            List defaultVal = propDef.getDefaultValue();
            PropertyBoolean pd = null;
            if (defaultVal == null || null != properties.get(propId)) continue;
            if (!hasCopied) {
                properties = new HashMap(properties);
                hasCopied = true;
            }
            if (propDef.getPropertyType() == PropertyType.BOOLEAN) {
                pd = propDef.getCardinality() == Cardinality.MULTI ? this.fStoreManager.getObjectFactory().createPropertyBooleanData(propId, defaultVal) : this.fStoreManager.getObjectFactory().createPropertyBooleanData(propId, (Boolean)defaultVal.get(0));
            } else if (propDef.getPropertyType() == PropertyType.DATETIME) {
                pd = propDef.getCardinality() == Cardinality.MULTI ? this.fStoreManager.getObjectFactory().createPropertyDateTimeData(propId, defaultVal) : this.fStoreManager.getObjectFactory().createPropertyDateTimeData(propId, (GregorianCalendar)defaultVal.get(0));
            } else if (propDef.getPropertyType() == PropertyType.DECIMAL) {
                pd = propDef.getCardinality() == Cardinality.MULTI ? this.fStoreManager.getObjectFactory().createPropertyDecimalData(propId, defaultVal) : this.fStoreManager.getObjectFactory().createPropertyDecimalData(propId, (BigDecimal)defaultVal.get(0));
            } else if (propDef.getPropertyType() == PropertyType.HTML) {
                pd = propDef.getCardinality() == Cardinality.MULTI ? this.fStoreManager.getObjectFactory().createPropertyHtmlData(propId, defaultVal) : this.fStoreManager.getObjectFactory().createPropertyHtmlData(propId, (String)defaultVal.get(0));
            } else if (propDef.getPropertyType() == PropertyType.ID) {
                pd = propDef.getCardinality() == Cardinality.MULTI ? this.fStoreManager.getObjectFactory().createPropertyIdData(propId, defaultVal) : this.fStoreManager.getObjectFactory().createPropertyIdData(propId, (String)defaultVal.get(0));
            } else if (propDef.getPropertyType() == PropertyType.INTEGER) {
                pd = propDef.getCardinality() == Cardinality.MULTI ? this.fStoreManager.getObjectFactory().createPropertyIntegerData(propId, defaultVal) : this.fStoreManager.getObjectFactory().createPropertyIntegerData(propId, (BigInteger)defaultVal.get(0));
            } else if (propDef.getPropertyType() == PropertyType.STRING) {
                pd = propDef.getCardinality() == Cardinality.MULTI ? this.fStoreManager.getObjectFactory().createPropertyStringData(propId, defaultVal) : this.fStoreManager.getObjectFactory().createPropertyStringData(propId, (String)defaultVal.get(0));
            } else if (propDef.getPropertyType() == PropertyType.URI) {
                pd = propDef.getCardinality() == Cardinality.MULTI ? this.fStoreManager.getObjectFactory().createPropertyUriData(propId, defaultVal) : this.fStoreManager.getObjectFactory().createPropertyUriData(propId, (String)defaultVal.get(0));
            }
            properties.put(propId, (PropertyData<?>)pd);
        }
        return properties;
    }
}

