/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectParentDataImpl;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.inmemory.DataObjectCreator;
import org.apache.chemistry.opencmis.inmemory.FilterParser;
import org.apache.chemistry.opencmis.inmemory.server.AtomLinkInfoProvider;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryAbstractServiceImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Filing;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Folder;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.MultiFiling;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.SingleFiling;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;
import org.apache.chemistry.opencmis.inmemory.types.PropertyCreationHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryNavigationServiceImpl
extends InMemoryAbstractServiceImpl {
    private static Log LOG = LogFactory.getLog(InMemoryNavigationServiceImpl.class);
    AtomLinkInfoProvider fAtomLinkProvider;

    public InMemoryNavigationServiceImpl(StoreManager storeManager) {
        super(storeManager);
        this.fAtomLinkProvider = new AtomLinkInfoProvider(this.fStoreManager);
    }

    public ObjectList getCheckedOutDocs(CallContext context, String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        this.validator.getCheckedOutDocs(context, repositoryId, folderId, extension);
        ObjectListImpl res = new ObjectListImpl();
        ArrayList<ObjectData> odList = new ArrayList<ObjectData>();
        LOG.debug((Object)"start getCheckedOutDocs()");
        String user = context.getUsername();
        if (null == folderId) {
            List<VersionedDocument> checkedOuts = this.fStoreManager.getObjectStore(repositoryId).getCheckedOutDocuments(orderBy);
            for (VersionedDocument checkedOut : checkedOuts) {
                TypeDefinition td = this.fStoreManager.getTypeById(repositoryId, checkedOut.getTypeId()).getTypeDefinition();
                ObjectData od = PropertyCreationHelper.getObjectData(td, checkedOut, filter, user, includeAllowableActions, includeRelationships, renditionFilter, false, false, extension);
                if (context.isObjectInfoRequired()) {
                    ObjectInfoImpl objectInfo = new ObjectInfoImpl();
                    this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, checkedOut, objectInfo);
                    objectInfos.addObjectInfo((ObjectInfo)objectInfo);
                }
                odList.add(od);
            }
        } else {
            ObjectInFolderList children = this.getChildrenIntern(repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, false, -1, -1, false, (ObjectInfoHandler)(context.isObjectInfoRequired() ? objectInfos : null), user);
            for (ObjectInFolderData child : children.getObjects()) {
                ObjectData obj = child.getObject();
                StoredObject so = this.fStoreManager.getObjectStore(repositoryId).getObjectById(obj.getId());
                LOG.info((Object)("Checked out: children:" + obj.getId()));
                if (!(so instanceof DocumentVersion) || !((DocumentVersion)so).getParentDocument().isCheckedOut()) continue;
                odList.add(obj);
                if (!context.isObjectInfoRequired()) continue;
                ObjectInfoImpl objectInfo = new ObjectInfoImpl();
                this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, so, objectInfo);
                objectInfos.addObjectInfo((ObjectInfo)objectInfo);
            }
        }
        res.setObjects(odList);
        res.setNumItems(BigInteger.valueOf(odList.size()));
        LOG.debug((Object)"end getCheckedOutDocs()");
        return res;
    }

    public ObjectInFolderList getChildren(CallContext context, String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        LOG.debug((Object)"start getChildren()");
        this.validator.getChildren(repositoryId, folderId, extension);
        int maxItemsInt = maxItems == null ? -1 : maxItems.intValue();
        int skipCountInt = skipCount == null ? -1 : skipCount.intValue();
        String user = context.getUsername();
        ObjectInFolderList res = this.getChildrenIntern(repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, maxItemsInt, skipCountInt, false, (ObjectInfoHandler)(context.isObjectInfoRequired() ? objectInfos : null), user);
        LOG.debug((Object)"stop getChildren()");
        return res;
    }

    public List<ObjectInFolderContainer> getDescendants(CallContext context, String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        int levels;
        LOG.debug((Object)"start getDescendants()");
        this.validator.getDescendants(context, repositoryId, folderId, extension);
        if (depth == null) {
            levels = 2;
        } else {
            if (depth.intValue() == 0) {
                throw new CmisInvalidArgumentException("A zero depth is not allowed for getDescendants().");
            }
            levels = depth.intValue();
        }
        int level = 0;
        String user = context.getUsername();
        List<ObjectInFolderContainer> result = this.getDescendantsIntern(repositoryId, folderId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, level, levels, false, objectInfos, user);
        LOG.debug((Object)"stop getDescendants()");
        return result;
    }

    public ObjectData getFolderParent(CallContext context, String repositoryId, String folderId, String filter, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        LOG.debug((Object)"start getFolderParent()");
        StoredObject so = this.validator.getFolderParent(context, repositoryId, folderId, extension);
        Folder folder = null;
        if (!(so instanceof Folder)) {
            throw new CmisInvalidArgumentException("Can't get folder parent, id does not refer to a folder: " + folderId);
        }
        folder = (Folder)so;
        ObjectData res = this.getFolderParentIntern(repositoryId, folder, filter, (ObjectInfoHandler)(context.isObjectInfoRequired() ? objectInfos : null));
        if (res == null) {
            throw new CmisInvalidArgumentException("Cannot get parent of a root folder");
        }
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, so, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        LOG.debug((Object)"stop getFolderParent()");
        return res;
    }

    public List<ObjectInFolderContainer> getFolderTree(CallContext context, String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        LOG.debug((Object)"start getFolderTree()");
        this.validator.getFolderTree(context, repositoryId, folderId, extension);
        if (depth != null && depth.intValue() == 0) {
            throw new CmisInvalidArgumentException("A zero depth is not allowed for getFolderTree().");
        }
        int levels = depth == null ? 2 : depth.intValue();
        int level = 0;
        String user = context.getUsername();
        List<ObjectInFolderContainer> result = this.getDescendantsIntern(repositoryId, folderId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, level, levels, true, objectInfos, user);
        LOG.debug((Object)"stop getFolderTree()");
        return result;
    }

    public List<ObjectParentData> getObjectParents(CallContext context, String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        LOG.debug((Object)"start getObjectParents()");
        StoredObject so = this.validator.getObjectParents(context, repositoryId, objectId, extension);
        List<ObjectParentData> result = null;
        Filing spo = null;
        if (!(so instanceof Filing)) {
            return Collections.emptyList();
        }
        spo = (Filing)((Object)so);
        result = this.getObjectParentsIntern(repositoryId, spo, filter, (ObjectInfoHandler)(context.isObjectInfoRequired() ? objectInfos : null));
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, so, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        LOG.debug((Object)"stop getObjectParents()");
        return result;
    }

    private ObjectInFolderList getChildrenIntern(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegments, int maxItems, int skipCount, boolean folderOnly, ObjectInfoHandler objectInfos, String user) {
        ObjectInFolderListImpl result = new ObjectInFolderListImpl();
        ArrayList<ObjectInFolderDataImpl> folderList = new ArrayList<ObjectInFolderDataImpl>();
        ObjectStore fs = this.fStoreManager.getObjectStore(repositoryId);
        StoredObject so = fs.getObjectById(folderId);
        Folder folder = null;
        if (so == null) {
            throw new CmisObjectNotFoundException("Unknown object id: " + folderId);
        }
        if (!(so instanceof Folder)) {
            return null;
        }
        folder = (Folder)so;
        List<StoredObject> children = folderOnly ? folder.getFolderChildren(maxItems, skipCount) : folder.getChildren(maxItems, skipCount);
        List<String> requestedIds = FilterParser.getRequestedIdsFromFilter(filter);
        for (StoredObject spo : children) {
            ObjectInFolderDataImpl oifd = new ObjectInFolderDataImpl();
            ObjectDataImpl objectData = new ObjectDataImpl();
            if (includePathSegments != null && includePathSegments.booleanValue()) {
                oifd.setPathSegment(spo.getName());
            }
            if (includeAllowableActions != null && includeAllowableActions.booleanValue()) {
                AllowableActions allowableActions = DataObjectCreator.fillAllowableActions(spo, user);
                objectData.setAllowableActions(allowableActions);
            }
            if (includeRelationships != null && includeRelationships != IncludeRelationships.NONE) {
                objectData.setRelationships(null);
            }
            if (renditionFilter != null && renditionFilter.length() > 0) {
                objectData.setRelationships(null);
            }
            TypeDefinition td = this.fStoreManager.getTypeById(repositoryId, spo.getTypeId()).getTypeDefinition();
            Properties props = PropertyCreationHelper.getPropertiesFromObject(spo, td, requestedIds, true);
            objectData.setProperties(props);
            oifd.setObject((ObjectData)objectData);
            folderList.add(oifd);
            if (objectInfos == null) continue;
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, spo, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        result.setObjects(folderList);
        result.setNumItems(BigInteger.valueOf(folderList.size()));
        if (objectInfos != null) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, so, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        return result;
    }

    private List<ObjectInFolderContainer> getDescendantsIntern(String repositoryId, String folderId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegments, int level, int maxLevels, boolean folderOnly, ObjectInfoHandler objectInfos, String user) {
        ArrayList<ObjectInFolderContainerImpl> childrenOfFolderId = null;
        if (maxLevels == -1 || level < maxLevels) {
            String orderBy = "cmis:name";
            ObjectInFolderList children = this.getChildrenIntern(repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, includePathSegments, 1000, 0, folderOnly, objectInfos, user);
            childrenOfFolderId = new ArrayList<ObjectInFolderContainerImpl>();
            if (null != children) {
                for (ObjectInFolderData child : children.getObjects()) {
                    ObjectInFolderContainerImpl oifc = new ObjectInFolderContainerImpl();
                    String childId = child.getObject().getId();
                    List<ObjectInFolderContainer> subChildren = this.getDescendantsIntern(repositoryId, childId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegments, level + 1, maxLevels, folderOnly, objectInfos, user);
                    oifc.setObject(child);
                    if (null != subChildren) {
                        oifc.setChildren(subChildren);
                    }
                    childrenOfFolderId.add(oifc);
                }
            }
        }
        return childrenOfFolderId;
    }

    private List<ObjectParentData> getObjectParentsIntern(String repositoryId, Filing sop, String filter, ObjectInfoHandler objectInfos) {
        List<Object> result = null;
        if (sop instanceof SingleFiling) {
            ObjectData parent = this.getFolderParentIntern(repositoryId, (SingleFiling)sop, filter, objectInfos);
            if (null != parent) {
                ObjectParentDataImpl parentData = new ObjectParentDataImpl();
                parentData.setObject(parent);
                String path = ((SingleFiling)sop).getPath();
                int beginIndex = path.lastIndexOf("/") + 1;
                String relPathSeg = path.substring(beginIndex, path.length());
                parentData.setRelativePathSegment(relPathSeg);
                result = Collections.singletonList(parentData);
            } else {
                result = Collections.emptyList();
            }
        } else if (sop instanceof MultiFiling) {
            result = new ArrayList();
            MultiFiling multiParentObj = (MultiFiling)sop;
            List<Folder> parents = multiParentObj.getParents();
            if (null != parents) {
                for (Folder parent : parents) {
                    ObjectParentDataImpl parentData = new ObjectParentDataImpl();
                    ObjectDataImpl objData = new ObjectDataImpl();
                    this.copyFilteredProperties(repositoryId, parent, filter, objData);
                    parentData.setObject((ObjectData)objData);
                    parentData.setRelativePathSegment(multiParentObj.getPathSegment());
                    result.add(parentData);
                    if (objectInfos == null) continue;
                    ObjectInfoImpl objectInfo = new ObjectInfoImpl();
                    this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, parent, objectInfo);
                    objectInfos.addObjectInfo((ObjectInfo)objectInfo);
                }
            }
        }
        return result;
    }

    private ObjectData getFolderParentIntern(String repositoryId, SingleFiling sop, String filter, ObjectInfoHandler objectInfos) {
        ObjectDataImpl parent = new ObjectDataImpl();
        Folder parentFolder = sop.getParent();
        if (null == parentFolder) {
            return null;
        }
        this.copyFilteredProperties(repositoryId, parentFolder, filter, parent);
        if (objectInfos != null) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, parentFolder, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        return parent;
    }

    void copyFilteredProperties(String repositoryId, StoredObject so, String filter, ObjectDataImpl objData) {
        List<String> requestedIds = FilterParser.getRequestedIdsFromFilter(filter);
        TypeDefinition td = this.fStoreManager.getTypeById(repositoryId, so.getTypeId()).getTypeDefinition();
        Properties props = PropertyCreationHelper.getPropertiesFromObject(so, td, requestedIds, true);
        objData.setProperties(props);
    }
}

