/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.inmemory.server.AtomLinkInfoProvider;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryAbstractServiceImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Folder;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.MultiFiling;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InMemoryMultiFilingServiceImpl
extends InMemoryAbstractServiceImpl {
    private static final Log LOG = LogFactory.getLog((String)InMemoryMultiFilingServiceImpl.class.getName());
    AtomLinkInfoProvider fAtomLinkProvider;

    public InMemoryMultiFilingServiceImpl(StoreManager storeMgr) {
        super(storeMgr);
        this.fAtomLinkProvider = new AtomLinkInfoProvider(storeMgr);
    }

    public void addObjectToFolder(CallContext context, String repositoryId, String objectId, String folderId, Boolean allVersions, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        LOG.debug((Object)"Begin addObjectToFolder()");
        StoredObject[] sos = this.validator.addObjectToFolder(context, repositoryId, objectId, folderId, allVersions, extension);
        if (allVersions != null && !allVersions.booleanValue()) {
            throw new CmisNotSupportedException("Cannot add object to folder, version specific filing is not supported.");
        }
        StoredObject so = sos[0];
        StoredObject folder = sos[1];
        this.checkObjects(so, folder);
        Folder newParent = (Folder)folder;
        MultiFiling obj = (MultiFiling)((Object)so);
        obj.addParent(newParent);
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, so, objectInfo);
            this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, folder, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        LOG.debug((Object)"End addObjectToFolder()");
    }

    public void removeObjectFromFolder(CallContext context, String repositoryId, String objectId, String folderId, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        LOG.debug((Object)"Begin removeObjectFromFolder()");
        StoredObject[] sos = this.validator.removeObjectFromFolder(context, repositoryId, objectId, folderId, extension);
        StoredObject so = sos[0];
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        StoredObject folder = sos[1];
        this.checkObjects(so, folder);
        Folder parent = (Folder)folder;
        MultiFiling obj = (MultiFiling)((Object)so);
        obj.removeParent(parent);
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, so, objectInfo);
            this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, folder, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        LOG.debug((Object)"End removeObjectFromFolder()");
    }

    private void checkObjects(StoredObject so, StoredObject folder) {
        if (!(so instanceof MultiFiling)) {
            throw new CmisConstraintException("Cannot add object to folder, object id " + so.getId() + " is not a multi-filed object.");
        }
        if (so instanceof Folder) {
            throw new CmisConstraintException("Cannot add object to folder, object id " + folder.getId() + " is a folder and folders are not multi-filed.");
        }
        if (!(folder instanceof Folder)) {
            throw new CmisConstraintException("Cannot add object to folder, folder id " + folder.getId() + " does not refer to a folder.");
        }
    }
}

