/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.ChangeEventInfo;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.ChangeType;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChangeEventInfoDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.inmemory.server.AtomLinkInfoProvider;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryAbstractServiceImpl;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryNavigationServiceImpl;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryRepositoryServiceImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryDiscoveryServiceImpl
extends InMemoryAbstractServiceImpl {
    private static Log LOG = LogFactory.getLog(InMemoryDiscoveryServiceImpl.class);
    AtomLinkInfoProvider fAtomLinkProvider;
    InMemoryNavigationServiceImpl fNavigationService;
    InMemoryRepositoryServiceImpl fRepositoryService;

    public InMemoryDiscoveryServiceImpl(StoreManager storeManager, InMemoryRepositoryServiceImpl repSvc, InMemoryNavigationServiceImpl navSvc) {
        super(storeManager);
        this.fAtomLinkProvider = new AtomLinkInfoProvider(this.fStoreManager);
        this.fNavigationService = navSvc;
        this.fRepositoryService = repSvc;
    }

    public ObjectList getContentChanges(CallContext context, String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeAcl, BigInteger maxItems, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        RepositoryInfo rep = this.fRepositoryService.getRepositoryInfo(context, repositoryId, null);
        String rootFolderId = rep.getRootFolderId();
        ObjectListImpl objList = new ObjectListImpl();
        List<ObjectInFolderContainer> tempRes = this.fNavigationService.getDescendants(context, repositoryId, rootFolderId, BigInteger.valueOf(3L), filter, false, IncludeRelationships.NONE, null, false, extension, null);
        ArrayList<ObjectData> lod = new ArrayList<ObjectData>();
        for (ObjectInFolderContainer obj : tempRes) {
            this.convertList(lod, obj);
        }
        objList.setObjects(lod);
        objList.setNumItems(BigInteger.valueOf(lod.size()));
        this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, null, objectInfos, (ObjectList)objList);
        return objList;
    }

    private void convertList(List<ObjectData> lod, ObjectInFolderContainer obj) {
        lod.add(obj.getObject().getObject());
        ObjectData oif = obj.getObject().getObject();
        ObjectDataImpl oifImpl = (ObjectDataImpl)oif;
        ChangeEventInfoDataImpl changeEventInfo = new ChangeEventInfoDataImpl();
        changeEventInfo.setChangeType(ChangeType.UPDATED);
        changeEventInfo.setChangeTime(new GregorianCalendar());
        oifImpl.setChangeEventInfo((ChangeEventInfo)changeEventInfo);
        if (null != obj.getChildren()) {
            for (ObjectInFolderContainer oifc : obj.getChildren()) {
                this.convertList(lod, oifc);
            }
        }
    }

    public ObjectList query(CallContext context, String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        LOG.debug((Object)"start query()");
        this.validator.query(context, repositoryId, extension);
        String user = context.getUsername();
        ObjectList res = this.fStoreManager.query(user, repositoryId, statement, searchAllVersions, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount);
        LOG.debug((Object)"stop query()");
        return res;
    }
}

