/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.CmisServiceValidator;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;

public class InMemoryAbstractServiceImpl {
    protected StoreManager fStoreManager;
    protected CmisServiceValidator validator;

    protected InMemoryAbstractServiceImpl(StoreManager storeManager, CmisServiceValidator validator) {
        this.fStoreManager = storeManager;
        this.validator = validator;
    }

    protected InMemoryAbstractServiceImpl(StoreManager storeManager) {
        this.fStoreManager = storeManager;
        this.validator = storeManager.getServiceValidator();
    }

    protected TypeDefinition getTypeDefinition(String repositoryId, Properties properties) {
        String typeId = (String)((PropertyData)properties.getProperties().get("cmis:objectTypeId")).getFirstValue();
        TypeDefinitionContainer typeDefC = this.fStoreManager.getTypeById(repositoryId, typeId);
        if (typeDefC == null) {
            throw new CmisInvalidArgumentException("Cannot create object, a type with id " + typeId + " is unknown");
        }
        return typeDefC.getTypeDefinition();
    }

    protected TypeDefinition getTypeDefinition(String repositoryId, StoredObject obj) {
        TypeDefinitionContainer typeDefC = this.fStoreManager.getTypeById(repositoryId, obj.getTypeId());
        return typeDefC.getTypeDefinition();
    }

    protected VersionedDocument getVersionedDocumentOfObjectId(StoredObject so) {
        VersionedDocument verDoc = so instanceof DocumentVersion ? ((DocumentVersion)so).getParentDocument() : (VersionedDocument)so;
        return verDoc;
    }

    protected VersionedDocument testIsNotCheckedOutBySomeoneElse(StoredObject so, String user) {
        this.checkIsVersionableObject(so);
        VersionedDocument verDoc = this.getVersionedDocumentOfObjectId(so);
        if (verDoc.isCheckedOut()) {
            this.testCheckedOutByCurrentUser(user, verDoc);
        }
        return verDoc;
    }

    protected VersionedDocument testHasProperCheckedOutStatus(StoredObject so, String user) {
        this.checkIsVersionableObject(so);
        VersionedDocument verDoc = this.getVersionedDocumentOfObjectId(so);
        this.checkHasUser(user);
        this.testIsCheckedOut(verDoc);
        this.testCheckedOutByCurrentUser(user, verDoc);
        return verDoc;
    }

    protected void checkIsVersionableObject(StoredObject so) {
        if (!(so instanceof VersionedDocument) && !(so instanceof DocumentVersion)) {
            throw new CmisInvalidArgumentException("Object is of a versionable type but not instance of VersionedDocument or DocumentVersion.");
        }
    }

    protected void checkHasUser(String user) {
        if (null == user || user.length() == 0) {
            throw new CmisPermissionDeniedException("Object can't be checked-in, no user is given.");
        }
    }

    protected void testCheckedOutByCurrentUser(String user, VersionedDocument verDoc) {
        if (!user.equals(verDoc.getCheckedOutBy())) {
            throw new CmisUpdateConflictException("Object can't be checked-in, user " + verDoc.getCheckedOutBy() + " has checked out the document.");
        }
    }

    protected void testIsCheckedOut(VersionedDocument verDoc) {
        if (!verDoc.isCheckedOut()) {
            throw new CmisUpdateConflictException("Canot check-in: Document " + verDoc.getId() + " is not checked out.");
        }
    }
}

