/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.CmisServiceValidator;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseServiceValidatorImpl
implements CmisServiceValidator {
    protected StoreManager fStoreManager;

    public BaseServiceValidatorImpl(StoreManager sm) {
        this.fStoreManager = sm;
    }

    protected StoredObject checkStandardParameters(String repositoryId, String objectId) {
        if (null == repositoryId) {
            throw new CmisInvalidArgumentException("Repository Id cannot be null.");
        }
        if (null == objectId) {
            throw new CmisInvalidArgumentException("Object Id cannot be null.");
        }
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        if (objStore == null) {
            throw new CmisObjectNotFoundException("Unknown repository id: " + repositoryId);
        }
        StoredObject so = objStore.getObjectById(objectId);
        if (so == null) {
            throw new CmisObjectNotFoundException("Unknown object id: " + objectId);
        }
        return so;
    }

    protected StoredObject checkStandardParametersAllowNull(String repositoryId, String objectId) {
        StoredObject so = null;
        if (null == repositoryId) {
            throw new CmisInvalidArgumentException("Repository Id cannot be null.");
        }
        if (null != objectId) {
            ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
            if (objStore == null) {
                throw new CmisObjectNotFoundException("Unknown repository id: " + repositoryId);
            }
            so = objStore.getObjectById(objectId);
            if (so == null) {
                throw new CmisObjectNotFoundException("Unknown object id: " + objectId);
            }
        }
        return so;
    }

    protected StoredObject checkExistingObjectId(ObjectStore objStore, String objectId) {
        if (null == objectId) {
            throw new CmisInvalidArgumentException("Object Id cannot be null.");
        }
        StoredObject so = objStore.getObjectById(objectId);
        if (so == null) {
            throw new CmisObjectNotFoundException("Unknown object id: " + objectId);
        }
        return so;
    }

    protected void checkRepositoryId(String repositoryId) {
        if (null == repositoryId) {
            throw new CmisInvalidArgumentException("Repository Id cannot be null.");
        }
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        if (objStore == null) {
            throw new CmisInvalidArgumentException("Unknown repository id: " + repositoryId);
        }
    }

    protected StoredObject[] checkParams(String repositoryId, String objectId1, String objectId2) {
        StoredObject[] so = new StoredObject[2];
        so[0] = this.checkStandardParameters(repositoryId, objectId1);
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        so[1] = this.checkExistingObjectId(objectStore, objectId2);
        return so;
    }

    @Override
    public void getRepositoryInfos(CallContext context, ExtensionsData extension) {
    }

    @Override
    public void getRepositoryInfo(CallContext context, String repositoryId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
    }

    @Override
    public void getTypeChildren(CallContext context, String repositoryId, String typeId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
    }

    @Override
    public void getTypeDescendants(CallContext context, String repositoryId, String typeId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
    }

    @Override
    public void getTypeDefinition(CallContext context, String repositoryId, String typeId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
    }

    @Override
    public StoredObject getChildren(String repositoryId, String folderId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, folderId);
    }

    @Override
    public StoredObject getDescendants(CallContext context, String repositoryId, String folderId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, folderId);
    }

    @Override
    public StoredObject getFolderTree(CallContext context, String repositoryId, String folderId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, folderId);
    }

    @Override
    public StoredObject getObjectParents(CallContext context, String repositoryId, String objectId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, objectId);
    }

    @Override
    public StoredObject getFolderParent(CallContext context, String repositoryId, String folderId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, folderId);
    }

    @Override
    public StoredObject getCheckedOutDocs(CallContext context, String repositoryId, String folderId, ExtensionsData extension) {
        if (null != folderId) {
            return this.checkStandardParameters(repositoryId, folderId);
        }
        this.checkRepositoryId(repositoryId);
        return null;
    }

    @Override
    public StoredObject createDocument(CallContext context, String repositoryId, String folderId, ExtensionsData extension) {
        return this.checkStandardParametersAllowNull(repositoryId, folderId);
    }

    @Override
    public StoredObject createDocumentFromSource(CallContext context, String repositoryId, String sourceId, String folderId, ExtensionsData extension) {
        return this.checkStandardParametersAllowNull(repositoryId, sourceId);
    }

    @Override
    public StoredObject createFolder(CallContext context, String repositoryId, String folderId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, folderId);
    }

    @Override
    public void createRelationship(CallContext context, String repositoryId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
    }

    @Override
    public void createPolicy(CallContext context, String repositoryId, String folderId, ExtensionsData extension) {
        this.checkStandardParameters(repositoryId, folderId);
    }

    @Override
    public StoredObject getAllowableActions(CallContext context, String repositoryId, String objectId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, objectId);
    }

    @Override
    public StoredObject getObject(CallContext context, String repositoryId, String objectId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, objectId);
    }

    @Override
    public StoredObject getProperties(CallContext context, String repositoryId, String objectId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, objectId);
    }

    @Override
    public StoredObject getRenditions(CallContext context, String repositoryId, String objectId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, objectId);
    }

    @Override
    public void getObjectByPath(CallContext context, String repositoryId, String path, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
    }

    @Override
    public StoredObject getContentStream(CallContext context, String repositoryId, String objectId, String streamId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, objectId);
    }

    @Override
    public StoredObject updateProperties(CallContext context, String repositoryId, Holder<String> objectId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, (String)objectId.getValue());
    }

    @Override
    public StoredObject[] moveObject(CallContext context, String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        StoredObject[] res = new StoredObject[]{this.checkStandardParameters(repositoryId, (String)objectId.getValue()), this.checkExistingObjectId(this.fStoreManager.getObjectStore(repositoryId), sourceFolderId), this.checkExistingObjectId(this.fStoreManager.getObjectStore(repositoryId), targetFolderId)};
        return res;
    }

    @Override
    public StoredObject deleteObject(CallContext context, String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, objectId);
    }

    @Override
    public StoredObject deleteTree(CallContext context, String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, folderId);
    }

    @Override
    public StoredObject setContentStream(CallContext context, String repositoryId, Holder<String> objectId, Boolean overwriteFlag, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, (String)objectId.getValue());
    }

    @Override
    public StoredObject deleteContentStream(CallContext context, String repositoryId, Holder<String> objectId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, (String)objectId.getValue());
    }

    @Override
    public StoredObject checkOut(CallContext context, String repositoryId, Holder<String> objectId, ExtensionsData extension, Holder<Boolean> contentCopied) {
        return this.checkStandardParameters(repositoryId, (String)objectId.getValue());
    }

    @Override
    public StoredObject cancelCheckOut(CallContext context, String repositoryId, String objectId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, objectId);
    }

    @Override
    public StoredObject checkIn(CallContext context, String repositoryId, Holder<String> objectId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, (String)objectId.getValue());
    }

    @Override
    public StoredObject getObjectOfLatestVersion(CallContext context, String repositoryId, String objectId, String versionSeriesId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, versionSeriesId == null ? objectId : versionSeriesId);
    }

    @Override
    public StoredObject getPropertiesOfLatestVersion(CallContext context, String repositoryId, String objectId, String versionSeriesId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, versionSeriesId == null ? objectId : versionSeriesId);
    }

    @Override
    public StoredObject getAllVersions(CallContext context, String repositoryId, String objectId, String versionSeriesId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, versionSeriesId == null ? objectId : versionSeriesId);
    }

    @Override
    public void query(CallContext context, String repositoryId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
    }

    @Override
    public void getContentChanges(CallContext context, String repositoryId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
    }

    @Override
    public StoredObject[] addObjectToFolder(CallContext context, String repositoryId, String objectId, String folderId, Boolean allVersions, ExtensionsData extension) {
        return this.checkParams(repositoryId, objectId, folderId);
    }

    @Override
    public StoredObject[] removeObjectFromFolder(CallContext context, String repositoryId, String objectId, String folderId, ExtensionsData extension) {
        return this.checkParams(repositoryId, objectId, folderId);
    }

    @Override
    public StoredObject getObjectRelationships(CallContext context, String repositoryId, String objectId, RelationshipDirection relationshipDirection, String typeId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, objectId);
    }

    @Override
    public StoredObject getAcl(CallContext context, String repositoryId, String objectId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, objectId);
    }

    @Override
    public StoredObject applyAcl(CallContext context, String repositoryId, String objectId, AclPropagation aclPropagation, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, objectId);
    }

    @Override
    public StoredObject[] applyPolicy(CallContext context, String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        return this.checkParams(repositoryId, policyId, objectId);
    }

    @Override
    public StoredObject[] removePolicy(CallContext context, String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        return this.checkParams(repositoryId, policyId, objectId);
    }

    @Override
    public StoredObject getAppliedPolicies(CallContext context, String repositoryId, String objectId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, objectId);
    }

    @Override
    public StoredObject create(CallContext context, String repositoryId, String folderId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, folderId);
    }

    @Override
    public StoredObject deleteObjectOrCancelCheckOut(CallContext context, String repositoryId, String objectId, ExtensionsData extension) {
        return this.checkStandardParameters(repositoryId, objectId);
    }

    @Override
    public StoredObject applyAcl(CallContext context, String repositoryId, String objectId) {
        return this.checkStandardParameters(repositoryId, objectId);
    }
}

