/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import java.util.List;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Content;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Filing;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomLinkInfoProvider {
    private StoreManager fStoreManager;

    public AtomLinkInfoProvider(StoreManager storeManager) {
        this.fStoreManager = storeManager;
    }

    public void fillInformationForAtomLinks(String repositoryId, StoredObject so, ObjectData od, ObjectInfoImpl objInfo) {
        if (null == objInfo || null == so) {
            return;
        }
        TypeDefinition typeDef = this.fStoreManager.getTypeById(repositoryId, so.getTypeId()).getTypeDefinition();
        objInfo.setId(so.getId());
        objInfo.setName(so.getName());
        objInfo.setCreatedBy(so.getCreatedBy());
        objInfo.setCreationDate(so.getCreatedAt());
        objInfo.setLastModificationDate(so.getModifiedAt());
        objInfo.setTypeId(so.getTypeId());
        objInfo.setBaseType(typeDef.getBaseTypeId());
        objInfo.setObject(od);
        if (so instanceof DocumentVersion) {
            DocumentVersion ver = (DocumentVersion)so;
            DocumentVersion pwc = ver.getParentDocument().getPwc();
            objInfo.setIsCurrentVersion(ver == ver.getParentDocument().getLatestVersion(false));
            objInfo.setVersionSeriesId(ver.getParentDocument().getId());
            objInfo.setWorkingCopyId(pwc == null ? null : pwc.getId());
            objInfo.setWorkingCopyOriginalId(pwc == ver ? ver.getParentDocument().getLatestVersion(false).getId() : null);
        } else if (so instanceof VersionedDocument) {
            VersionedDocument doc = (VersionedDocument)so;
            DocumentVersion pwc = doc.getPwc();
            objInfo.setIsCurrentVersion(false);
            objInfo.setVersionSeriesId(doc.getId());
            objInfo.setWorkingCopyId(pwc == null ? null : pwc.getId());
            objInfo.setWorkingCopyOriginalId(null);
        } else {
            objInfo.setIsCurrentVersion(true);
            objInfo.setVersionSeriesId(null);
            objInfo.setWorkingCopyId(null);
            objInfo.setWorkingCopyOriginalId(null);
        }
        if (so instanceof Content) {
            Content cont = (Content)((Object)so);
            objInfo.setHasContent(cont.getContent(0L, -1L) != null);
            objInfo.setContentType(cont.getContent(0L, -1L) != null ? cont.getContent(0L, -1L).getMimeType() : null);
            objInfo.setFileName(cont.getContent(0L, -1L) != null ? cont.getContent(0L, -1L).getFileName() : null);
        } else {
            objInfo.setHasContent(false);
            objInfo.setContentType(null);
            objInfo.setFileName(null);
        }
        if (so instanceof Filing) {
            Filing sop = (Filing)((Object)so);
            objInfo.setHasParent(sop.hasParent());
        } else {
            objInfo.setHasParent(false);
        }
        objInfo.setRenditionInfos(null);
        objInfo.setSupportsRelationships(false);
        objInfo.setRelationshipSourceIds(null);
        objInfo.setRelationshipTargetIds(null);
        objInfo.setSupportsPolicies(false);
        objInfo.setHasAcl(false);
        objInfo.setSupportsDescendants(true);
        objInfo.setSupportsFolderTree(true);
    }

    public void fillInformationForAtomLinks(String repositoryId, StoredObject so, ObjectInfoImpl objectInfo) {
        this.fillInformationForAtomLinks(repositoryId, so, null, objectInfo);
    }

    public void fillInformationForAtomLinks(String repositoryId, String objectId, ObjectInfoImpl objectInfo) {
        if (null == objectInfo || null == objectId) {
            return;
        }
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        StoredObject so = objectStore.getObjectById(objectId);
        this.fillInformationForAtomLinks(repositoryId, so, objectInfo);
    }

    public void fillInformationForAtomLinks(String repositoryId, String objectId, ObjectInfoHandler objectInfos, ObjectInFolderList objList) {
        if (null == objectInfos || null == objList || null == objectId) {
            return;
        }
        ObjectInfoImpl objectInfo = new ObjectInfoImpl();
        this.fillInformationForAtomLinks(repositoryId, objectId, objectInfo);
        objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        for (ObjectInFolderData object : objList.getObjects()) {
            objectInfo = new ObjectInfoImpl();
            this.fillInformationForAtomLinks(repositoryId, object.getObject().getId(), objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
    }

    public void fillInformationForAtomLinks(String repositoryId, String objectId, ObjectInfoHandler objectInfos, ObjectList objList) {
        List listObjects;
        ObjectInfoImpl objectInfo = new ObjectInfoImpl();
        if (null != objectId) {
            this.fillInformationForAtomLinks(repositoryId, objectId, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        if (null != objList && null != objList.getObjects() && null != (listObjects = objList.getObjects())) {
            for (ObjectData object : listObjects) {
                objectInfo = new ObjectInfoImpl();
                this.fillInformationForAtomLinks(repositoryId, object.getId(), objectInfo);
                objectInfos.addObjectInfo((ObjectInfo)objectInfo);
            }
        }
    }

    private void fillInformationForAtomLinks(String repositoryId, ObjectInfoHandler objectInfos, ObjectInFolderContainer oifc) {
        if (null == objectInfos || null == oifc) {
            return;
        }
        this.fillInformationForAtomLinks(repositoryId, objectInfos, oifc.getObject());
        if (null != oifc.getChildren()) {
            for (ObjectInFolderContainer object : oifc.getChildren()) {
                ObjectInfoImpl objectInfo = new ObjectInfoImpl();
                this.fillInformationForAtomLinks(repositoryId, objectInfos, object);
                objectInfos.addObjectInfo((ObjectInfo)objectInfo);
            }
        }
    }

    public void fillInformationForAtomLinks(String repositoryId, String objectId, ObjectInfoHandler objectInfos, List<ObjectInFolderContainer> oifcList) {
        if (null == objectInfos || null == oifcList || null == objectId) {
            return;
        }
        ObjectInfoImpl objectInfo = new ObjectInfoImpl();
        this.fillInformationForAtomLinks(repositoryId, objectId, objectInfo);
        objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        for (ObjectInFolderContainer object : oifcList) {
            this.fillInformationForAtomLinks(repositoryId, objectInfos, object);
        }
    }

    private void fillInformationForAtomLinks(String repositoryId, ObjectInfoHandler objectInfos, ObjectInFolderData object) {
        ObjectInfoImpl objectInfo = new ObjectInfoImpl();
        this.fillInformationForAtomLinks(repositoryId, object.getObject().getId(), objectInfo);
        objectInfos.addObjectInfo((ObjectInfo)objectInfo);
    }

    public void fillInformationForAtomLinksGetParents(String repositoryId, String objectId, ObjectInfoHandler objectInfos, List<ObjectParentData> objParents) {
        if (null == objectInfos || null == objParents || null == objectId) {
            return;
        }
        ObjectInfoImpl objectInfo = new ObjectInfoImpl();
        this.fillInformationForAtomLinks(repositoryId, objectId, objectInfo);
        for (ObjectParentData object : objParents) {
            objectInfo = new ObjectInfoImpl();
            this.fillInformationForAtomLinks(repositoryId, object.getObject().getId(), objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
    }
}

