/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.query;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.antlr.runtime.tree.Tree;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Filing;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Folder;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ObjectStoreImpl;
import org.apache.chemistry.opencmis.inmemory.types.PropertyCreationHelper;
import org.apache.chemistry.opencmis.server.support.TypeManager;
import org.apache.chemistry.opencmis.server.support.query.AbstractPredicateWalker;
import org.apache.chemistry.opencmis.server.support.query.CmisQueryWalker;
import org.apache.chemistry.opencmis.server.support.query.CmisSelector;
import org.apache.chemistry.opencmis.server.support.query.ColumnReference;
import org.apache.chemistry.opencmis.server.support.query.QueryObject;
import org.apache.chemistry.opencmis.server.support.query.QueryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryQueryProcessor {
    private static Log LOG = LogFactory.getLog(InMemoryQueryProcessor.class);
    private List<StoredObject> matches = new ArrayList<StoredObject>();
    private QueryObject queryObj;
    private Tree whereTree;

    public ObjectList query(TypeManager tm, ObjectStore objectStore, String user, String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount) {
        this.queryObj = new QueryObject(tm);
        this.processQueryAndCatchExc(statement);
        for (String objectId : ((ObjectStoreImpl)objectStore).getIds()) {
            StoredObject so = objectStore.getObjectById(objectId);
            this.match(so, searchAllVersions == null ? true : searchAllVersions);
        }
        ObjectList objList = this.buildResultList(tm, user, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount);
        LOG.debug((Object)("Query result, number of matching objects: " + objList.getNumItems()));
        return objList;
    }

    public void processQueryAndCatchExc(String statement) {
        QueryUtil queryUtil = new QueryUtil();
        CmisQueryWalker walker = queryUtil.traverseStatementAndCatchExc(statement, this.queryObj, null);
        this.whereTree = walker.getWherePredicateTree();
    }

    public ObjectList buildResultList(TypeManager tm, String user, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount) {
        this.sortMatches();
        ObjectListImpl res = new ObjectListImpl();
        res.setNumItems(BigInteger.valueOf(this.matches.size()));
        int start = 0;
        if (skipCount != null) {
            start = (int)skipCount.longValue();
        }
        if (start < 0) {
            start = 0;
        }
        if (start > this.matches.size()) {
            start = this.matches.size();
        }
        int stop = 0;
        if (maxItems != null) {
            stop = start + (int)maxItems.longValue();
        }
        if (stop <= 0 || stop > this.matches.size()) {
            stop = this.matches.size();
        }
        res.setHasMoreItems(Boolean.valueOf(stop < this.matches.size()));
        if (start > 0 || stop > 0) {
            this.matches = this.matches.subList(start, stop);
        }
        ArrayList<ObjectData> objDataList = new ArrayList<ObjectData>();
        Map props = this.queryObj.getRequestedProperties();
        Map funcs = this.queryObj.getRequestedFuncs();
        for (StoredObject so : this.matches) {
            TypeDefinition td = tm.getTypeById(so.getTypeId()).getTypeDefinition();
            ObjectData od = PropertyCreationHelper.getObjectDataQueryResult(td, so, user, props, funcs, includeAllowableActions, includeRelationships, renditionFilter);
            objDataList.add(od);
        }
        res.setObjects(objDataList);
        return res;
    }

    private boolean typeMatches(TypeDefinition td, StoredObject so) {
        String typeId = so.getTypeId();
        while (typeId != null) {
            if (typeId.equals(td.getId())) {
                return true;
            }
            TypeDefinition parentTD = this.queryObj.getParentType(typeId);
            typeId = parentTD == null ? null : parentTD.getId();
        }
        return false;
    }

    private void sortMatches() {
        final List orderBy = this.queryObj.getOrderBys();
        if (orderBy.size() > 1) {
            LOG.warn((Object)"ORDER BY has more than one sort criterium, all but the first are ignored.");
        }
        if (orderBy.size() > 0) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class ResultComparator
            implements Comparator<StoredObject> {
                ResultComparator() {
                }

                @Override
                public int compare(StoredObject so1, StoredObject so2) {
                    int result;
                    QueryObject.SortSpec s = (QueryObject.SortSpec)orderBy.get(0);
                    CmisSelector sel = s.getSelector();
                    if (sel instanceof ColumnReference) {
                        String propId = ((ColumnReference)sel).getPropertyId();
                        Object propVal1 = so1.getProperties().get(propId).getFirstValue();
                        Object propVal2 = so2.getProperties().get(propId).getFirstValue();
                        result = propVal1 == null && propVal2 == null ? 0 : (propVal1 == null ? -1 : (propVal2 == null ? 1 : ((Comparable)propVal1).compareTo(propVal2)));
                    } else {
                        result = 0;
                    }
                    if (!s.isAscending()) {
                        result = -result;
                    }
                    return result;
                }
            }
            Collections.sort(this.matches, new ResultComparator());
        }
    }

    private void match(StoredObject so, boolean searchAllVersions) {
        String queryName = (String)this.queryObj.getTypes().values().iterator().next();
        TypeDefinition td = this.queryObj.getTypeDefinitionFromQueryName(queryName);
        boolean skip = so instanceof VersionedDocument;
        boolean typeMatches = this.typeMatches(td, so);
        if (!searchAllVersions && so instanceof DocumentVersion && ((DocumentVersion)so).getParentDocument().getLatestVersion(false) != so) {
            skip = true;
        }
        if (typeMatches && !skip) {
            this.evalWhereTree(this.whereTree, so);
        }
    }

    private void evalWhereTree(Tree node, StoredObject so) {
        boolean match = true;
        if (null != node) {
            match = this.evalWhereNode(so, node);
        }
        if (match) {
            this.matches.add(so);
        }
    }

    boolean evalWhereNode(StoredObject so, Tree node) {
        return new InMemoryWhereClauseWalker(so).walkPredicate(node);
    }

    private boolean hasParent(Filing objInFolder, String folderId) {
        List<Folder> parents = objInFolder.getParents();
        for (Folder folder : parents) {
            if (!folderId.equals(folder.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean hasAncestor(Filing objInFolder, String folderId) {
        List<Folder> parents = objInFolder.getParents();
        for (Folder folder : parents) {
            if (!folderId.equals(folder.getId())) continue;
            return true;
        }
        for (Folder folder : parents) {
            if (!this.hasAncestor(folder, folderId)) continue;
            return true;
        }
        return false;
    }

    protected int compareTo(PropertyDefinition<?> td, PropertyData<?> lVal, Object rVal) {
        Object lValue = lVal.getFirstValue();
        switch (td.getPropertyType()) {
            case BOOLEAN: {
                if (rVal instanceof Boolean) {
                    return ((Boolean)lValue).compareTo((Boolean)rVal);
                }
                this.throwIncompatibleTypesException(lValue, rVal);
                break;
            }
            case INTEGER: {
                Long lLongValue = ((BigInteger)lVal.getFirstValue()).longValue();
                if (rVal instanceof Long) {
                    return lLongValue.compareTo((Long)rVal);
                }
                if (rVal instanceof Double) {
                    return Double.valueOf(((Integer)lValue).doubleValue()).compareTo((Double)rVal);
                }
                this.throwIncompatibleTypesException(lValue, rVal);
                break;
            }
            case DATETIME: {
                if (rVal instanceof GregorianCalendar) {
                    return ((GregorianCalendar)lValue).compareTo((GregorianCalendar)rVal);
                }
                this.throwIncompatibleTypesException(lValue, rVal);
                break;
            }
            case DECIMAL: {
                Double lDoubleValue = ((BigDecimal)lVal.getFirstValue()).doubleValue();
                if (rVal instanceof Double) {
                    return lDoubleValue.compareTo((Double)rVal);
                }
                if (rVal instanceof Long) {
                    return Double.valueOf(((Integer)lValue).doubleValue()).compareTo(((Long)rVal).doubleValue());
                }
                this.throwIncompatibleTypesException(lValue, rVal);
                break;
            }
            case HTML: 
            case STRING: 
            case URI: 
            case ID: {
                if (rVal instanceof String) {
                    LOG.debug((Object)("compare strings: " + lValue + " with " + rVal));
                    return ((String)lValue).compareTo((String)rVal);
                }
                this.throwIncompatibleTypesException(lValue, rVal);
            }
        }
        return 0;
    }

    private ColumnReference getColumnReference(Tree columnNode) {
        CmisSelector sel = this.queryObj.getColumnReference(Integer.valueOf(columnNode.getTokenStartIndex()));
        if (null == sel) {
            throw new RuntimeException("Unknown property query name " + columnNode.getChild(0));
        }
        if (sel instanceof ColumnReference) {
            return (ColumnReference)sel;
        }
        throw new RuntimeException("Unexpected numerical value function in where clause");
    }

    private String getTableReference(Tree tableNode) {
        String typeQueryName = this.queryObj.getTypeQueryName(tableNode.getText());
        if (null == typeQueryName) {
            throw new RuntimeException("Inavlid type in IN_FOLDER() or IN_TREE(), must be in FROM list: " + tableNode.getText());
        }
        return typeQueryName;
    }

    private Object getPropertyValue(Tree columnNode, StoredObject so) {
        ColumnReference colRef = this.getColumnReference(columnNode);
        PropertyDefinition pd = colRef.getPropertyDefinition();
        PropertyData<?> lVal = so.getProperties().get(colRef.getPropertyId());
        if (null == lVal) {
            return null;
        }
        if (pd.getCardinality() == Cardinality.SINGLE) {
            return lVal.getFirstValue();
        }
        return lVal.getValues();
    }

    public static String translatePattern(String wildcardString) {
        int index = 0;
        int start = 0;
        StringBuffer res = new StringBuffer();
        while (index >= 0) {
            index = wildcardString.indexOf(37, start);
            if (index < 0) {
                res.append(wildcardString.substring(start));
            } else if (index == 0 || index > 0 && wildcardString.charAt(index - 1) != '\\') {
                res.append(wildcardString.substring(start, index));
                res.append(".*");
            } else {
                res.append(wildcardString.substring(start, index + 1));
            }
            start = index + 1;
        }
        wildcardString = res.toString();
        index = 0;
        start = 0;
        res = new StringBuffer();
        while (index >= 0) {
            index = wildcardString.indexOf(95, start);
            if (index < 0) {
                res.append(wildcardString.substring(start));
            } else if (index == 0 || index > 0 && wildcardString.charAt(index - 1) != '\\') {
                res.append(wildcardString.substring(start, index));
                res.append(".");
            } else {
                res.append(wildcardString.substring(start, index + 1));
            }
            start = index + 1;
        }
        return res.toString();
    }

    private void throwIncompatibleTypesException(Object o1, Object o2) {
        throw new RuntimeException("Incompatible Types to compare: " + o1 + " and " + o2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InMemoryWhereClauseWalker
    extends AbstractPredicateWalker {
        protected StoredObject so;

        public InMemoryWhereClauseWalker(StoredObject so) {
            this.so = so;
        }

        public Boolean walkNot(Tree opNode, Tree node) {
            boolean matches = this.walkPredicate(node);
            return !matches;
        }

        public Boolean walkAnd(Tree opNode, Tree leftNode, Tree rightNode) {
            boolean matches1 = this.walkPredicate(leftNode);
            boolean matches2 = this.walkPredicate(rightNode);
            return matches1 && matches2;
        }

        public Boolean walkOr(Tree opNode, Tree leftNode, Tree rightNode) {
            boolean matches1 = this.walkPredicate(leftNode);
            boolean matches2 = this.walkPredicate(rightNode);
            return matches1 || matches2;
        }

        public Boolean walkEquals(Tree opNode, Tree leftNode, Tree rightNode) {
            Integer cmp = this.compareTo(leftNode, rightNode);
            return cmp == null ? false : cmp == 0;
        }

        public Boolean walkNotEquals(Tree opNode, Tree leftNode, Tree rightNode) {
            Integer cmp = this.compareTo(leftNode, rightNode);
            return cmp == null ? false : cmp != 0;
        }

        public Boolean walkGreaterThan(Tree opNode, Tree leftNode, Tree rightNode) {
            Integer cmp = this.compareTo(leftNode, rightNode);
            return cmp == null ? false : cmp > 0;
        }

        public Boolean walkGreaterOrEquals(Tree opNode, Tree leftNode, Tree rightNode) {
            Integer cmp = this.compareTo(leftNode, rightNode);
            return cmp == null ? false : cmp >= 0;
        }

        public Boolean walkLessThan(Tree opNode, Tree leftNode, Tree rightNode) {
            Integer cmp = this.compareTo(leftNode, rightNode);
            return cmp == null ? false : cmp < 0;
        }

        public Boolean walkLessOrEquals(Tree opNode, Tree leftNode, Tree rightNode) {
            Integer cmp = this.compareTo(leftNode, rightNode);
            return cmp == null ? false : cmp <= 0;
        }

        public Boolean walkIn(Tree opNode, Tree colNode, Tree listNode) {
            ColumnReference colRef = InMemoryQueryProcessor.this.getColumnReference(colNode);
            PropertyDefinition pd = colRef.getPropertyDefinition();
            PropertyData<?> lVal = this.so.getProperties().get(colRef.getPropertyId());
            List<Object> literals = this.onLiteralList(listNode);
            if (pd.getCardinality() != Cardinality.SINGLE) {
                throw new RuntimeException("Operator IN only is allowed on single-value properties ");
            }
            if (lVal == null) {
                return false;
            }
            Object prop = lVal.getFirstValue();
            if (literals.contains(prop)) {
                return true;
            }
            return false;
        }

        public Boolean walkNotIn(Tree opNode, Tree colNode, Tree listNode) {
            ColumnReference colRef = InMemoryQueryProcessor.this.getColumnReference(colNode);
            PropertyDefinition pd = colRef.getPropertyDefinition();
            PropertyData<?> lVal = this.so.getProperties().get(colRef.getPropertyId());
            List<Object> literals = this.onLiteralList(listNode);
            if (pd.getCardinality() != Cardinality.SINGLE) {
                throw new RuntimeException("Operator IN only is allowed on single-value properties ");
            }
            if (lVal == null) {
                return false;
            }
            Object prop = lVal.getFirstValue();
            if (literals.contains(prop)) {
                return false;
            }
            return true;
        }

        public Boolean walkInAny(Tree opNode, Tree colNode, Tree listNode) {
            ColumnReference colRef = InMemoryQueryProcessor.this.getColumnReference(colNode);
            PropertyDefinition pd = colRef.getPropertyDefinition();
            PropertyData<?> lVal = this.so.getProperties().get(colRef.getPropertyId());
            List<Object> literals = this.onLiteralList(listNode);
            if (pd.getCardinality() != Cardinality.MULTI) {
                throw new RuntimeException("Operator ANY...IN only is allowed on multi-value properties ");
            }
            if (lVal == null) {
                return false;
            }
            List props = lVal.getValues();
            for (Object prop : props) {
                LOG.debug((Object)("comparing with: " + prop));
                if (!literals.contains(prop)) continue;
                return true;
            }
            return false;
        }

        public Boolean walkNotInAny(Tree opNode, Tree colNode, Tree listNode) {
            ColumnReference colRef = InMemoryQueryProcessor.this.getColumnReference(colNode);
            PropertyDefinition pd = colRef.getPropertyDefinition();
            PropertyData<?> lVal = this.so.getProperties().get(colRef.getPropertyId());
            List<Object> literals = this.onLiteralList(listNode);
            if (pd.getCardinality() != Cardinality.MULTI) {
                throw new RuntimeException("Operator ANY...IN only is allowed on multi-value properties ");
            }
            if (lVal == null) {
                return false;
            }
            List props = lVal.getValues();
            for (Object prop : props) {
                LOG.debug((Object)("comparing with: " + prop));
                if (!literals.contains(prop)) continue;
                return false;
            }
            return true;
        }

        public Boolean walkEqAny(Tree opNode, Tree literalNode, Tree colNode) {
            ColumnReference colRef = InMemoryQueryProcessor.this.getColumnReference(colNode);
            PropertyDefinition pd = colRef.getPropertyDefinition();
            PropertyData<?> lVal = this.so.getProperties().get(colRef.getPropertyId());
            Object literal = this.walkExpr(literalNode);
            if (pd.getCardinality() != Cardinality.MULTI) {
                throw new RuntimeException("Operator = ANY only is allowed on multi-value properties ");
            }
            if (lVal == null) {
                return false;
            }
            List props = lVal.getValues();
            if (props.contains(literal)) {
                return true;
            }
            return false;
        }

        public Boolean walkIsNull(Tree opNode, Tree colNode) {
            Object propVal = InMemoryQueryProcessor.this.getPropertyValue(colNode, this.so);
            return propVal == null;
        }

        public Boolean walkIsNotNull(Tree opNode, Tree colNode) {
            Object propVal = InMemoryQueryProcessor.this.getPropertyValue(colNode, this.so);
            return propVal != null;
        }

        public Boolean walkLike(Tree opNode, Tree colNode, Tree stringNode) {
            Object rVal = this.walkExpr(stringNode);
            if (!(rVal instanceof String)) {
                throw new RuntimeException("LIKE operator requires String literal on right hand side.");
            }
            ColumnReference colRef = InMemoryQueryProcessor.this.getColumnReference(colNode);
            PropertyDefinition pd = colRef.getPropertyDefinition();
            PropertyType propType = pd.getPropertyType();
            if (propType != PropertyType.STRING && propType != PropertyType.HTML && propType != PropertyType.ID && propType != PropertyType.URI) {
                throw new RuntimeException("Property type " + propType.value() + " is not allowed FOR LIKE");
            }
            if (pd.getCardinality() != Cardinality.SINGLE) {
                throw new RuntimeException("LIKE is not allowed for multi-value properties ");
            }
            String propVal = (String)this.so.getProperties().get(colRef.getPropertyId()).getFirstValue();
            String pattern = InMemoryQueryProcessor.translatePattern((String)rVal);
            Pattern p = Pattern.compile(pattern);
            return p.matcher(propVal).matches();
        }

        public Boolean walkNotLike(Tree opNode, Tree colNode, Tree stringNode) {
            return this.walkLike(opNode, colNode, stringNode) == false;
        }

        public Boolean walkContains(Tree qualNode, Tree colNode, Tree queryNode) {
            throw new RuntimeException("Operator CONTAINS not supported in InMemory server.");
        }

        public Boolean walkInFolder(Tree opNode, Tree qualNode, Tree paramNode) {
            Object lit;
            if (null != qualNode) {
                InMemoryQueryProcessor.this.getTableReference(qualNode);
            }
            if (!((lit = this.walkExpr(paramNode)) instanceof String)) {
                throw new RuntimeException("Folder id in IN_FOLDER must be of type String");
            }
            String folderId = (String)lit;
            if (this.so instanceof Filing) {
                return InMemoryQueryProcessor.this.hasParent((Filing)((Object)this.so), folderId);
            }
            return false;
        }

        public Boolean walkInTree(Tree opNode, Tree qualNode, Tree paramNode) {
            Object lit;
            if (null != qualNode) {
                InMemoryQueryProcessor.this.getTableReference(qualNode);
            }
            if (!((lit = this.walkExpr(paramNode)) instanceof String)) {
                throw new RuntimeException("Folder id in IN_FOLDER must be of type String");
            }
            String folderId = (String)lit;
            if (this.so instanceof Filing) {
                return InMemoryQueryProcessor.this.hasAncestor((Filing)((Object)this.so), folderId);
            }
            return false;
        }

        protected Integer compareTo(Tree leftChild, Tree rightChild) {
            Object rVal = this.walkExpr(rightChild);
            ColumnReference colRef = InMemoryQueryProcessor.this.getColumnReference(leftChild);
            PropertyDefinition pd = colRef.getPropertyDefinition();
            PropertyData<?> lVal = this.so.getProperties().get(colRef.getPropertyId());
            if (lVal instanceof List) {
                throw new RuntimeException("You can't query operators <, <=, ==, !=, >=, > on multi-value properties ");
            }
            return InMemoryQueryProcessor.this.compareTo(pd, lVal, rVal);
        }

        public List<Object> onLiteralList(Tree node) {
            return (List)this.walkExpr(node);
        }
    }
}

