/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyDefinitionType;
import org.apache.chemistry.opencmis.inmemory.types.DocumentTypeCreationHelper;
import org.apache.chemistry.opencmis.inmemory.types.InMemoryDocumentTypeDefinition;
import org.apache.chemistry.opencmis.inmemory.types.InMemoryFolderTypeDefinition;
import org.apache.chemistry.opencmis.inmemory.types.InMemoryPolicyTypeDefinition;
import org.apache.chemistry.opencmis.inmemory.types.InMemoryRelationshipTypeDefinition;
import org.apache.chemistry.opencmis.server.support.TypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeManagerImpl
implements TypeManager {
    private Map<String, TypeDefinitionContainer> fTypesMap = new HashMap<String, TypeDefinitionContainer>();

    public TypeDefinitionContainer getTypeById(String typeId) {
        return this.fTypesMap.get(typeId);
    }

    public TypeDefinition getTypeByQueryName(String typeQueryName) {
        for (Map.Entry<String, TypeDefinitionContainer> entry : this.fTypesMap.entrySet()) {
            if (!entry.getValue().getTypeDefinition().getQueryName().equals(typeQueryName)) continue;
            return entry.getValue().getTypeDefinition();
        }
        return null;
    }

    public synchronized Collection<TypeDefinitionContainer> getTypeDefinitionList() {
        ArrayList<TypeDefinitionContainer> typeRoots = new ArrayList<TypeDefinitionContainer>();
        for (TypeDefinitionContainer typeDef : this.fTypesMap.values()) {
            if (typeDef.getTypeDefinition().getParentTypeId() != null) continue;
            typeRoots.add(typeDef);
        }
        return typeRoots;
    }

    public List<TypeDefinitionContainer> getRootTypes() {
        ArrayList<TypeDefinitionContainer> rootTypes = new ArrayList<TypeDefinitionContainer>();
        for (TypeDefinitionContainer type : this.fTypesMap.values()) {
            if (!TypeManagerImpl.isRootType(type)) continue;
            rootTypes.add(type);
        }
        return rootTypes;
    }

    public void initTypeSystem(List<TypeDefinition> typesList) {
        this.createCmisDefaultTypes();
        if (null != typesList) {
            for (TypeDefinition typeDef : typesList) {
                this.addTypeDefinition(typeDef);
            }
        }
    }

    public void addTypeDefinition(TypeDefinition cmisType) {
        if (this.fTypesMap.containsKey(cmisType.getId())) {
            throw new RuntimeException("You cannot add type with id " + cmisType.getId() + " because it already exists.");
        }
        TypeDefinitionContainerImpl typeContainer = new TypeDefinitionContainerImpl(cmisType);
        if (!this.fTypesMap.containsKey(cmisType.getParentTypeId())) {
            throw new RuntimeException("Cannot add type, because parent with id " + cmisType.getParentTypeId() + " does not exist.");
        }
        TypeDefinitionContainer parentTypeContainer = this.fTypesMap.get(cmisType.getParentTypeId());
        parentTypeContainer.getChildren().add(typeContainer);
        Map propDefs = typeContainer.getTypeDefinition().getPropertyDefinitions();
        this.addInheritedProperties(propDefs, parentTypeContainer.getTypeDefinition());
        this.fTypesMap.put(cmisType.getId(), (TypeDefinitionContainer)typeContainer);
    }

    public void clearTypeSystem() {
        this.fTypesMap.clear();
        this.createCmisDefaultTypes();
    }

    public String getPropertyIdForQueryName(TypeDefinition typeDefinition, String propQueryName) {
        for (PropertyDefinition pd : typeDefinition.getPropertyDefinitions().values()) {
            if (!pd.getQueryName().equals(propQueryName)) continue;
            return pd.getId();
        }
        return null;
    }

    private void addInheritedProperties(Map<String, PropertyDefinition<?>> propDefs, TypeDefinition typeDefinition) {
        TypeDefinitionContainer parentTypeContainer;
        if (null == typeDefinition) {
            return;
        }
        if (null != typeDefinition.getPropertyDefinitions()) {
            this.addInheritedPropertyDefinitions(propDefs, typeDefinition.getPropertyDefinitions());
        }
        TypeDefinition parentType = null == (parentTypeContainer = this.fTypesMap.get(typeDefinition.getParentTypeId())) ? null : parentTypeContainer.getTypeDefinition();
        this.addInheritedProperties(propDefs, parentType);
    }

    private void addInheritedPropertyDefinitions(Map<String, PropertyDefinition<?>> propDefs, Map<String, PropertyDefinition<?>> superPropDefs) {
        for (Map.Entry<String, PropertyDefinition<?>> superProp : superPropDefs.entrySet()) {
            PropertyDefinition<?> superPropDef = superProp.getValue();
            PropertyDefinition<?> clone = TypeManagerImpl.clonePropertyDefinition(superPropDef);
            ((AbstractPropertyDefinition)clone).setIsInherited(Boolean.valueOf(true));
            propDefs.put(superProp.getKey(), clone);
        }
    }

    private void createCmisDefaultTypes() {
        List<TypeDefinition> typesList = DocumentTypeCreationHelper.createDefaultTypes();
        for (TypeDefinition typeDef : typesList) {
            TypeDefinitionContainerImpl typeContainer = new TypeDefinitionContainerImpl(typeDef);
            this.fTypesMap.put(typeDef.getId(), (TypeDefinitionContainer)typeContainer);
        }
    }

    private static boolean isRootType(TypeDefinitionContainer c) {
        return c.getTypeDefinition().equals((Object)InMemoryFolderTypeDefinition.getRootFolderType()) || c.getTypeDefinition().equals((Object)InMemoryDocumentTypeDefinition.getRootDocumentType()) || c.getTypeDefinition().equals((Object)InMemoryRelationshipTypeDefinition.getRootRelationshipType()) || c.getTypeDefinition().equals((Object)InMemoryPolicyTypeDefinition.getRootPolicyType());
    }

    private static PropertyDefinition<?> clonePropertyDefinition(PropertyDefinition<?> src) {
        CmisPropertyDefinitionType tmp = Converter.convert(src);
        PropertyDefinition clone = Converter.convert((CmisPropertyDefinitionType)tmp);
        return clone;
    }
}

