/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory;

public class NameValidator {
    public static final String ERROR_ILLEGAL_ID = "Id contains illegal characters, allowed are 'a'..'z', 'A'..'Z', '0'..'9', '-', '_'";
    public static final String ERROR_ILLEGAL_NAME = "Id contains illegal characters, allowed are 'a'..'z', 'A'..'Z', '0'..'9', '-', '_', '.', ' '";

    public static boolean isValidId(String s) {
        if (null == s || s.length() == 0) {
            return false;
        }
        if (s.startsWith("cmis:")) {
            s = s.substring(5);
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '-' || c == '_' || c == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidLocalName(String s) {
        return NameValidator.isValidId(s);
    }

    public static boolean isValidName(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '-' || c == '_' || c == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidNamespace(String s) {
        return NameValidator.isValidId(s);
    }

    public static boolean isValidQueryName(String s) {
        return NameValidator.isValidId(s);
    }
}

