/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ChangeEventInfo;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.PolicyIdList;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AllowableActionsImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChangeEventInfoDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyIdListImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Content;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Folder;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Version;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataObjectCreator {
    public static AllowableActions fillAllowableActions(StoredObject so, String user) {
        boolean isRootFolder;
        boolean isFolder = so instanceof Folder;
        boolean isDocument = so instanceof Content;
        boolean isCheckedOut = false;
        boolean canCheckOut = false;
        boolean canCheckIn = false;
        boolean isVersioned = so instanceof Version || so instanceof VersionedDocument;
        boolean hasContent = so instanceof Content && ((Content)((Object)so)).hasContent();
        boolean bl = isRootFolder = isFolder && ((Folder)so).getParent() == null;
        if (so instanceof Version) {
            isCheckedOut = ((Version)((Object)so)).isPwc();
            canCheckIn = isCheckedOut && ((Version)((Object)so)).getParentDocument().getCheckedOutBy().equals(user);
            canCheckOut = !((Version)((Object)so)).getParentDocument().isCheckedOut();
        } else if (so instanceof VersionedDocument) {
            isCheckedOut = ((VersionedDocument)so).isCheckedOut();
            canCheckOut = !((VersionedDocument)so).isCheckedOut();
            canCheckIn = isCheckedOut && ((VersionedDocument)so).getCheckedOutBy().equals(user);
        }
        AllowableActionsImpl allowableActions = new AllowableActionsImpl();
        Set set = allowableActions.getAllowableActions();
        set.add(Action.CAN_DELETE_OBJECT);
        set.add(Action.CAN_UPDATE_PROPERTIES);
        if (isFolder || isDocument) {
            set.add(Action.CAN_GET_PROPERTIES);
            if (!isRootFolder) {
                set.add(Action.CAN_GET_OBJECT_PARENTS);
            }
            set.add(Action.CAN_MOVE_OBJECT);
        }
        if (isFolder) {
            if (!isRootFolder) {
                set.add(Action.CAN_GET_FOLDER_PARENT);
            }
            set.add(Action.CAN_GET_FOLDER_TREE);
            set.add(Action.CAN_GET_DESCENDANTS);
            set.add(Action.CAN_ADD_OBJECT_TO_FOLDER);
            set.add(Action.CAN_REMOVE_OBJECT_FROM_FOLDER);
            set.add(Action.CAN_CREATE_DOCUMENT);
            set.add(Action.CAN_CREATE_FOLDER);
            set.add(Action.CAN_GET_CHILDREN);
            set.add(Action.CAN_DELETE_TREE);
        }
        if (hasContent) {
            set.add(Action.CAN_DELETE_CONTENT_STREAM);
            set.add(Action.CAN_GET_CONTENT_STREAM);
        }
        if (isVersioned) {
            if (canCheckOut) {
                set.add(Action.CAN_CHECK_OUT);
            }
            if (isCheckedOut) {
                set.add(Action.CAN_CANCEL_CHECK_OUT);
            }
            if (canCheckIn) {
                set.add(Action.CAN_CHECK_IN);
            }
            set.add(Action.CAN_GET_ALL_VERSIONS);
        }
        if (isDocument) {
            set.add(Action.CAN_SET_CONTENT_STREAM);
        }
        allowableActions.setAllowableActions(set);
        return allowableActions;
    }

    public static Acl fillACL(StoredObject so) {
        AccessControlListImpl acl = new AccessControlListImpl();
        ArrayList aces = new ArrayList();
        acl.setAces(aces);
        return acl;
    }

    public static PolicyIdList fillPolicyIds(StoredObject so) {
        PolicyIdListImpl polIds = new PolicyIdListImpl();
        return polIds;
    }

    public static List<ObjectData> fillRelationships(IncludeRelationships includeRelationships, StoredObject so) {
        ArrayList<ObjectData> relationships = new ArrayList<ObjectData>();
        return relationships;
    }

    public static List<RenditionData> fillRenditions(StoredObject so) {
        ArrayList<RenditionData> renditions = new ArrayList<RenditionData>();
        return renditions;
    }

    public static ChangeEventInfo fillChangeEventInfo(StoredObject so) {
        ChangeEventInfoDataImpl changeEventInfo = new ChangeEventInfoDataImpl();
        return changeEventInfo;
    }
}

