/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.fileshare;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.JaxBHelper;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractServiceFactory;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.fileshare.FileShareRepository;
import org.apache.chemistry.opencmis.fileshare.FileShareService;
import org.apache.chemistry.opencmis.fileshare.RepositoryMap;
import org.apache.chemistry.opencmis.fileshare.TypeManager;
import org.apache.chemistry.opencmis.server.support.CmisServiceWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileShareServiceFactory
extends AbstractServiceFactory {
    private static final String PREFIX_LOGIN = "login.";
    private static final String PREFIX_REPOSITORY = "repository.";
    private static final String PREFIX_TYPE = "type.";
    private static final String SUFFIX_READWRITE = ".readwrite";
    private static final String SUFFIX_READONLY = ".readonly";
    private static final BigInteger DEFAULT_MAX_ITEMS_TYPES = BigInteger.valueOf(50L);
    private static final BigInteger DEFAULT_DEPTH_TYPES = BigInteger.valueOf(-1L);
    private static final BigInteger DEFAULT_MAX_ITEMS_OBJECTS = BigInteger.valueOf(200L);
    private static final BigInteger DEFAULT_DEPTH_OBJECTS = BigInteger.valueOf(10L);
    private static final Log log = LogFactory.getLog(FileShareServiceFactory.class);
    private RepositoryMap repositoryMap;
    private TypeManager typeManager;
    private ThreadLocal<CmisServiceWrapper<FileShareService>> threadLocalService = new ThreadLocal();

    public void init(Map<String, String> parameters) {
        this.repositoryMap = new RepositoryMap();
        this.typeManager = new TypeManager();
        this.readConfiguration(parameters);
    }

    public void destroy() {
        this.threadLocalService = null;
    }

    public CmisService getService(CallContext context) {
        this.repositoryMap.authenticate(context);
        CmisServiceWrapper wrapperService = this.threadLocalService.get();
        if (wrapperService == null) {
            wrapperService = new CmisServiceWrapper((CmisService)new FileShareService(this.repositoryMap), DEFAULT_MAX_ITEMS_TYPES, DEFAULT_DEPTH_TYPES, DEFAULT_MAX_ITEMS_OBJECTS, DEFAULT_DEPTH_OBJECTS);
            this.threadLocalService.set((CmisServiceWrapper<FileShareService>)wrapperService);
        }
        ((FileShareService)wrapperService.getWrappedService()).setCallContext(context);
        return wrapperService;
    }

    private void readConfiguration(Map<String, String> parameters) {
        ArrayList<String> keys = new ArrayList<String>(parameters.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            FileShareRepository fsr;
            if (key.startsWith(PREFIX_LOGIN)) {
                String usernameAndPassword = this.replaceSystemProperties(parameters.get(key));
                if (usernameAndPassword == null) continue;
                String username = usernameAndPassword;
                String password = "";
                int x = usernameAndPassword.indexOf(58);
                if (x > -1) {
                    username = usernameAndPassword.substring(0, x);
                    password = usernameAndPassword.substring(x + 1);
                }
                this.repositoryMap.addLogin(username, password);
                log.info((Object)("Added login '" + username + "'."));
                continue;
            }
            if (key.startsWith(PREFIX_TYPE)) {
                TypeDefinition type = this.loadType(this.replaceSystemProperties(parameters.get(key)));
                if (type == null) continue;
                this.typeManager.addType(type);
                continue;
            }
            if (!key.startsWith(PREFIX_REPOSITORY)) continue;
            String repositoryId = key.substring(PREFIX_REPOSITORY.length()).trim();
            int x = repositoryId.lastIndexOf(46);
            if (x > 0) {
                repositoryId = repositoryId.substring(0, x);
            }
            if (repositoryId.length() == 0) {
                throw new IllegalArgumentException("No repository id!");
            }
            if (key.endsWith(SUFFIX_READWRITE)) {
                fsr = this.repositoryMap.getRepository(repositoryId);
                for (String user : this.split(parameters.get(key))) {
                    fsr.addUser(this.replaceSystemProperties(user), false);
                }
                continue;
            }
            if (key.endsWith(SUFFIX_READONLY)) {
                fsr = this.repositoryMap.getRepository(repositoryId);
                for (String user : this.split(parameters.get(key))) {
                    fsr.addUser(this.replaceSystemProperties(user), true);
                }
                continue;
            }
            String root = this.replaceSystemProperties(parameters.get(key));
            FileShareRepository fsr2 = new FileShareRepository(repositoryId, root, this.typeManager);
            this.repositoryMap.addRepository(fsr2);
            log.info((Object)("Added repository '" + fsr2.getRepositoryId() + "': " + root));
        }
    }

    private List<String> split(String csl) {
        if (csl == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String s : csl.split(",")) {
            result.add(s.trim());
        }
        return result;
    }

    private String replaceSystemProperties(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        StringBuilder property = null;
        boolean inProperty = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (inProperty) {
                if (c == '}') {
                    String value = System.getProperty(property.toString());
                    if (value != null) {
                        result.append(value);
                    }
                    inProperty = false;
                    continue;
                }
                property.append(c);
                continue;
            }
            if (c == '{') {
                property = new StringBuilder();
                inProperty = true;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private TypeDefinition loadType(String filename) {
        TypeDefinition result = null;
        try {
            Unmarshaller u = JaxBHelper.createUnmarshaller();
            JAXBElement type = (JAXBElement)u.unmarshal(new File(filename));
            result = Converter.convert((CmisTypeDefinitionType)((CmisTypeDefinitionType)type.getValue()));
        }
        catch (Exception e) {
            log.info((Object)("Could not load type: '" + filename + "'"), (Throwable)e);
        }
        return result;
    }
}

