/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.fileshare;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AclCapabilities;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.PermissionMapping;
import org.apache.chemistry.opencmis.commons.data.Principal;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyDateTime;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.PermissionDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityAcl;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.CapabilityContentStreamUpdates;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.chemistry.opencmis.commons.enums.CapabilityRenditions;
import org.apache.chemistry.opencmis.commons.enums.SupportedPermissions;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.JaxBHelper;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AclCapabilitiesDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AllowableActionsImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FailedToDeleteDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectParentDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PermissionDefinitionDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PermissionMappingDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryCapabilitiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryInfoImpl;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisProperty;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.fileshare.MIMETypes;
import org.apache.chemistry.opencmis.fileshare.TypeManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileShareRepository {
    private static final String ROOT_ID = "@root@";
    private static final String SHADOW_EXT = ".cmis.xml";
    private static final String SHADOW_FOLDER = "cmis.xml";
    private static final String USER_UNKNOWN = "<unknown>";
    private static final String CMIS_READ = "cmis:read";
    private static final String CMIS_WRITE = "cmis:write";
    private static final String CMIS_ALL = "cmis:all";
    private static final int BUFFER_SIZE = 65536;
    private static final Log log = LogFactory.getLog(FileShareRepository.class);
    private String fRepositoryId;
    private File fRoot;
    private TypeManager fTypes;
    private Map<String, Boolean> fUserMap;
    private RepositoryInfoImpl fRepositoryInfo;

    public FileShareRepository(String repId, String root, TypeManager types) {
        if (repId == null || repId.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid repository id!");
        }
        this.fRepositoryId = repId;
        if (root == null || root.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid root folder!");
        }
        this.fRoot = new File(root);
        if (!this.fRoot.isDirectory()) {
            throw new IllegalArgumentException("Root is not a directory!");
        }
        this.fTypes = types;
        this.fUserMap = new HashMap<String, Boolean>();
        this.fRepositoryInfo = new RepositoryInfoImpl();
        this.fRepositoryInfo.setId(this.fRepositoryId);
        this.fRepositoryInfo.setName(this.fRepositoryId);
        this.fRepositoryInfo.setDescription(this.fRepositoryId);
        this.fRepositoryInfo.setCmisVersionSupported("1.0");
        this.fRepositoryInfo.setProductName("OpenCMIS FileShare");
        this.fRepositoryInfo.setProductVersion("0.1");
        this.fRepositoryInfo.setVendorName("OpenCMIS");
        this.fRepositoryInfo.setRootFolder(ROOT_ID);
        this.fRepositoryInfo.setThinClientUri("");
        RepositoryCapabilitiesImpl capabilities = new RepositoryCapabilitiesImpl();
        capabilities.setCapabilityAcl(CapabilityAcl.DISCOVER);
        capabilities.setAllVersionsSearchable(Boolean.valueOf(false));
        capabilities.setCapabilityJoin(CapabilityJoin.NONE);
        capabilities.setSupportsMultifiling(Boolean.valueOf(false));
        capabilities.setSupportsUnfiling(Boolean.valueOf(false));
        capabilities.setSupportsVersionSpecificFiling(Boolean.valueOf(false));
        capabilities.setIsPwcSearchable(Boolean.valueOf(false));
        capabilities.setIsPwcUpdatable(Boolean.valueOf(false));
        capabilities.setCapabilityQuery(CapabilityQuery.NONE);
        capabilities.setCapabilityChanges(CapabilityChanges.NONE);
        capabilities.setCapabilityContentStreamUpdates(CapabilityContentStreamUpdates.ANYTIME);
        capabilities.setSupportsGetDescendants(Boolean.valueOf(true));
        capabilities.setSupportsGetFolderTree(Boolean.valueOf(true));
        capabilities.setCapabilityRendition(CapabilityRenditions.NONE);
        this.fRepositoryInfo.setCapabilities((RepositoryCapabilities)capabilities);
        AclCapabilitiesDataImpl aclCapability = new AclCapabilitiesDataImpl();
        aclCapability.setSupportedPermissions(SupportedPermissions.BASIC);
        aclCapability.setAclPropagation(AclPropagation.OBJECTONLY);
        ArrayList<PermissionDefinition> permissions = new ArrayList<PermissionDefinition>();
        permissions.add(this.createPermission(CMIS_READ, "Read"));
        permissions.add(this.createPermission(CMIS_WRITE, "Write"));
        permissions.add(this.createPermission(CMIS_ALL, "All"));
        aclCapability.setPermissionDefinitionData(permissions);
        ArrayList<PermissionMapping> list = new ArrayList<PermissionMapping>();
        list.add(this.createMapping("canCreateDocument.Folder", CMIS_READ));
        list.add(this.createMapping("canCreateFolder.Folder", CMIS_READ));
        list.add(this.createMapping("canDeleteContent.Document", CMIS_WRITE));
        list.add(this.createMapping("canDelete.Object", CMIS_ALL));
        list.add(this.createMapping("canDeleteTree.Folder", CMIS_ALL));
        list.add(this.createMapping("canGetACL.Object", CMIS_READ));
        list.add(this.createMapping("canGetAllVersions.VersionSeries", CMIS_READ));
        list.add(this.createMapping("canGetChildren.Folder", CMIS_READ));
        list.add(this.createMapping("canGetDescendents.Folder", CMIS_READ));
        list.add(this.createMapping("canGetFolderParent.Object", CMIS_READ));
        list.add(this.createMapping("canGetParents.Folder", CMIS_READ));
        list.add(this.createMapping("canGetProperties.Object", CMIS_READ));
        list.add(this.createMapping("canMove.Object", CMIS_WRITE));
        list.add(this.createMapping("canMove.Source", CMIS_READ));
        list.add(this.createMapping("canMove.Target", CMIS_WRITE));
        list.add(this.createMapping("canSetContent.Document", CMIS_WRITE));
        list.add(this.createMapping("canUpdateProperties.Object", CMIS_WRITE));
        list.add(this.createMapping("canViewContent.Object", CMIS_READ));
        LinkedHashMap<String, PermissionMapping> map = new LinkedHashMap<String, PermissionMapping>();
        for (PermissionMapping pm : list) {
            map.put(pm.getKey(), pm);
        }
        aclCapability.setPermissionMappingData(map);
        this.fRepositoryInfo.setAclCapabilities((AclCapabilities)aclCapability);
    }

    private PermissionDefinition createPermission(String permission, String description) {
        PermissionDefinitionDataImpl pd = new PermissionDefinitionDataImpl();
        pd.setPermission(permission);
        pd.setDescription(description);
        return pd;
    }

    private PermissionMapping createMapping(String key, String permission) {
        PermissionMappingDataImpl pm = new PermissionMappingDataImpl();
        pm.setKey(key);
        pm.setPermissions(Collections.singletonList(permission));
        return pm;
    }

    public void addUser(String user, boolean readOnly) {
        if (user == null || user.length() == 0) {
            return;
        }
        this.fUserMap.put(user, readOnly);
    }

    public String getRepositoryId() {
        return this.fRepositoryId;
    }

    public RepositoryInfo getRepositoryInfo(CallContext context) {
        this.debug("getRepositoryInfo");
        this.checkUser(context, false);
        return this.fRepositoryInfo;
    }

    public TypeDefinitionList getTypesChildren(CallContext context, String typeId, boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount) {
        this.debug("getTypesChildren");
        this.checkUser(context, false);
        return this.fTypes.getTypesChildren(context, typeId, includePropertyDefinitions, maxItems, skipCount);
    }

    public TypeDefinition getTypeDefinition(CallContext context, String typeId) {
        this.debug("getTypeDefinition");
        this.checkUser(context, false);
        return this.fTypes.getTypeDefinition(context, typeId);
    }

    public List<TypeDefinitionContainer> getTypesDescendants(CallContext context, String typeId, BigInteger depth, Boolean includePropertyDefinitions) {
        this.debug("getTypesDescendants");
        this.checkUser(context, false);
        return this.fTypes.getTypesDescendants(context, typeId, depth, includePropertyDefinitions);
    }

    public ObjectData create(CallContext context, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, ObjectInfoHandler objectInfos) {
        this.debug("create");
        boolean userReadOnly = this.checkUser(context, true);
        String typeId = this.getTypeId(properties);
        TypeDefinition type = this.fTypes.getType(typeId);
        if (type == null) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
        }
        String objectId = null;
        if (type.getBaseTypeId() == BaseTypeId.CMIS_DOCUMENT) {
            objectId = this.createDocument(context, properties, folderId, contentStream, versioningState);
        } else if (type.getBaseTypeId() == BaseTypeId.CMIS_FOLDER) {
            objectId = this.createFolder(context, properties, folderId);
        } else {
            throw new CmisObjectNotFoundException("Cannot create object of type '" + typeId + "'!");
        }
        return this.compileObjectType(context, this.getFile(objectId), null, false, false, userReadOnly, objectInfos);
    }

    public String createDocument(CallContext context, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState) {
        this.debug("createDocument");
        this.checkUser(context, true);
        if (properties == null || properties.getProperties() == null) {
            throw new CmisInvalidArgumentException("Properties must be set!");
        }
        if (VersioningState.NONE != versioningState) {
            throw new CmisConstraintException("Versioning not supported!");
        }
        String typeId = this.getTypeId(properties);
        TypeDefinition type = this.fTypes.getType(typeId);
        if (type == null) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
        }
        Properties props = this.compileProperties(typeId, context.getUsername(), this.millisToCalendar(System.currentTimeMillis()), context.getUsername(), properties);
        String name = this.getStringProperty(properties, "cmis:name");
        if (!this.isValidName(name)) {
            throw new CmisNameConstraintViolationException("Name is not valid!");
        }
        File parent = this.getFile(folderId);
        if (!parent.isDirectory()) {
            throw new CmisObjectNotFoundException("Parent is not a folder!");
        }
        File newFile = new File(parent, name);
        if (newFile.exists()) {
            throw new CmisNameConstraintViolationException("Document already exists!");
        }
        try {
            newFile.createNewFile();
        }
        catch (IOException e) {
            throw new CmisStorageException("Could not create file: " + e.getMessage());
        }
        if (contentStream != null && contentStream.getStream() != null) {
            try {
                int b;
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newFile), 65536);
                BufferedInputStream in = new BufferedInputStream(contentStream.getStream(), 65536);
                byte[] buffer = new byte[65536];
                while ((b = ((InputStream)in).read(buffer)) > -1) {
                    ((OutputStream)out).write(buffer, 0, b);
                }
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
                ((InputStream)in).close();
            }
            catch (Exception e) {
                throw new CmisStorageException("Could not write content: " + e.getMessage(), (Throwable)e);
            }
        }
        this.writePropertiesFile(newFile, props);
        return this.getId(newFile);
    }

    public String createDocumentFromSource(CallContext context, String sourceId, Properties properties, String folderId, VersioningState versioningState) {
        if (VersioningState.NONE != versioningState) {
            throw new CmisConstraintException("Versioning not supported!");
        }
        File parent = this.getFile(folderId);
        if (!parent.isDirectory()) {
            throw new CmisObjectNotFoundException("Parent is not a folder!");
        }
        File source = this.getFile(sourceId);
        if (!source.isFile()) {
            throw new CmisObjectNotFoundException("Source is not a document!");
        }
        String name = source.getName();
        PropertiesImpl sourceProperties = new PropertiesImpl();
        this.readCustomProperties(source, sourceProperties, null, new ObjectInfoImpl());
        String typeId = this.getIdProperty((Properties)sourceProperties, "cmis:objectTypeId");
        if (typeId == null) {
            typeId = "cmis:document";
        }
        PropertiesImpl newProperties = new PropertiesImpl();
        for (PropertyData prop : sourceProperties.getProperties().values()) {
            if (prop.getId().equals("cmis:objectTypeId") || prop.getId().equals("cmis:createdBy") || prop.getId().equals("cmis:creationDate") || prop.getId().equals("cmis:lastModifiedBy")) continue;
            newProperties.addProperty(prop);
        }
        if (properties != null) {
            TypeDefinition type;
            String newName = this.getStringProperty(properties, "cmis:name");
            if (newName != null) {
                if (!this.isValidName(newName)) {
                    throw new CmisNameConstraintViolationException("Name is not valid!");
                }
                name = newName;
            }
            if ((type = this.fTypes.getType(typeId)) == null) {
                throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
            }
            for (PropertyData prop : properties.getProperties().values()) {
                PropertyDefinition propType = (PropertyDefinition)type.getPropertyDefinitions().get(prop.getId());
                if (propType == null) {
                    throw new CmisConstraintException("Property '" + prop.getId() + "' is unknown!");
                }
                if (propType.getUpdatability() != Updatability.READWRITE) {
                    throw new CmisConstraintException("Property '" + prop.getId() + "' cannot be updated!");
                }
                if (this.isEmptyProperty(prop)) {
                    throw new CmisConstraintException("Property '" + prop.getId() + "' must not be empty!");
                }
                newProperties.addProperty(prop);
            }
        }
        this.addPropertyId(newProperties, typeId, null, "cmis:objectTypeId", typeId);
        this.addPropertyString(newProperties, typeId, null, "cmis:createdBy", context.getUsername());
        this.addPropertyDateTime(newProperties, typeId, null, "cmis:creationDate", this.millisToCalendar(System.currentTimeMillis()));
        this.addPropertyString(newProperties, typeId, null, "cmis:lastModifiedBy", context.getUsername());
        File newFile = new File(parent, name);
        if (newFile.exists()) {
            throw new CmisNameConstraintViolationException("Document already exists.");
        }
        try {
            newFile.createNewFile();
        }
        catch (IOException e) {
            throw new CmisStorageException("Could not create file: " + e.getMessage(), (Throwable)e);
        }
        try {
            int b;
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newFile));
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
            byte[] buffer = new byte[65536];
            while ((b = ((InputStream)in).read(buffer)) > -1) {
                ((OutputStream)out).write(buffer, 0, b);
            }
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            ((InputStream)in).close();
        }
        catch (Exception e) {
            throw new CmisStorageException("Could not roead or write content: " + e.getMessage(), (Throwable)e);
        }
        this.writePropertiesFile(newFile, (Properties)newProperties);
        return this.getId(newFile);
    }

    public String createFolder(CallContext context, Properties properties, String folderId) {
        this.debug("createFolder");
        this.checkUser(context, true);
        if (properties == null || properties.getProperties() == null) {
            throw new CmisInvalidArgumentException("Properties must be set!");
        }
        String typeId = this.getTypeId(properties);
        TypeDefinition type = this.fTypes.getType(typeId);
        if (type == null) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
        }
        Properties props = this.compileProperties(typeId, context.getUsername(), this.millisToCalendar(System.currentTimeMillis()), context.getUsername(), properties);
        String name = this.getStringProperty(properties, "cmis:name");
        if (!this.isValidName(name)) {
            throw new CmisNameConstraintViolationException("Name is not valid.");
        }
        File parent = this.getFile(folderId);
        if (!parent.isDirectory()) {
            throw new CmisObjectNotFoundException("Parent is not a folder!");
        }
        File newFolder = new File(parent, name);
        if (!newFolder.mkdir()) {
            throw new CmisStorageException("Could not create folder!");
        }
        this.writePropertiesFile(newFolder, props);
        return this.getId(newFolder);
    }

    public ObjectData moveObject(CallContext context, Holder<String> objectId, String targetFolderId, ObjectInfoHandler objectInfos) {
        File propFile;
        this.debug("moveObject");
        boolean userReadOnly = this.checkUser(context, true);
        if (objectId == null) {
            throw new CmisInvalidArgumentException("Id is not valid!");
        }
        File file = this.getFile((String)objectId.getValue());
        File parent = this.getFile(targetFolderId);
        File newFile = new File(parent, file.getName());
        if (newFile.exists()) {
            throw new CmisStorageException("Object already exists!");
        }
        if (!file.renameTo(newFile)) {
            throw new CmisStorageException("Move failed!");
        }
        objectId.setValue((Object)this.getId(newFile));
        if (newFile.isFile() && (propFile = this.getPropertiesFile(file)).exists()) {
            File newPropFile = new File(parent, propFile.getName());
            propFile.renameTo(newPropFile);
        }
        return this.compileObjectType(context, newFile, null, false, false, userReadOnly, objectInfos);
    }

    public void setContentStream(CallContext context, Holder<String> objectId, Boolean overwriteFlag, ContentStream contentStream) {
        boolean owf;
        this.debug("setContentStream or deleteContentStream");
        this.checkUser(context, true);
        if (objectId == null) {
            throw new CmisInvalidArgumentException("Id is not valid!");
        }
        File file = this.getFile((String)objectId.getValue());
        if (!file.isFile()) {
            throw new CmisStreamNotSupportedException("Not a file!");
        }
        boolean bl = owf = overwriteFlag == null ? true : overwriteFlag;
        if (!owf && file.length() > 0L) {
            throw new CmisContentAlreadyExistsException("Content already exists!");
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file), 65536);
            if (contentStream == null || contentStream.getStream() == null) {
                ((OutputStream)out).write(new byte[0]);
            } else {
                int b;
                BufferedInputStream in = new BufferedInputStream(contentStream.getStream(), 65536);
                byte[] buffer = new byte[65536];
                while ((b = ((InputStream)in).read(buffer)) > -1) {
                    ((OutputStream)out).write(buffer, 0, b);
                }
                ((InputStream)in).close();
            }
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            throw new CmisStorageException("Could not write content: " + e.getMessage(), (Throwable)e);
        }
    }

    public void deleteObject(CallContext context, String objectId) {
        this.debug("deleteObject");
        this.checkUser(context, true);
        File file = this.getFile(objectId);
        if (!file.exists()) {
            throw new CmisObjectNotFoundException("Object not found!");
        }
        if (!this.isFolderEmpty(file)) {
            throw new CmisConstraintException("Folder is not empty!");
        }
        this.getPropertiesFile(file).delete();
        if (!file.delete()) {
            throw new CmisStorageException("Deletion failed!");
        }
    }

    public FailedToDeleteData deleteTree(CallContext context, String folderId, Boolean continueOnFailure) {
        this.debug("deleteTree");
        this.checkUser(context, true);
        boolean cof = continueOnFailure == null ? false : continueOnFailure;
        File file = this.getFile(folderId);
        FailedToDeleteDataImpl result = new FailedToDeleteDataImpl();
        result.setIds(new ArrayList());
        if (file.isDirectory()) {
            this.deleteFolder(file, cof, result);
        } else {
            this.getPropertiesFile(file).delete();
            if (!file.delete()) {
                result.getIds().add(this.getId(file));
            }
        }
        return result;
    }

    public ObjectData updateProperties(CallContext context, Holder<String> objectId, Properties properties, ObjectInfoHandler objectInfos) {
        GregorianCalendar creationDate;
        String creator;
        boolean isRename;
        this.debug("updateProperties");
        boolean userReadOnly = this.checkUser(context, true);
        if (objectId == null) {
            throw new CmisInvalidArgumentException("Id is not valid!");
        }
        File file = this.getFile((String)objectId.getValue());
        String newName = this.getStringProperty(properties, "cmis:name");
        boolean bl = isRename = newName != null && !file.getName().equals(newName);
        if (isRename && !this.isValidName(newName)) {
            throw new CmisNameConstraintViolationException("Name is not valid!");
        }
        PropertiesImpl oldProperties = new PropertiesImpl();
        this.readCustomProperties(file, oldProperties, null, new ObjectInfoImpl());
        String typeId = this.getIdProperty((Properties)oldProperties, "cmis:objectTypeId");
        if (typeId == null) {
            String string = typeId = file.isDirectory() ? "cmis:folder" : "cmis:document";
        }
        if ((creator = this.getStringProperty((Properties)oldProperties, "cmis:createdBy")) == null) {
            creator = context.getUsername();
        }
        if ((creationDate = this.getDateTimeProperty((Properties)oldProperties, "cmis:creationDate")) == null) {
            creationDate = this.millisToCalendar(file.lastModified());
        }
        Properties props = this.updateProperties(typeId, creator, creationDate, context.getUsername(), (Properties)oldProperties, properties);
        this.writePropertiesFile(file, props);
        File newFile = file;
        if (isRename) {
            File parent = file.getParentFile();
            File propFile = this.getPropertiesFile(file);
            newFile = new File(parent, newName);
            if (!file.renameTo(newFile)) {
                throw new CmisUpdateConflictException("Could not rename object!");
            }
            objectId.setValue((Object)this.getId(newFile));
            if (newFile.isFile() && propFile.exists()) {
                File newPropFile = new File(parent, newName + SHADOW_EXT);
                propFile.renameTo(newPropFile);
            }
        }
        return this.compileObjectType(context, newFile, null, false, false, userReadOnly, objectInfos);
    }

    public ObjectData getObject(CallContext context, String objectId, String versionServicesId, String filter, Boolean includeAllowableActions, Boolean includeAcl, ObjectInfoHandler objectInfos) {
        this.debug("getObject");
        boolean userReadOnly = this.checkUser(context, false);
        if (objectId == null && versionServicesId == null) {
            throw new CmisInvalidArgumentException("Object Id must be set.");
        }
        if (objectId == null) {
            objectId = versionServicesId;
        }
        File file = this.getFile(objectId);
        boolean iaa = includeAllowableActions == null ? false : includeAllowableActions;
        boolean iacl = includeAcl == null ? false : includeAcl;
        Set<String> filterCollection = this.splitFilter(filter);
        return this.compileObjectType(context, file, filterCollection, iaa, iacl, userReadOnly, objectInfos);
    }

    public AllowableActions getAllowableActions(CallContext context, String objectId) {
        this.debug("getAllowableActions");
        boolean userReadOnly = this.checkUser(context, false);
        File file = this.getFile(objectId);
        if (!file.exists()) {
            throw new CmisObjectNotFoundException("Object not found!");
        }
        return this.compileAllowableActions(file, userReadOnly);
    }

    public Acl getAcl(CallContext context, String objectId) {
        this.debug("getAcl");
        this.checkUser(context, false);
        File file = this.getFile(objectId);
        if (!file.exists()) {
            throw new CmisObjectNotFoundException("Object not found!");
        }
        return this.compileAcl(file);
    }

    public ContentStream getContentStream(CallContext context, String objectId, BigInteger offset, BigInteger length) {
        this.debug("getContentStream");
        this.checkUser(context, false);
        if (offset != null || length != null) {
            throw new CmisInvalidArgumentException("Offset and Length are not supported!");
        }
        File file = this.getFile(objectId);
        if (!file.isFile()) {
            throw new CmisStreamNotSupportedException("Not a file!");
        }
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(file), 4096);
        }
        catch (FileNotFoundException e) {
            throw new CmisObjectNotFoundException(e.getMessage(), (Throwable)e);
        }
        ContentStreamImpl result = new ContentStreamImpl();
        result.setFileName(file.getName());
        result.setLength(BigInteger.valueOf(file.length()));
        result.setMimeType(MIMETypes.getMIMEType(file));
        result.setStream((InputStream)stream);
        return result;
    }

    public ObjectInFolderList getChildren(CallContext context, String folderId, String filter, Boolean includeAllowableActions, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ObjectInfoHandler objectInfos) {
        File folder;
        int max;
        int skip;
        this.debug("getChildren");
        boolean userReadOnly = this.checkUser(context, false);
        Set<String> filterCollection = this.splitFilter(filter);
        boolean iaa = includeAllowableActions == null ? false : includeAllowableActions;
        boolean ips = includePathSegment == null ? false : includePathSegment;
        int n = skip = skipCount == null ? 0 : skipCount.intValue();
        if (skip < 0) {
            skip = 0;
        }
        int n2 = max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
        if (max < 0) {
            max = Integer.MAX_VALUE;
        }
        if (!(folder = this.getFile(folderId)).isDirectory()) {
            throw new CmisObjectNotFoundException("Not a folder!");
        }
        if (context.isObjectInfoRequired()) {
            this.compileObjectType(context, folder, null, false, false, userReadOnly, objectInfos);
        }
        ObjectInFolderListImpl result = new ObjectInFolderListImpl();
        result.setObjects(new ArrayList());
        result.setHasMoreItems(Boolean.valueOf(false));
        int count = 0;
        for (File child : folder.listFiles()) {
            if (child.isHidden() || child.getName().equals(SHADOW_FOLDER) || child.getPath().endsWith(SHADOW_EXT)) continue;
            ++count;
            if (skip > 0) {
                --skip;
                continue;
            }
            if (result.getObjects().size() >= max) {
                result.setHasMoreItems(Boolean.valueOf(true));
                continue;
            }
            ObjectInFolderDataImpl objectInFolder = new ObjectInFolderDataImpl();
            objectInFolder.setObject(this.compileObjectType(context, child, filterCollection, iaa, false, userReadOnly, objectInfos));
            if (ips) {
                objectInFolder.setPathSegment(child.getName());
            }
            result.getObjects().add(objectInFolder);
        }
        result.setNumItems(BigInteger.valueOf(count));
        return result;
    }

    public List<ObjectInFolderContainer> getDescendants(CallContext context, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, Boolean includePathSegment, ObjectInfoHandler objectInfos, boolean foldersOnly) {
        int d;
        this.debug("getDescendants or getFolderTree");
        boolean userReadOnly = this.checkUser(context, false);
        int n = d = depth == null ? 2 : depth.intValue();
        if (d == 0) {
            throw new CmisInvalidArgumentException("Depth must not be 0!");
        }
        if (d < -1) {
            d = -1;
        }
        Set<String> filterCollection = this.splitFilter(filter);
        boolean iaa = includeAllowableActions == null ? false : includeAllowableActions;
        boolean ips = includePathSegment == null ? false : includePathSegment;
        File folder = this.getFile(folderId);
        if (!folder.isDirectory()) {
            throw new CmisObjectNotFoundException("Not a folder!");
        }
        if (context.isObjectInfoRequired()) {
            this.compileObjectType(context, folder, null, false, false, userReadOnly, objectInfos);
        }
        ArrayList<ObjectInFolderContainer> result = new ArrayList<ObjectInFolderContainer>();
        this.gatherDescendants(context, folder, result, foldersOnly, d, filterCollection, iaa, ips, userReadOnly, objectInfos);
        return result;
    }

    public ObjectData getFolderParent(CallContext context, String folderId, String filter, ObjectInfoHandler objectInfos) {
        List<ObjectParentData> parents = this.getObjectParents(context, folderId, filter, false, false, objectInfos);
        if (parents.size() == 0) {
            throw new CmisInvalidArgumentException("The root folder has no parent!");
        }
        return parents.get(0).getObject();
    }

    public List<ObjectParentData> getObjectParents(CallContext context, String objectId, String filter, Boolean includeAllowableActions, Boolean includeRelativePathSegment, ObjectInfoHandler objectInfos) {
        this.debug("getObjectParents");
        boolean userReadOnly = this.checkUser(context, false);
        Set<String> filterCollection = this.splitFilter(filter);
        boolean iaa = includeAllowableActions == null ? false : includeAllowableActions;
        boolean irps = includeRelativePathSegment == null ? false : includeRelativePathSegment;
        File file = this.getFile(objectId);
        if (this.fRoot.equals(file)) {
            return Collections.emptyList();
        }
        if (context.isObjectInfoRequired()) {
            this.compileObjectType(context, file, null, false, false, userReadOnly, objectInfos);
        }
        File parent = file.getParentFile();
        ObjectData object = this.compileObjectType(context, parent, filterCollection, iaa, false, userReadOnly, objectInfos);
        ObjectParentDataImpl result = new ObjectParentDataImpl();
        result.setObject(object);
        if (irps) {
            result.setRelativePathSegment(file.getName());
        }
        return Collections.singletonList(result);
    }

    public ObjectData getObjectByPath(CallContext context, String folderPath, String filter, boolean includeAllowableActions, boolean includeACL, ObjectInfoHandler objectInfos) {
        this.debug("getObjectByPath");
        boolean userReadOnly = this.checkUser(context, false);
        Set<String> filterCollection = this.splitFilter(filter);
        if (folderPath == null || !folderPath.startsWith("/")) {
            throw new CmisInvalidArgumentException("Invalid folder path!");
        }
        File file = null;
        if (folderPath.length() == 1) {
            file = this.fRoot;
        } else {
            String path = folderPath.replace('/', File.separatorChar).substring(1);
            file = new File(this.fRoot, path);
        }
        if (!file.exists()) {
            throw new CmisObjectNotFoundException("Path doesn't exist.");
        }
        return this.compileObjectType(context, file, filterCollection, includeAllowableActions, includeACL, userReadOnly, objectInfos);
    }

    private void gatherDescendants(CallContext context, File folder, List<ObjectInFolderContainer> list, boolean foldersOnly, int depth, Set<String> filter, boolean includeAllowableActions, boolean includePathSegments, boolean userReadOnly, ObjectInfoHandler objectInfos) {
        for (File child : folder.listFiles()) {
            if (child.isHidden() || child.getName().equals(SHADOW_FOLDER) || child.getPath().endsWith(SHADOW_EXT) || foldersOnly && !child.isDirectory()) continue;
            ObjectInFolderDataImpl objectInFolder = new ObjectInFolderDataImpl();
            objectInFolder.setObject(this.compileObjectType(context, child, filter, includeAllowableActions, false, userReadOnly, objectInfos));
            if (includePathSegments) {
                objectInFolder.setPathSegment(child.getName());
            }
            ObjectInFolderContainerImpl container = new ObjectInFolderContainerImpl();
            container.setObject((ObjectInFolderData)objectInFolder);
            list.add((ObjectInFolderContainer)container);
            if (depth == 1 || !child.isDirectory()) continue;
            container.setChildren(new ArrayList());
            this.gatherDescendants(context, child, container.getChildren(), foldersOnly, depth - 1, filter, includeAllowableActions, includePathSegments, userReadOnly, objectInfos);
        }
    }

    private boolean deleteFolder(File folder, boolean continueOnFailure, FailedToDeleteDataImpl ftd) {
        boolean success = true;
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                if (this.deleteFolder(file, continueOnFailure, ftd)) continue;
                if (!continueOnFailure) {
                    return false;
                }
                success = false;
                continue;
            }
            if (file.delete()) continue;
            ftd.getIds().add(this.getId(file));
            if (!continueOnFailure) {
                return false;
            }
            success = false;
        }
        if (!folder.delete()) {
            ftd.getIds().add(this.getId(folder));
            success = false;
        }
        return success;
    }

    private boolean isValidName(String name) {
        return name != null && name.length() != 0 && name.indexOf(File.separatorChar) == -1 && name.indexOf(File.pathSeparatorChar) == -1;
    }

    private boolean isFolderEmpty(File folder) {
        if (!folder.isDirectory()) {
            return true;
        }
        String[] fileNames = folder.list();
        if (fileNames == null || fileNames.length == 0) {
            return true;
        }
        return fileNames.length == 1 && fileNames[0].equals(SHADOW_FOLDER);
    }

    private ObjectData compileObjectType(CallContext context, File file, Set<String> filter, boolean includeAllowableActions, boolean includeAcl, boolean userReadOnly, ObjectInfoHandler objectInfos) {
        ObjectDataImpl result = new ObjectDataImpl();
        ObjectInfoImpl objectInfo = new ObjectInfoImpl();
        result.setProperties(this.compileProperties(file, filter, objectInfo));
        if (includeAllowableActions) {
            result.setAllowableActions(this.compileAllowableActions(file, userReadOnly));
        }
        if (includeAcl) {
            result.setAcl(this.compileAcl(file));
            result.setIsExactAcl(Boolean.valueOf(true));
        }
        if (context.isObjectInfoRequired()) {
            objectInfo.setObject((ObjectData)result);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        return result;
    }

    private Properties compileProperties(File file, Set<String> orgfilter, ObjectInfoImpl objectInfo) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null!");
        }
        if (!file.exists()) {
            throw new CmisObjectNotFoundException("Object not found!");
        }
        HashSet<String> filter = orgfilter == null ? null : new HashSet<String>(orgfilter);
        String typeId = null;
        if (file.isDirectory()) {
            typeId = "cmis:folder";
            objectInfo.setBaseType(BaseTypeId.CMIS_FOLDER);
            objectInfo.setTypeId(typeId);
            objectInfo.setContentType(null);
            objectInfo.setFileName(null);
            objectInfo.setHasAcl(true);
            objectInfo.setHasContent(false);
            objectInfo.setVersionSeriesId(null);
            objectInfo.setIsCurrentVersion(true);
            objectInfo.setRelationshipSourceIds(null);
            objectInfo.setRelationshipTargetIds(null);
            objectInfo.setRenditionInfos(null);
            objectInfo.setSupportsDescendants(true);
            objectInfo.setSupportsFolderTree(true);
            objectInfo.setSupportsPolicies(false);
            objectInfo.setSupportsRelationships(false);
            objectInfo.setWorkingCopyId(null);
            objectInfo.setWorkingCopyOriginalId(null);
        } else {
            typeId = "cmis:document";
            objectInfo.setBaseType(BaseTypeId.CMIS_DOCUMENT);
            objectInfo.setTypeId(typeId);
            objectInfo.setHasAcl(true);
            objectInfo.setHasContent(true);
            objectInfo.setHasParent(true);
            objectInfo.setVersionSeriesId(null);
            objectInfo.setIsCurrentVersion(true);
            objectInfo.setRelationshipSourceIds(null);
            objectInfo.setRelationshipTargetIds(null);
            objectInfo.setRenditionInfos(null);
            objectInfo.setSupportsDescendants(false);
            objectInfo.setSupportsFolderTree(false);
            objectInfo.setSupportsPolicies(false);
            objectInfo.setSupportsRelationships(false);
            objectInfo.setWorkingCopyId(null);
            objectInfo.setWorkingCopyOriginalId(null);
        }
        try {
            PropertiesImpl result = new PropertiesImpl();
            String id = this.fileToId(file);
            this.addPropertyId(result, typeId, filter, "cmis:objectId", id);
            objectInfo.setId(id);
            String name = file.getName();
            this.addPropertyString(result, typeId, filter, "cmis:name", name);
            objectInfo.setName(name);
            this.addPropertyString(result, typeId, filter, "cmis:createdBy", USER_UNKNOWN);
            this.addPropertyString(result, typeId, filter, "cmis:lastModifiedBy", USER_UNKNOWN);
            objectInfo.setCreatedBy(USER_UNKNOWN);
            GregorianCalendar lastModified = this.millisToCalendar(file.lastModified());
            this.addPropertyDateTime(result, typeId, filter, "cmis:creationDate", lastModified);
            this.addPropertyDateTime(result, typeId, filter, "cmis:lastModificationDate", lastModified);
            objectInfo.setCreationDate(lastModified);
            objectInfo.setLastModificationDate(lastModified);
            if (file.isDirectory()) {
                this.addPropertyId(result, typeId, filter, "cmis:baseTypeId", BaseTypeId.CMIS_FOLDER.value());
                this.addPropertyId(result, typeId, filter, "cmis:objectTypeId", "cmis:folder");
                String path = this.getRepositoryPath(file);
                this.addPropertyString(result, typeId, filter, "cmis:path", path.length() == 0 ? "/" : path);
                if (!this.fRoot.equals(file)) {
                    this.addPropertyId(result, typeId, filter, "cmis:parentId", this.fRoot.equals(file.getParentFile()) ? ROOT_ID : this.fileToId(file.getParentFile()));
                    objectInfo.setHasParent(true);
                } else {
                    objectInfo.setHasParent(false);
                }
            } else {
                this.addPropertyId(result, typeId, filter, "cmis:baseTypeId", BaseTypeId.CMIS_DOCUMENT.value());
                this.addPropertyId(result, typeId, filter, "cmis:objectTypeId", "cmis:document");
                this.addPropertyBoolean(result, typeId, filter, "cmis:isImmutable", false);
                this.addPropertyBoolean(result, typeId, filter, "cmis:isLatestVersion", true);
                this.addPropertyBoolean(result, typeId, filter, "cmis:isMajorVersion", true);
                this.addPropertyBoolean(result, typeId, filter, "cmis:isLatestMajorVersion", true);
                this.addPropertyString(result, typeId, filter, "cmis:versionLabel", file.getName());
                this.addPropertyId(result, typeId, filter, "cmis:versionSeriesId", this.fileToId(file));
                this.addPropertyString(result, typeId, filter, "cmis:checkinComment", "");
                this.addPropertyInteger(result, typeId, filter, "cmis:contentStreamLength", file.length());
                this.addPropertyString(result, typeId, filter, "cmis:contentStreamMimeType", MIMETypes.getMIMEType(file));
                this.addPropertyString(result, typeId, filter, "cmis:contentStreamFileName", file.getName());
                objectInfo.setContentType(MIMETypes.getMIMEType(file));
                objectInfo.setFileName(file.getName());
            }
            this.readCustomProperties(file, result, filter, objectInfo);
            if (filter != null && !filter.isEmpty()) {
                this.debug("Unknown filter properties: " + ((Object)filter).toString(), null);
            }
            return result;
        }
        catch (Exception e) {
            if (e instanceof CmisBaseException) {
                throw (CmisBaseException)e;
            }
            throw new CmisRuntimeException(e.getMessage());
        }
    }

    private void readCustomProperties(File file, PropertiesImpl properties, Set<String> filter, ObjectInfoImpl objectInfo) {
        File propFile = this.getPropertiesFile(file);
        if (!propFile.exists()) {
            return;
        }
        JAXBElement obj = null;
        try {
            Unmarshaller u = JaxBHelper.createUnmarshaller();
            obj = (JAXBElement)u.unmarshal(propFile);
        }
        catch (Exception e) {
            this.warn("Unvalid CMIS properties: " + propFile.getAbsolutePath(), e);
        }
        if (obj == null || obj.getValue() == null || ((CmisObjectType)obj.getValue()).getProperties() == null) {
            return;
        }
        for (CmisProperty cmisProp : ((CmisObjectType)obj.getValue()).getProperties().getProperty()) {
            PropertyData prop = Converter.convert((CmisProperty)cmisProp);
            if (prop instanceof PropertyString) {
                String firstValueStr = (String)((PropertyString)prop).getFirstValue();
                if ("cmis:name".equals(prop.getId())) {
                    objectInfo.setName(firstValueStr);
                } else if ("cmis:objectTypeId".equals(prop.getId())) {
                    objectInfo.setTypeId(firstValueStr);
                } else if ("cmis:createdBy".equals(prop.getId())) {
                    objectInfo.setCreatedBy(firstValueStr);
                } else if ("cmis:contentStreamMimeType".equals(prop.getId())) {
                    objectInfo.setContentType(firstValueStr);
                } else if ("cmis:contentStreamFileName".equals(prop.getId())) {
                    objectInfo.setFileName(firstValueStr);
                }
            }
            if (prop instanceof PropertyDateTime) {
                GregorianCalendar firstValueCal = (GregorianCalendar)((PropertyDateTime)prop).getFirstValue();
                if ("cmis:creationDate".equals(prop.getId())) {
                    objectInfo.setCreationDate(firstValueCal);
                } else if ("cmis:lastModificationDate".equals(prop.getId())) {
                    objectInfo.setLastModificationDate(firstValueCal);
                }
            }
            if (filter != null) {
                if (!filter.contains(prop.getId())) continue;
                filter.remove(prop.getId());
            }
            if ("cmis:objectId".equals(prop.getId()) || "cmis:baseTypeId".equals(prop.getId())) continue;
            properties.addProperty(prop);
        }
    }

    private Properties compileProperties(String typeId, String creator, GregorianCalendar creationDate, String modifier, Properties properties) {
        PropertiesImpl result = new PropertiesImpl();
        HashSet<String> addedProps = new HashSet<String>();
        if (properties == null || properties.getProperties() == null) {
            throw new CmisConstraintException("No properties!");
        }
        TypeDefinition type = this.fTypes.getType(typeId);
        if (type == null) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
        }
        for (PropertyData prop : properties.getProperties().values()) {
            PropertyDefinition propType = (PropertyDefinition)type.getPropertyDefinitions().get(prop.getId());
            if (propType == null) {
                throw new CmisConstraintException("Property '" + prop.getId() + "' is unknown!");
            }
            if (propType.getId().equals("cmis:objectTypeId")) continue;
            if (propType.getUpdatability() == Updatability.READONLY) {
                throw new CmisConstraintException("Property '" + prop.getId() + "' is readonly!");
            }
            if (this.isEmptyProperty(prop)) {
                throw new CmisConstraintException("Property '" + prop.getId() + "' must not be empty!");
            }
            result.addProperty(prop);
            addedProps.add(prop.getId());
        }
        for (PropertyDefinition propDef : type.getPropertyDefinitions().values()) {
            if (addedProps.contains(propDef.getId()) || propDef.getUpdatability() == Updatability.READONLY || this.addPropertyDefault(result, propDef) || !propDef.isRequired().booleanValue()) continue;
            throw new CmisConstraintException("Property '" + propDef.getId() + "' is required!");
        }
        this.addPropertyId(result, typeId, null, "cmis:objectTypeId", typeId);
        this.addPropertyString(result, typeId, null, "cmis:createdBy", creator);
        this.addPropertyDateTime(result, typeId, null, "cmis:creationDate", creationDate);
        this.addPropertyString(result, typeId, null, "cmis:lastModifiedBy", modifier);
        return result;
    }

    private Properties updateProperties(String typeId, String creator, GregorianCalendar creationDate, String modifier, Properties oldProperties, Properties properties) {
        PropertyDefinition propType;
        PropertiesImpl result = new PropertiesImpl();
        if (properties == null) {
            throw new CmisConstraintException("No properties!");
        }
        TypeDefinition type = this.fTypes.getType(typeId);
        if (type == null) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
        }
        for (PropertyData prop : oldProperties.getProperties().values()) {
            propType = (PropertyDefinition)type.getPropertyDefinitions().get(prop.getId());
            if (propType == null) {
                throw new CmisConstraintException("Property '" + prop.getId() + "' is unknown!");
            }
            if (propType.getUpdatability() != Updatability.READWRITE) continue;
            result.addProperty(prop);
        }
        for (PropertyData prop : properties.getProperties().values()) {
            propType = (PropertyDefinition)type.getPropertyDefinitions().get(prop.getId());
            if (propType == null) {
                throw new CmisConstraintException("Property '" + prop.getId() + "' is unknown!");
            }
            if (propType.getUpdatability() == Updatability.READONLY) {
                throw new CmisConstraintException("Property '" + prop.getId() + "' is readonly!");
            }
            if (propType.getUpdatability() == Updatability.ONCREATE) {
                throw new CmisConstraintException("Property '" + prop.getId() + "' can only be set on create!");
            }
            if (this.isEmptyProperty(prop)) {
                this.addPropertyDefault(result, propType);
                continue;
            }
            result.addProperty(prop);
        }
        this.addPropertyId(result, typeId, null, "cmis:objectTypeId", typeId);
        this.addPropertyString(result, typeId, null, "cmis:createdBy", creator);
        this.addPropertyDateTime(result, typeId, null, "cmis:creationDate", creationDate);
        this.addPropertyString(result, typeId, null, "cmis:lastModifiedBy", modifier);
        return result;
    }

    private boolean isEmptyProperty(PropertyData<?> prop) {
        if (prop == null || prop.getValues() == null) {
            return true;
        }
        return prop.getValues().isEmpty();
    }

    private void addPropertyId(PropertiesImpl props, String typeId, Set<String> filter, String id, String value) {
        if (!this.checkAddProperty((Properties)props, typeId, filter, id)) {
            return;
        }
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null!");
        }
        props.addProperty((PropertyData)new PropertyIdImpl(id, value));
    }

    private void addPropertyString(PropertiesImpl props, String typeId, Set<String> filter, String id, String value) {
        if (!this.checkAddProperty((Properties)props, typeId, filter, id)) {
            return;
        }
        props.addProperty((PropertyData)new PropertyStringImpl(id, value));
    }

    private void addPropertyInteger(PropertiesImpl props, String typeId, Set<String> filter, String id, long value) {
        if (!this.checkAddProperty((Properties)props, typeId, filter, id)) {
            return;
        }
        props.addProperty((PropertyData)new PropertyIntegerImpl(id, BigInteger.valueOf(value)));
    }

    private void addPropertyBoolean(PropertiesImpl props, String typeId, Set<String> filter, String id, boolean value) {
        if (!this.checkAddProperty((Properties)props, typeId, filter, id)) {
            return;
        }
        props.addProperty((PropertyData)new PropertyBooleanImpl(id, Boolean.valueOf(value)));
    }

    private void addPropertyDateTime(PropertiesImpl props, String typeId, Set<String> filter, String id, GregorianCalendar value) {
        if (!this.checkAddProperty((Properties)props, typeId, filter, id)) {
            return;
        }
        props.addProperty((PropertyData)new PropertyDateTimeImpl(id, value));
    }

    private boolean checkAddProperty(Properties properties, String typeId, Set<String> filter, String id) {
        if (properties == null || properties.getProperties() == null) {
            throw new IllegalArgumentException("Properties must not be null!");
        }
        if (id == null) {
            throw new IllegalArgumentException("Id must not be null!");
        }
        TypeDefinition type = this.fTypes.getType(typeId);
        if (type == null) {
            throw new IllegalArgumentException("Unknown type: " + typeId);
        }
        if (!type.getPropertyDefinitions().containsKey(id)) {
            throw new IllegalArgumentException("Unknown property: " + id);
        }
        String queryName = ((PropertyDefinition)type.getPropertyDefinitions().get(id)).getQueryName();
        if (queryName != null && filter != null) {
            if (!filter.contains(queryName)) {
                return false;
            }
            filter.remove(queryName);
        }
        return true;
    }

    private boolean addPropertyDefault(PropertiesImpl props, PropertyDefinition<?> propDef) {
        if (props == null || props.getProperties() == null) {
            throw new IllegalArgumentException("Props must not be null!");
        }
        if (propDef == null) {
            return false;
        }
        List defaultValue = propDef.getDefaultValue();
        if (defaultValue != null && !defaultValue.isEmpty()) {
            switch (propDef.getPropertyType()) {
                case BOOLEAN: {
                    props.addProperty((PropertyData)new PropertyBooleanImpl(propDef.getId(), defaultValue));
                    break;
                }
                case DATETIME: {
                    props.addProperty((PropertyData)new PropertyDateTimeImpl(propDef.getId(), defaultValue));
                    break;
                }
                case DECIMAL: {
                    props.addProperty((PropertyData)new PropertyDecimalImpl(propDef.getId(), defaultValue));
                    break;
                }
                case HTML: {
                    props.addProperty((PropertyData)new PropertyHtmlImpl(propDef.getId(), defaultValue));
                    break;
                }
                case ID: {
                    props.addProperty((PropertyData)new PropertyIdImpl(propDef.getId(), defaultValue));
                    break;
                }
                case INTEGER: {
                    props.addProperty((PropertyData)new PropertyIntegerImpl(propDef.getId(), defaultValue));
                    break;
                }
                case STRING: {
                    props.addProperty((PropertyData)new PropertyStringImpl(propDef.getId(), defaultValue));
                    break;
                }
                case URI: {
                    props.addProperty((PropertyData)new PropertyUriImpl(propDef.getId(), defaultValue));
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown datatype! Spec change?");
                }
            }
            return true;
        }
        return false;
    }

    private AllowableActions compileAllowableActions(File file, boolean userReadOnly) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null!");
        }
        if (!file.exists()) {
            throw new CmisObjectNotFoundException("Object not found!");
        }
        boolean isReadOnly = !file.canWrite();
        boolean isFolder = file.isDirectory();
        boolean isRoot = this.fRoot.equals(file);
        HashSet<Action> aas = new HashSet<Action>();
        this.addAction(aas, Action.CAN_GET_OBJECT_PARENTS, !isRoot);
        this.addAction(aas, Action.CAN_GET_PROPERTIES, true);
        this.addAction(aas, Action.CAN_UPDATE_PROPERTIES, !userReadOnly && !isReadOnly);
        this.addAction(aas, Action.CAN_MOVE_OBJECT, !userReadOnly);
        this.addAction(aas, Action.CAN_DELETE_OBJECT, !userReadOnly && !isReadOnly);
        this.addAction(aas, Action.CAN_GET_ACL, true);
        if (isFolder) {
            this.addAction(aas, Action.CAN_GET_DESCENDANTS, true);
            this.addAction(aas, Action.CAN_GET_CHILDREN, true);
            this.addAction(aas, Action.CAN_GET_FOLDER_PARENT, !isRoot);
            this.addAction(aas, Action.CAN_GET_FOLDER_TREE, true);
            this.addAction(aas, Action.CAN_CREATE_DOCUMENT, !userReadOnly);
            this.addAction(aas, Action.CAN_CREATE_FOLDER, !userReadOnly);
            this.addAction(aas, Action.CAN_DELETE_TREE, !userReadOnly && !isReadOnly);
        } else {
            this.addAction(aas, Action.CAN_GET_CONTENT_STREAM, true);
            this.addAction(aas, Action.CAN_SET_CONTENT_STREAM, !userReadOnly && !isReadOnly);
            this.addAction(aas, Action.CAN_DELETE_CONTENT_STREAM, !userReadOnly && !isReadOnly);
            this.addAction(aas, Action.CAN_GET_ALL_VERSIONS, true);
        }
        AllowableActionsImpl result = new AllowableActionsImpl();
        result.setAllowableActions(aas);
        return result;
    }

    private void addAction(Set<Action> aas, Action action, boolean condition) {
        if (condition) {
            aas.add(action);
        }
    }

    private Acl compileAcl(File file) {
        AccessControlListImpl result = new AccessControlListImpl();
        result.setAces(new ArrayList());
        for (Map.Entry<String, Boolean> ue : this.fUserMap.entrySet()) {
            AccessControlPrincipalDataImpl principal = new AccessControlPrincipalDataImpl();
            principal.setPrincipalId(ue.getKey());
            AccessControlEntryImpl entry = new AccessControlEntryImpl();
            entry.setPrincipal((Principal)principal);
            entry.setPermissions(new ArrayList());
            entry.getPermissions().add(CMIS_READ);
            if (!ue.getValue().booleanValue() && file.canWrite()) {
                entry.getPermissions().add(CMIS_WRITE);
                entry.getPermissions().add(CMIS_ALL);
            }
            entry.setDirect(true);
            result.getAces().add(entry);
        }
        return result;
    }

    private void writePropertiesFile(File file, Properties properties) {
        File propFile = this.getPropertiesFile(file);
        if (properties == null || properties.getProperties() == null || properties.getProperties().size() == 0) {
            propFile.delete();
            return;
        }
        CmisObjectType object = new CmisObjectType();
        object.setProperties(Converter.convert((Properties)properties));
        try {
            JaxBHelper.CMIS_EXTRA_OBJECT_FACTORY.createObject(object);
            JAXBElement objElement = JaxBHelper.CMIS_EXTRA_OBJECT_FACTORY.createObject(object);
            Marshaller m = JaxBHelper.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.marshal((Object)objElement, propFile);
        }
        catch (Exception e) {
            throw new CmisStorageException("Couldn't store properties!", (Throwable)e);
        }
    }

    private GregorianCalendar millisToCalendar(long millis) {
        GregorianCalendar result = new GregorianCalendar();
        result.setTimeZone(TimeZone.getTimeZone("GMT"));
        result.setTimeInMillis(millis);
        return result;
    }

    private Set<String> splitFilter(String filter) {
        if (filter == null) {
            return null;
        }
        if (filter.trim().length() == 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (String s : filter.split(",")) {
            if ((s = s.trim()).equals("*")) {
                return null;
            }
            if (s.length() <= 0) continue;
            result.add(s);
        }
        result.add("cmis:objectId");
        result.add("cmis:objectTypeId");
        result.add("cmis:baseTypeId");
        return result;
    }

    private String getTypeId(Properties properties) {
        PropertyData typeProperty = (PropertyData)properties.getProperties().get("cmis:objectTypeId");
        if (!(typeProperty instanceof PropertyId)) {
            throw new CmisInvalidArgumentException("Type id must be set!");
        }
        String typeId = (String)((PropertyId)typeProperty).getFirstValue();
        if (typeId == null) {
            throw new CmisInvalidArgumentException("Type id must be set!");
        }
        return typeId;
    }

    private String getIdProperty(Properties properties, String name) {
        PropertyData property = (PropertyData)properties.getProperties().get(name);
        if (!(property instanceof PropertyId)) {
            return null;
        }
        return (String)((PropertyId)property).getFirstValue();
    }

    private String getStringProperty(Properties properties, String name) {
        PropertyData property = (PropertyData)properties.getProperties().get(name);
        if (!(property instanceof PropertyString)) {
            return null;
        }
        return (String)((PropertyString)property).getFirstValue();
    }

    private GregorianCalendar getDateTimeProperty(Properties properties, String name) {
        PropertyData property = (PropertyData)properties.getProperties().get(name);
        if (!(property instanceof PropertyDateTime)) {
            return null;
        }
        return (GregorianCalendar)((PropertyDateTime)property).getFirstValue();
    }

    private boolean checkUser(CallContext context, boolean writeRequired) {
        if (context == null) {
            throw new CmisPermissionDeniedException("No user context!");
        }
        Boolean readOnly = this.fUserMap.get(context.getUsername());
        if (readOnly == null) {
            throw new CmisPermissionDeniedException("Unknown user!");
        }
        if (readOnly.booleanValue() && writeRequired) {
            throw new CmisPermissionDeniedException("No write permission!");
        }
        return readOnly;
    }

    private File getPropertiesFile(File file) {
        if (file.isDirectory()) {
            return new File(file, SHADOW_FOLDER);
        }
        return new File(file.getAbsolutePath() + SHADOW_EXT);
    }

    private File getFile(String id) {
        try {
            return this.idToFile(id);
        }
        catch (Exception e) {
            throw new CmisObjectNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    private File idToFile(String id) throws Exception {
        if (id == null || id.length() == 0) {
            throw new CmisInvalidArgumentException("Id is not valid!");
        }
        if (id.equals(ROOT_ID)) {
            return this.fRoot;
        }
        return new File(this.fRoot, new String(Base64.decodeBase64((byte[])id.getBytes("ISO-8859-1")), "UTF-8").replace('/', File.separatorChar));
    }

    private String getId(File file) {
        try {
            return this.fileToId(file);
        }
        catch (Exception e) {
            throw new CmisRuntimeException(e.getMessage());
        }
    }

    private String fileToId(File file) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("File is not valid!");
        }
        if (this.fRoot.equals(file)) {
            return ROOT_ID;
        }
        String path = this.getRepositoryPath(file);
        return new String(Base64.encodeBase64((byte[])path.getBytes("UTF-8")), "ISO-8859-1");
    }

    private String getRepositoryPath(File file) {
        return file.getAbsolutePath().substring(this.fRoot.getAbsolutePath().length()).replace(File.separatorChar, '/');
    }

    private void warn(String msg, Throwable t) {
        log.warn((Object)("<" + this.fRepositoryId + "> " + msg), t);
    }

    private void debug(String msg) {
        this.debug(msg, null);
    }

    private void debug(String msg, Throwable t) {
        log.debug((Object)("<" + this.fRepositoryId + "> " + msg), t);
    }
}

