/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.fileshare;

import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyDateTime;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;

public final class FileShareUtils {
    private FileShareUtils() {
    }

    public static boolean getBooleanParameter(Boolean value, boolean def) {
        if (value == null) {
            return def;
        }
        return value;
    }

    public static GregorianCalendar millisToCalendar(long millis) {
        GregorianCalendar result = new GregorianCalendar();
        result.setTimeZone(TimeZone.getTimeZone("GMT"));
        result.setTimeInMillis((long)(Math.ceil((double)millis / 1000.0) * 1000.0));
        return result;
    }

    public static Set<String> splitFilter(String filter) {
        if (filter == null) {
            return null;
        }
        if (filter.trim().length() == 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (String s : filter.split(",")) {
            if ((s = s.trim()).equals("*")) {
                return null;
            }
            if (s.length() <= 0) continue;
            result.add(s);
        }
        result.add("cmis:objectId");
        result.add("cmis:objectTypeId");
        result.add("cmis:baseTypeId");
        return result;
    }

    public static String getObjectTypeId(Properties properties) {
        PropertyData typeProperty = (PropertyData)properties.getProperties().get("cmis:objectTypeId");
        if (!(typeProperty instanceof PropertyId)) {
            throw new CmisInvalidArgumentException("Type Id must be set!");
        }
        String typeId = (String)((PropertyId)typeProperty).getFirstValue();
        if (typeId == null) {
            throw new CmisInvalidArgumentException("Type Id must be set!");
        }
        return typeId;
    }

    public static String getIdProperty(Properties properties, String name) {
        PropertyData property = (PropertyData)properties.getProperties().get(name);
        if (!(property instanceof PropertyId)) {
            return null;
        }
        return (String)((PropertyId)property).getFirstValue();
    }

    public static String getStringProperty(Properties properties, String name) {
        PropertyData property = (PropertyData)properties.getProperties().get(name);
        if (!(property instanceof PropertyString)) {
            return null;
        }
        return (String)((PropertyString)property).getFirstValue();
    }

    public static GregorianCalendar getDateTimeProperty(Properties properties, String name) {
        PropertyData property = (PropertyData)properties.getProperties().get(name);
        if (!(property instanceof PropertyDateTime)) {
            return null;
        }
        return (GregorianCalendar)((PropertyDateTime)property).getFirstValue();
    }
}

