/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.fileshare;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;

public class ContentRangeInputStream
extends FilterInputStream {
    private static final int BUFFER_SIZE = 4096;
    private long offset;
    private long length;
    private long remaining;

    public ContentRangeInputStream(InputStream stream, BigInteger offset, BigInteger length) {
        super(stream);
        this.offset = offset != null ? offset.longValue() : 0L;
        this.remaining = this.length = length != null ? length.longValue() : Long.MAX_VALUE;
        if (this.offset > 0L) {
            this.skipBytes();
        }
    }

    private void skipBytes() {
        try {
            long skipped;
            for (long remainingSkipBytes = this.offset; remainingSkipBytes > 0L; remainingSkipBytes -= skipped) {
                skipped = super.skip(remainingSkipBytes);
                if (skipped != 0L) continue;
                this.skipBytesByReading(remainingSkipBytes);
                break;
            }
        }
        catch (IOException e) {
            throw new CmisRuntimeException("Skipping the stream failed!", (Throwable)e);
        }
    }

    private void skipBytesByReading(long remainingSkipBytes) {
        try {
            long skipped;
            byte[] buffer = new byte[4096];
            while (remainingSkipBytes > 0L && (skipped = (long)super.read(buffer, 0, (int)Math.min((long)buffer.length, remainingSkipBytes))) != -1L) {
                remainingSkipBytes -= skipped;
            }
        }
        catch (IOException e) {
            throw new CmisRuntimeException("Reading the stream failed!", (Throwable)e);
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.remaining <= 0L) {
            return 0L;
        }
        long skipped = super.skip(n);
        this.remaining -= skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        if (this.remaining <= 0L) {
            return 0;
        }
        int avail = super.available();
        if (this.remaining < (long)avail) {
            return (int)this.remaining;
        }
        return avail;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        --this.remaining;
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        int readBytes = super.read(b, off, (int)Math.min((long)len, this.remaining));
        if (readBytes == -1) {
            return -1;
        }
        this.remaining -= (long)readBytes;
        return readBytes;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

