/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.server.impl.CallContextImpl;
import org.apache.chemistry.opencmis.server.shared.CallContextHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtils {
    public static CallContext createContext(HttpServletRequest request, ServletContext servletContext, String binding, CallContextHandler callContextHandler) {
        String acceptLanguage;
        Map<String, String> callContextMap;
        String[] pathFragments = HttpUtils.splitPath(request);
        String repositoryId = null;
        if (pathFragments.length > 0) {
            repositoryId = pathFragments[0];
        }
        CallContextImpl context = new CallContextImpl(binding, repositoryId, true);
        if (callContextHandler != null && (callContextMap = callContextHandler.getCallContextMap(request)) != null) {
            for (Map.Entry<String, String> e : callContextMap.entrySet()) {
                context.put(e.getKey(), e.getValue());
            }
        }
        context.put("servletContext", servletContext);
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader != null) {
            rangeHeader = rangeHeader.trim();
            BigInteger offset = null;
            BigInteger length = null;
            int eq = rangeHeader.indexOf(61);
            int ds = rangeHeader.indexOf(45);
            if (eq > 0 && ds > eq) {
                String offsetStr = rangeHeader.substring(eq + 1, ds).trim();
                if (offsetStr.length() > 0) {
                    offset = new BigInteger(offsetStr);
                }
                if (ds < rangeHeader.length()) {
                    String lengthStr = rangeHeader.substring(ds + 1).trim();
                    if (lengthStr.length() > 0) {
                        length = offset == null ? new BigInteger(lengthStr) : new BigInteger(lengthStr).subtract(offset);
                    }
                    if (offset != null) {
                        context.put("offset", offset);
                    }
                    if (length != null) {
                        context.put("length", length);
                    }
                }
            }
        }
        if ((acceptLanguage = request.getHeader("Accept-Language")) != null) {
            String[] locale = acceptLanguage.split("-");
            context.put("language", locale[0].trim());
            if (locale.length > 1) {
                int x = locale[1].indexOf(44);
                if (x == -1) {
                    context.put("country", locale[1].trim());
                } else {
                    context.put("country", locale[1].substring(0, x).trim());
                }
            }
        }
        return context;
    }

    public static String[] splitPath(HttpServletRequest request) {
        String p = request.getPathInfo();
        if (p == null) {
            return new String[0];
        }
        return p.substring(1).split("/");
    }

    public static String getStringParameter(HttpServletRequest request, String name) {
        if (name == null) {
            return null;
        }
        Map parameters = request.getParameterMap();
        for (Map.Entry parameter : parameters.entrySet()) {
            if (!name.equalsIgnoreCase((String)parameter.getKey())) continue;
            if (parameter.getValue() == null) {
                return null;
            }
            return ((String[])parameter.getValue())[0];
        }
        return null;
    }

    public static boolean getBooleanParameter(HttpServletRequest request, String name, boolean def) {
        String value = HttpUtils.getStringParameter(request, name);
        if (value == null || value.length() == 0) {
            return def;
        }
        return Boolean.valueOf(value);
    }

    public static Boolean getBooleanParameter(HttpServletRequest request, String name) {
        String value = HttpUtils.getStringParameter(request, name);
        if (value == null || value.length() == 0) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public static BigInteger getBigIntegerParameter(HttpServletRequest request, String name, long def) {
        BigInteger result = HttpUtils.getBigIntegerParameter(request, name);
        if (result == null) {
            result = BigInteger.valueOf(def);
        }
        return result;
    }

    public static BigInteger getBigIntegerParameter(HttpServletRequest request, String name) {
        String value = HttpUtils.getStringParameter(request, name);
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return new BigInteger(value);
        }
        catch (Exception e) {
            throw new CmisInvalidArgumentException("Invalid parameter '" + name + "'!");
        }
    }

    public static <T> T getEnumParameter(HttpServletRequest request, String name, Class<T> clazz) {
        String value = HttpUtils.getStringParameter(request, name);
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            Method m = clazz.getMethod("fromValue", String.class);
            return (T)m.invoke(null, value);
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw new CmisInvalidArgumentException("Invalid parameter '" + name + "'!");
            }
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

