/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceContext;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAccessControlListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisContentStreamType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisExtensionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertiesType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumIncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.jaxb.VersioningServicePort;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.webservices.AbstractService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(endpointInterface="org.apache.chemistry.opencmis.commons.impl.jaxb.VersioningServicePort")
public class VersioningService
extends AbstractService
implements VersioningServicePort {
    @Resource
    WebServiceContext wsContext;

    public void cancelCheckOut(String repositoryId, String objectId, Holder<CmisExtensionType> extension) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            ExtensionsData extData = Converter.convertExtensionHolder(extension);
            service.cancelCheckOut(repositoryId, objectId, extData);
            Converter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, CmisPropertiesType properties, CmisContentStreamType contentStream, String checkinComment, List<String> policies, CmisAccessControlListType addAces, CmisAccessControlListType removeAces, Holder<CmisExtensionType> extension) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            org.apache.chemistry.opencmis.commons.spi.Holder objectIdHolder = Converter.convertHolder(objectId);
            ExtensionsData extData = Converter.convertExtensionHolder(extension);
            service.checkIn(repositoryId, objectIdHolder, major, Converter.convert((CmisPropertiesType)properties), Converter.convert((CmisContentStreamType)contentStream), checkinComment, policies, Converter.convert((CmisAccessControlListType)addAces, null), Converter.convert((CmisAccessControlListType)removeAces, null), extData);
            Converter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)objectIdHolder, objectId);
            Converter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void checkOut(String repositoryId, Holder<String> objectId, Holder<CmisExtensionType> extension, Holder<Boolean> contentCopied) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            org.apache.chemistry.opencmis.commons.spi.Holder objectIdHolder = Converter.convertHolder(objectId);
            org.apache.chemistry.opencmis.commons.spi.Holder contentCopiedHolder = new org.apache.chemistry.opencmis.commons.spi.Holder();
            ExtensionsData extData = Converter.convertExtensionHolder(extension);
            service.checkOut(repositoryId, objectIdHolder, extData, contentCopiedHolder);
            if (contentCopied != null) {
                contentCopied.value = contentCopiedHolder.getValue();
            }
            Converter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)objectIdHolder, objectId);
            Converter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public List<CmisObjectType> getAllVersions(String repositoryId, String versionSeriesId, String filter, Boolean includeAllowableActions, CmisExtensionType extension) throws CmisException {
        ArrayList<CmisObjectType> arrayList;
        List versions;
        CmisService service;
        block6: {
            service = null;
            service = this.getService(this.wsContext, repositoryId);
            versions = service.getAllVersions(repositoryId, null, versionSeriesId, filter, includeAllowableActions, Converter.convert((CmisExtensionType)extension));
            if (versions != null) break block6;
            List<CmisObjectType> list = null;
            this.closeService(service);
            return list;
        }
        try {
            ArrayList<CmisObjectType> result = new ArrayList<CmisObjectType>();
            for (ObjectData object : versions) {
                result.add(Converter.convert((ObjectData)object));
            }
            arrayList = result;
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return arrayList;
    }

    public CmisObjectType getObjectOfLatestVersion(String repositoryId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, CmisExtensionType extension) throws CmisException {
        CmisObjectType cmisObjectType;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisObjectType = Converter.convert((ObjectData)service.getObjectOfLatestVersion(repositoryId, null, versionSeriesId, major, filter, includeAllowableActions, (IncludeRelationships)Converter.convert(IncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePolicyIds, includeAcl, Converter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisObjectType;
    }

    public CmisPropertiesType getPropertiesOfLatestVersion(String repositoryId, String versionSeriesId, Boolean major, String filter, CmisExtensionType extension) throws CmisException {
        CmisPropertiesType cmisPropertiesType;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisPropertiesType = Converter.convert((Properties)service.getPropertiesOfLatestVersion(repositoryId, null, versionSeriesId, major, filter, Converter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisPropertiesType;
    }
}

