/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class XMLDocumentBase {
    public static final String PREFIX_ATOM = "atom";
    public static final String PREFIX_CMIS = "cmis";
    public static final String PREFIX_RESTATOM = "cmisra";
    public static final String PREFIX_APP = "app";
    public static final String PREFIX_XSI = "xsi";
    private XMLStreamWriter fWriter;

    public void setNamespaces() throws XMLStreamException {
        this.fWriter.setPrefix(PREFIX_ATOM, "http://www.w3.org/2005/Atom");
        this.fWriter.setPrefix(PREFIX_CMIS, "http://docs.oasis-open.org/ns/cmis/core/200908/");
        this.fWriter.setPrefix(PREFIX_RESTATOM, "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
        this.fWriter.setPrefix(PREFIX_APP, "http://www.w3.org/2007/app");
        this.fWriter.setPrefix(PREFIX_XSI, "http://www.w3.org/2001/XMLSchema-instance");
    }

    public void writeNamespace(String namespaceUri) throws XMLStreamException {
        this.fWriter.writeNamespace(this.fWriter.getPrefix(namespaceUri), namespaceUri);
    }

    public void startDocument(OutputStream out) throws XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.fWriter = factory.createXMLStreamWriter(out);
        this.fWriter.writeStartDocument();
        this.setNamespaces();
    }

    public void endDocument() throws XMLStreamException {
        if (this.fWriter == null) {
            return;
        }
        this.fWriter.writeEndDocument();
        this.fWriter.close();
    }

    public XMLStreamWriter getWriter() {
        return this.fWriter;
    }

    protected void setWriter(XMLStreamWriter writer) {
        this.fWriter = writer;
    }
}

