/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.JaxBHelper;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRepositoryInfoType;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomDocumentBase;

public class ServiceDocument
extends AtomDocumentBase {
    public void startServiceDocument() throws XMLStreamException {
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement("http://www.w3.org/2007/app", "service");
        this.writeNamespace("http://www.w3.org/2007/app");
        this.writeNamespace("http://www.w3.org/2005/Atom");
        this.writeNamespace("http://docs.oasis-open.org/ns/cmis/core/200908/");
        this.writeNamespace("http://docs.oasis-open.org/ns/cmis/restatom/200908/");
    }

    public void endServiceDocument() throws XMLStreamException {
        this.getWriter().writeEndElement();
    }

    public void startWorkspace(String title) throws XMLStreamException {
        this.getWriter().writeStartElement("http://www.w3.org/2007/app", "workspace");
        this.writeSimpleTag("http://www.w3.org/2005/Atom", "title", title);
    }

    public void endWorkspace() throws XMLStreamException {
        this.getWriter().writeEndElement();
    }

    public void writeRepositoryInfo(RepositoryInfo repInfo) throws XMLStreamException, JAXBException {
        CmisRepositoryInfoType repInfoJaxb = Converter.convert((RepositoryInfo)repInfo);
        if (repInfoJaxb == null) {
            return;
        }
        JaxBHelper.marshal((Object)JaxBHelper.CMIS_EXTRA_OBJECT_FACTORY.createRepositoryInfo(repInfoJaxb), (XMLStreamWriter)this.getWriter(), (boolean)true);
    }

    public void writeUriTemplate(String template, String type, String mediatype) throws XMLStreamException {
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "uritemplate");
        this.writeSimpleTag("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "template", template);
        this.writeSimpleTag("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "type", type);
        this.writeSimpleTag("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "mediatype", mediatype);
        xsw.writeEndElement();
    }
}

