/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.util.ArrayList;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.runtime.AbstractCmisObject;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.spi.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFilableCmisObject
extends AbstractCmisObject
implements FileableCmisObject {
    private static final long serialVersionUID = 1L;

    public List<Folder> getParents() {
        String objectId = this.getObjectId();
        List bindingParents = this.getBinding().getNavigationService().getObjectParents(this.getRepositoryId(), objectId, this.getPropertyQueryName("cmis:objectId"), Boolean.valueOf(false), IncludeRelationships.NONE, null, Boolean.valueOf(false), null);
        ArrayList<Folder> parents = new ArrayList<Folder>();
        for (ObjectParentData p : bindingParents) {
            if (p == null || p.getObject() == null || p.getObject().getProperties() == null) {
                throw new CmisRuntimeException("Repository sent invalid data!");
            }
            PropertyData idProperty = (PropertyData)p.getObject().getProperties().getProperties().get("cmis:objectId");
            if (!(idProperty instanceof PropertyId)) {
                throw new CmisRuntimeException("Repository sent invalid data! No object id!");
            }
            ObjectId parentId = this.getSession().createObjectId((String)idProperty.getFirstValue());
            CmisObject parentFolder = this.getSession().getObject(parentId);
            if (!(parentFolder instanceof Folder)) {
                throw new CmisRuntimeException("Repository sent invalid data! Object is not a folder!");
            }
            parents.add((Folder)parentFolder);
        }
        return parents;
    }

    public List<String> getPaths() {
        String objectId = this.getObjectId();
        List bindingParents = this.getBinding().getNavigationService().getObjectParents(this.getRepositoryId(), objectId, this.getPropertyQueryName("cmis:path"), Boolean.valueOf(false), IncludeRelationships.NONE, null, Boolean.valueOf(true), null);
        ArrayList<String> paths = new ArrayList<String>();
        for (ObjectParentData p : bindingParents) {
            if (p == null || p.getObject() == null || p.getObject().getProperties() == null) {
                throw new CmisRuntimeException("Repository sent invalid data!");
            }
            PropertyData pathProperty = (PropertyData)p.getObject().getProperties().getProperties().get("cmis:path");
            if (!(pathProperty instanceof PropertyString)) {
                throw new CmisRuntimeException("Repository sent invalid data! No path property!");
            }
            if (p.getRelativePathSegment() == null) {
                throw new CmisRuntimeException("Repository sent invalid data! No relative path segement!");
            }
            String folderPath = (String)pathProperty.getFirstValue();
            paths.add(folderPath + (folderPath.endsWith("/") ? "" : "/") + p.getRelativePathSegment());
        }
        return paths;
    }

    public FileableCmisObject move(ObjectId sourceFolderId, ObjectId targetFolderId) {
        String objectId = this.getObjectId();
        Holder objectIdHolder = new Holder((Object)objectId);
        if (sourceFolderId == null || sourceFolderId.getId() == null) {
            throw new IllegalArgumentException("Source folder id must be set!");
        }
        if (targetFolderId == null || targetFolderId.getId() == null) {
            throw new IllegalArgumentException("Target folder id must be set!");
        }
        this.getBinding().getObjectService().moveObject(this.getRepositoryId(), objectIdHolder, targetFolderId.getId(), sourceFolderId.getId(), null);
        if (objectIdHolder.getValue() == null) {
            return null;
        }
        CmisObject movedObject = this.getSession().getObject(this.getSession().createObjectId((String)objectIdHolder.getValue()));
        if (!(movedObject instanceof FileableCmisObject)) {
            throw new CmisRuntimeException("Moved object is invalid!");
        }
        return (FileableCmisObject)movedObject;
    }

    public void addToFolder(ObjectId folderId, boolean allVersions) {
        String objectId = this.getObjectId();
        if (folderId == null || folderId.getId() == null) {
            throw new IllegalArgumentException("Folder Id must be set!");
        }
        this.getBinding().getMultiFilingService().addObjectToFolder(this.getRepositoryId(), objectId, folderId.getId(), Boolean.valueOf(allVersions), null);
    }

    public void removeFromFolder(ObjectId folderId) {
        String objectId = this.getObjectId();
        if (folderId == null || folderId.getId() == null) {
            throw new IllegalArgumentException("Folder Id must be set!");
        }
        this.getBinding().getMultiFilingService().removeObjectFromFolder(this.getRepositoryId(), objectId, folderId.getId(), null);
    }
}

