/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.bridge.lrucache;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;

public class CmisBindingCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final LinkedHashMap<String, CmisBinding> cache;

    public CmisBindingCache(final int size) {
        this.cache = new LinkedHashMap<String, CmisBinding>(size + 1, 0.7f, true){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean removeEldestEntry(Map.Entry<String, CmisBinding> eldest) {
                return this.size() > size;
            }
        };
    }

    public CmisBinding getCmisBinding(CallContext context) {
        this.lock.writeLock().lock();
        try {
            CmisBinding cmisBinding = this.cache.get(this.getCacheKey(context));
            return cmisBinding;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmisBinding putCmisBinding(CallContext context, CmisBinding binding) {
        this.lock.writeLock().lock();
        try {
            String key = this.getCacheKey(context);
            CmisBinding extistingBinding = this.cache.get(this.getCacheKey(context));
            if (extistingBinding == null) {
                this.cache.put(key, binding);
            } else {
                binding = extistingBinding;
            }
            CmisBinding cmisBinding = binding;
            return cmisBinding;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected String getCacheKey(CallContext context) {
        String key;
        String repositoryId = context.getRepositoryId();
        String user = context.getUsername();
        String string = key = repositoryId == null ? "" : repositoryId;
        if (user != null) {
            key = key + "\n" + user;
        }
        return key;
    }
}

