/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.bridge.httpsession.sample;

import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.bridge.client.SimpleCmisBindingFactory;
import org.apache.chemistry.opencmis.bridge.httpsession.HttpSessionCmisService;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryInfoImpl;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;

public class SimpleForwardingCmisService
extends HttpSessionCmisService {
    private static final long serialVersionUID = 1L;
    private static final String BINDING_PARAMETERS_PREFIX = "forwarding.binding.";
    private Map<String, String> bindingParameters;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.bindingParameters = new HashMap<String, String>();
        for (Map.Entry<String, String> p : parameters.entrySet()) {
            if (!p.getKey().startsWith(BINDING_PARAMETERS_PREFIX)) continue;
            this.bindingParameters.put(p.getKey().substring(BINDING_PARAMETERS_PREFIX.length()), p.getValue());
        }
    }

    @Override
    public CmisBinding createCmisBinding() {
        return SimpleCmisBindingFactory.createCmisBinding(this.getCallContext(), this.bindingParameters);
    }

    @Override
    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        RepositoryInfo repInfo = this.getCmisBinding().getRepositoryService().getRepositoryInfo(repositoryId, extension);
        RepositoryInfoImpl newRepInfo = new RepositoryInfoImpl(repInfo);
        newRepInfo.setDescription(repInfo.getDescription() + " (forwarded by the OpenCMIS Bridge)");
        return newRepInfo;
    }
}

