/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.bridge.client;

import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.CmisBindingFactory;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCmisBindingFactory {
    private static final CmisBindingFactory BINDING_FACTORY = CmisBindingFactory.newInstance();

    public static CmisBinding createCmisBinding(CallContext context, Map<String, String> bindingParameters) {
        HashMap<String, String> parameters = new HashMap<String, String>(bindingParameters);
        parameters.put("org.apache.chemistry.opencmis.user", context.getUsername());
        parameters.put("org.apache.chemistry.opencmis.password", context.getPassword());
        String bindingTypeStr = (String)parameters.get("org.apache.chemistry.opencmis.binding.spi.type");
        BindingType bindingType = BindingType.fromValue((String)bindingTypeStr);
        CmisBinding binding = null;
        switch (bindingType) {
            case WEBSERVICES: {
                binding = BINDING_FACTORY.createCmisWebServicesBinding(parameters);
                break;
            }
            case BROWSER: {
                binding = BINDING_FACTORY.createCmisBrowserBinding(parameters);
                break;
            }
            default: {
                binding = BINDING_FACTORY.createCmisAtomPubBinding(parameters);
            }
        }
        return binding;
    }
}

