/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.bridge;

import java.io.File;
import java.math.BigInteger;
import java.util.Map;
import org.apache.chemistry.opencmis.bridge.FilterCmisService;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractServiceFactory;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.support.CmisServiceWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBridgeServiceFactory
extends AbstractServiceFactory {
    public static final String BRIDGE_TEMP_DIRECTORY = "bridge.tempDirectory";
    public static final String BRIDGE_MEMORY_THERESHOLD = "bridge.memoryThreshold";
    public static final String BRIDGE_MAX_CONTENT_SIZE = "bridge.maxContentSize";
    public static final String SERVICE_CLASS = "service.class";
    public static final String SERVICE_DEFAULT_MAX_ITEMS_OBJECTS = "service.defaultMaxItems";
    public static final String SERVICE_DEFAULT_DEPTH_OBJECTS = "service.defaultDepth";
    public static final String SERVICE_DEFAULT_MAX_ITEMS_TYPES = "service.defaultTypesMaxItems";
    public static final String SERVICE_DEFAULT_DEPTH_TYPES = "service.defaultTypesDepth";
    private static final BigInteger DEFAULT_MAX_ITEMS_OBJECTS = BigInteger.valueOf(100000L);
    private static final BigInteger DEFAULT_DEPTH_OBJECTS = BigInteger.valueOf(100L);
    private static final BigInteger DEFAULT_MAX_ITEMS_TYPES = BigInteger.valueOf(1000L);
    private static final BigInteger DEFAULT_DEPTH_TYPES = BigInteger.valueOf(10L);
    private ThreadLocal<CmisServiceWrapper<FilterCmisService>> threadLocalService = new ThreadLocal();
    private Map<String, String> parameters;
    private Class<?> serviceClass;
    private BigInteger defaultMaxItems;
    private BigInteger defaultDepth;
    private BigInteger defaultTypesMaxItems;
    private BigInteger defaultTypesDepth;
    private File tempDirectory;
    private int memoryThreshold;
    private long maxContentSize;

    public void init(Map<String, String> parameters) {
        this.parameters = parameters;
        String tempDirectoryStr = parameters.get(BRIDGE_TEMP_DIRECTORY);
        this.tempDirectory = tempDirectoryStr == null || tempDirectoryStr.trim().length() == 0 ? super.getTempDirectory() : new File(tempDirectoryStr.trim());
        try {
            String memoryThresholdStr = parameters.get(BRIDGE_MEMORY_THERESHOLD);
            this.memoryThreshold = memoryThresholdStr == null || memoryThresholdStr.trim().length() == 0 ? super.getMemoryThreshold() : Integer.parseInt(memoryThresholdStr.trim());
            String maxContentSizeStr = parameters.get(BRIDGE_MAX_CONTENT_SIZE);
            this.maxContentSize = maxContentSizeStr == null || maxContentSizeStr.trim().length() == 0 ? super.getMaxContentSize() : Long.parseLong(maxContentSizeStr.trim());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Could not parse bride configuration values: " + e.getMessage(), e);
        }
        String className = parameters.get(SERVICE_CLASS);
        if (className == null || className.trim().length() == 0) {
            throw new RuntimeException("Service class name is not set!");
        }
        try {
            this.serviceClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Service class name cannot be found: " + e.getMessage(), e);
        }
        if (this.serviceClass.isAssignableFrom(FilterCmisService.class)) {
            throw new RuntimeException("Service class is not a sub class of FilterCmisService!");
        }
        try {
            this.defaultMaxItems = this.getBigIntegerParameter(SERVICE_DEFAULT_MAX_ITEMS_OBJECTS, DEFAULT_MAX_ITEMS_OBJECTS);
            this.defaultDepth = this.getBigIntegerParameter(SERVICE_DEFAULT_DEPTH_OBJECTS, DEFAULT_DEPTH_OBJECTS);
            this.defaultTypesMaxItems = this.getBigIntegerParameter(SERVICE_DEFAULT_MAX_ITEMS_TYPES, DEFAULT_MAX_ITEMS_TYPES);
            this.defaultTypesDepth = this.getBigIntegerParameter(SERVICE_DEFAULT_DEPTH_TYPES, DEFAULT_DEPTH_TYPES);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Could not parse service default values: " + e.getMessage(), e);
        }
    }

    public CmisService getService(CallContext context) {
        CmisServiceWrapper wrapperService = this.threadLocalService.get();
        if (wrapperService == null) {
            wrapperService = new CmisServiceWrapper((CmisService)this.createService(context), this.defaultTypesMaxItems, this.defaultTypesDepth, this.defaultMaxItems, this.defaultDepth);
            this.threadLocalService.set((CmisServiceWrapper<FilterCmisService>)wrapperService);
        }
        ((FilterCmisService)wrapperService.getWrappedService()).setCallContext(context);
        return wrapperService;
    }

    protected abstract FilterCmisService createService(CallContext var1);

    protected Class<?> getServiceClass() {
        return this.serviceClass;
    }

    protected Map<String, String> getParameters() {
        return this.parameters;
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }

    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public long getMaxContentSize() {
        return this.maxContentSize;
    }

    protected BigInteger getBigIntegerParameter(String key, BigInteger def) {
        String value = this.parameters.get(key);
        if (value == null || value.trim().length() == 0) {
            return def;
        }
        return new BigInteger(value);
    }
}

