/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.bridge.lrucache;

import java.util.Map;
import org.apache.chemistry.opencmis.bridge.AbstractBridgeServiceFactory;
import org.apache.chemistry.opencmis.bridge.FilterCmisService;
import org.apache.chemistry.opencmis.bridge.lrucache.CmisBindingCache;
import org.apache.chemistry.opencmis.bridge.lrucache.LruCacheCmisService;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.server.CallContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LruCacheBridgeServiceFactory
extends AbstractBridgeServiceFactory {
    public static final String CACHE_SIZE = "cache.size";
    public static final int DEFAULT_CACHE_SIZE = 1000;
    private CmisBindingCache cache;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        int size = 0;
        try {
            String sizeStr = parameters.get(CACHE_SIZE);
            size = sizeStr == null || sizeStr.trim().length() == 0 ? 1000 : Integer.parseInt(sizeStr.trim());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Could not parse cache configuration values: " + e.getMessage(), e);
        }
        this.cache = new CmisBindingCache(size);
    }

    @Override
    protected FilterCmisService createService(CallContext context) {
        LruCacheCmisService service = null;
        try {
            service = (LruCacheCmisService)this.getServiceClass().newInstance();
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Could not create service instance: " + e, (Throwable)e);
        }
        service.init(this.getParameters(), this.cache);
        return service;
    }
}

