/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.bridge.httpsession;

import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpSession;
import org.apache.chemistry.opencmis.bridge.CachedBindingCmisService;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpSessionCmisService
extends CachedBindingCmisService {
    private static final long serialVersionUID = 1L;
    public static final String CMIS_BINDING = "org.apache.chemistry.opencmis.bridge.binding";
    private ReentrantReadWriteLock lock;

    public void init(Map<String, String> parameters, ReentrantReadWriteLock lock) {
        this.init(parameters);
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CmisBinding getCmisBindingFromCache() {
        HttpSession httpSession = this.getHttpSession(false);
        if (httpSession == null) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            CmisBinding cmisBinding = (CmisBinding)httpSession.getAttribute(CMIS_BINDING);
            return cmisBinding;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CmisBinding putCmisBindingIntoCache(CmisBinding binding) {
        HttpSession httpSession = this.getHttpSession(true);
        this.lock.writeLock().lock();
        try {
            CmisBinding existingBinding = (CmisBinding)httpSession.getAttribute(CMIS_BINDING);
            if (existingBinding == null) {
                httpSession.setAttribute(CMIS_BINDING, (Object)binding);
            } else {
                binding = existingBinding;
            }
            CmisBinding cmisBinding = binding;
            return cmisBinding;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public HttpSession getHttpSession(boolean create) {
        return this.getHttpServletRequest().getSession(create);
    }
}

