/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql.jdbc.AbstractJdbcType;
import org.apache.cassandra.cql.jdbc.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class JdbcInt32
extends AbstractJdbcType<Integer> {
    public static final JdbcInt32 instance = new JdbcInt32();

    JdbcInt32() {
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public int getScale(Integer obj) {
        return 0;
    }

    @Override
    public int getPrecision(Integer obj) {
        return obj.toString().length();
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public String toString(Integer obj) {
        return obj.toString();
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 4) {
            throw new MarshalException("A int is exactly 4 bytes: " + bytes.remaining());
        }
        return String.valueOf(bytes.getInt(bytes.position()));
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }

    @Override
    public int getJdbcType() {
        return 4;
    }

    @Override
    public Integer compose(ByteBuffer bytes) {
        return ByteBufferUtil.toInt(bytes);
    }

    @Override
    public ByteBuffer decompose(Integer value) {
        return ByteBufferUtil.bytes(value);
    }
}

