/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.streaming.segment;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.locks.CarbonLockFactory;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.reader.CarbonIndexFileReader;
import org.apache.carbondata.core.statusmanager.FileFormat;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.core.writer.CarbonIndexFileWriter;
import org.apache.carbondata.format.BlockIndex;
import org.apache.carbondata.format.BlockletIndex;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.streaming.CarbonStreamRecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.thrift.TBase;

public class StreamSegment {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)StreamSegment.class.getName());

    public static String open(CarbonTable table) throws IOException {
        SegmentStatusManager segmentStatusManager = new SegmentStatusManager(table.getAbsoluteTableIdentifier());
        ICarbonLock carbonLock = segmentStatusManager.getTableStatusLock();
        try {
            if (carbonLock.lockWithRetries()) {
                LOGGER.info("Acquired lock for table" + table.getDatabaseName() + "." + table.getTableName() + " for stream table get or create segment");
                LoadMetadataDetails[] details = SegmentStatusManager.readLoadMetadata((String)CarbonTablePath.getMetadataPath((String)table.getTablePath()));
                LoadMetadataDetails streamSegment = null;
                for (LoadMetadataDetails detail : details) {
                    if (FileFormat.ROW_V1 != detail.getFileFormat() || SegmentStatus.STREAMING != detail.getSegmentStatus()) continue;
                    streamSegment = detail;
                    break;
                }
                if (null == streamSegment) {
                    int n = SegmentStatusManager.createNewSegmentId((LoadMetadataDetails[])details);
                    LoadMetadataDetails newDetail = new LoadMetadataDetails();
                    newDetail.setPartitionCount("0");
                    newDetail.setLoadName("" + n);
                    newDetail.setFileFormat(FileFormat.ROW_V1);
                    newDetail.setLoadStartTime(System.currentTimeMillis());
                    newDetail.setSegmentStatus(SegmentStatus.STREAMING);
                    LoadMetadataDetails[] newDetails = new LoadMetadataDetails[details.length + 1];
                    for (int i = 0; i < details.length; ++i) {
                        newDetails[i] = details[i];
                    }
                    newDetails[i] = newDetail;
                    SegmentStatusManager.writeLoadDetailsIntoFile((String)CarbonTablePath.getTableStatusFilePath((String)table.getTablePath()), (LoadMetadataDetails[])newDetails);
                    String string = newDetail.getLoadName();
                    return string;
                }
                String string = streamSegment.getLoadName();
                return string;
            }
            LOGGER.error("Not able to acquire the lock for stream table get or create segment for table " + table.getDatabaseName() + "." + table.getTableName());
            throw new IOException("Failed to get stream segment");
        }
        finally {
            if (carbonLock.unlock()) {
                LOGGER.info("Table unlocked successfully after stream table get or create segment" + table.getDatabaseName() + "." + table.getTableName());
            } else {
                LOGGER.error("Unable to unlock table lock for stream table" + table.getDatabaseName() + "." + table.getTableName() + " during stream table get or create segment");
            }
        }
    }

    public static String close(CarbonTable table, String segmentId) throws IOException {
        SegmentStatusManager segmentStatusManager = new SegmentStatusManager(table.getAbsoluteTableIdentifier());
        ICarbonLock carbonLock = segmentStatusManager.getTableStatusLock();
        try {
            if (carbonLock.lockWithRetries()) {
                LoadMetadataDetails[] details;
                LOGGER.info("Acquired lock for table" + table.getDatabaseName() + "." + table.getTableName() + " for stream table finish segment");
                for (LoadMetadataDetails detail : details = SegmentStatusManager.readLoadMetadata((String)CarbonTablePath.getMetadataPath((String)table.getTablePath()))) {
                    if (!segmentId.equals(detail.getLoadName())) continue;
                    detail.setLoadEndTime(System.currentTimeMillis());
                    detail.setSegmentStatus(SegmentStatus.STREAMING_FINISH);
                    break;
                }
                int newSegmentId = SegmentStatusManager.createNewSegmentId((LoadMetadataDetails[])details);
                LoadMetadataDetails newDetail = new LoadMetadataDetails();
                newDetail.setPartitionCount("0");
                newDetail.setLoadName("" + newSegmentId);
                newDetail.setFileFormat(FileFormat.ROW_V1);
                newDetail.setLoadStartTime(System.currentTimeMillis());
                newDetail.setSegmentStatus(SegmentStatus.STREAMING);
                LoadMetadataDetails[] newDetails = new LoadMetadataDetails[details.length + 1];
                for (int i = 0; i < details.length; ++i) {
                    newDetails[i] = details[i];
                }
                newDetails[i] = newDetail;
                SegmentStatusManager.writeLoadDetailsIntoFile((String)CarbonTablePath.getTableStatusFilePath((String)table.getTablePath()), (LoadMetadataDetails[])newDetails);
                String string = newDetail.getLoadName();
                return string;
            }
            LOGGER.error("Not able to acquire the lock for stream table status updation for table " + table.getDatabaseName() + "." + table.getTableName());
            throw new IOException("Failed to get stream segment");
        }
        finally {
            if (carbonLock.unlock()) {
                LOGGER.info("Table unlocked successfully after table status updation" + table.getDatabaseName() + "." + table.getTableName());
            } else {
                LOGGER.error("Unable to unlock Table lock for table" + table.getDatabaseName() + "." + table.getTableName() + " during table status updation");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishStreaming(CarbonTable carbonTable) throws IOException {
        block8: {
            ICarbonLock statusLock = CarbonLockFactory.getCarbonLockObj((AbsoluteTableIdentifier)carbonTable.getTableInfo().getOrCreateAbsoluteTableIdentifier(), (String)"tablestatus.lock");
            try {
                if (statusLock.lockWithRetries()) {
                    LoadMetadataDetails[] details = SegmentStatusManager.readLoadMetadata((String)carbonTable.getMetadataPath());
                    boolean updated = false;
                    for (LoadMetadataDetails detail : details) {
                        if (SegmentStatus.STREAMING != detail.getSegmentStatus()) continue;
                        detail.setLoadEndTime(System.currentTimeMillis());
                        detail.setSegmentStatus(SegmentStatus.STREAMING_FINISH);
                        updated = true;
                    }
                    if (updated) {
                        SegmentStatusManager.writeLoadDetailsIntoFile((String)CarbonTablePath.getTableStatusFilePath((String)carbonTable.getTablePath()), (LoadMetadataDetails[])details);
                    }
                    break block8;
                }
                String msg = "Failed to acquire table status lock of " + carbonTable.getDatabaseName() + "." + carbonTable.getTableName();
                LOGGER.error(msg);
                throw new IOException(msg);
            }
            finally {
                if (statusLock.unlock()) {
                    LOGGER.info("Table unlocked successfully after table status updation" + carbonTable.getDatabaseName() + "." + carbonTable.getTableName());
                } else {
                    LOGGER.error("Unable to unlock Table lock for table " + carbonTable.getDatabaseName() + "." + carbonTable.getTableName() + " during table status updation");
                }
            }
        }
    }

    public static void appendBatchData(CarbonIterator<Object[]> inputIterators, TaskAttemptContext job, CarbonLoadModel carbonLoadModel) throws Exception {
        CarbonStreamRecordWriter writer = null;
        try {
            writer = new CarbonStreamRecordWriter(job, carbonLoadModel);
            StreamSegment.recoverFileIfRequired(writer.getSegmentDir(), writer.getFileName(), CarbonTablePath.getCarbonStreamIndexFileName());
            while (inputIterators.hasNext()) {
                writer.write(null, inputIterators.next());
            }
            inputIterators.close();
        }
        catch (Throwable ex) {
            if (writer != null) {
                LOGGER.error(ex, "Failed to append batch data to stream segment: " + writer.getSegmentDir());
                writer.setHasException(true);
            }
            throw ex;
        }
        finally {
            if (writer != null) {
                writer.close(job);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recoverSegmentIfRequired(String segmentDir) throws IOException {
        FileFactory.FileType fileType = FileFactory.getFileType((String)segmentDir);
        if (FileFactory.isFileExist((String)segmentDir, (FileFactory.FileType)fileType)) {
            String indexName = CarbonTablePath.getCarbonStreamIndexFileName();
            String indexPath = segmentDir + File.separator + indexName;
            CarbonFile index = FileFactory.getCarbonFile((String)indexPath, (FileFactory.FileType)fileType);
            CarbonFile[] files = StreamSegment.listDataFiles(segmentDir, fileType);
            if (index.exists()) {
                if (files.length > 0) {
                    CarbonIndexFileReader indexReader = new CarbonIndexFileReader();
                    try {
                        indexReader.openThriftReader(indexPath);
                        HashMap<String, Long> tableSizeMap = new HashMap<String, Long>();
                        while (indexReader.hasNext()) {
                            BlockIndex blockIndex = indexReader.readBlockIndexInfo();
                            tableSizeMap.put(blockIndex.getFile_name(), blockIndex.getFile_size());
                        }
                        for (CarbonFile file : files) {
                            Long size = (Long)tableSizeMap.get(file.getName());
                            if (null == size || size == 0L) {
                                file.delete();
                                continue;
                            }
                            if (size >= file.getSize()) continue;
                            FileFactory.truncateFile((String)file.getCanonicalPath(), (FileFactory.FileType)fileType, (long)size);
                        }
                    }
                    finally {
                        indexReader.closeThriftReader();
                    }
                }
            } else if (files.length > 0) {
                for (CarbonFile file : files) {
                    file.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recoverFileIfRequired(String segmentDir, String fileName, String indexName) throws IOException {
        FileFactory.FileType fileType = FileFactory.getFileType((String)segmentDir);
        String filePath = segmentDir + File.separator + fileName;
        CarbonFile file = FileFactory.getCarbonFile((String)filePath, (FileFactory.FileType)fileType);
        String indexPath = segmentDir + File.separator + indexName;
        CarbonFile index = FileFactory.getCarbonFile((String)indexPath, (FileFactory.FileType)fileType);
        if (file.exists() && index.exists()) {
            CarbonIndexFileReader indexReader = new CarbonIndexFileReader();
            try {
                indexReader.openThriftReader(indexPath);
                while (indexReader.hasNext()) {
                    BlockIndex blockIndex = indexReader.readBlockIndexInfo();
                    if (!blockIndex.getFile_name().equals(fileName)) continue;
                    if (blockIndex.getFile_size() == 0L) {
                        file.delete();
                        continue;
                    }
                    if (blockIndex.getFile_size() >= file.getSize()) continue;
                    FileFactory.truncateFile((String)filePath, (FileFactory.FileType)fileType, (long)blockIndex.getFile_size());
                }
            }
            finally {
                indexReader.closeThriftReader();
            }
        }
    }

    public static CarbonFile[] listDataFiles(String segmentDir, FileFactory.FileType fileType) {
        CarbonFile carbonDir = FileFactory.getCarbonFile((String)segmentDir, (FileFactory.FileType)fileType);
        if (carbonDir.exists()) {
            return carbonDir.listFiles(new CarbonFileFilter(){

                public boolean accept(CarbonFile file) {
                    return CarbonTablePath.isCarbonDataFile((String)file.getName());
                }
            });
        }
        return new CarbonFile[0];
    }

    public static void updateIndexFile(String segmentDir) throws IOException {
        FileFactory.FileType fileType = FileFactory.getFileType((String)segmentDir);
        String filePath = CarbonTablePath.getCarbonStreamIndexFilePath((String)segmentDir);
        String tempFilePath = filePath + ".write";
        CarbonIndexFileWriter writer = new CarbonIndexFileWriter();
        try {
            CarbonFile[] files;
            writer.openThriftWriter(tempFilePath);
            for (CarbonFile file : files = StreamSegment.listDataFiles(segmentDir, fileType)) {
                BlockIndex blockIndex = new BlockIndex();
                blockIndex.setFile_name(file.getName());
                blockIndex.setFile_size(file.getSize());
                blockIndex.setNum_rows(-1L);
                blockIndex.setOffset(-1L);
                blockIndex.setBlock_index(new BlockletIndex());
                writer.writeThrift((TBase)blockIndex);
            }
            writer.close();
            CarbonFile tempFile = FileFactory.getCarbonFile((String)tempFilePath, (FileFactory.FileType)fileType);
            if (!tempFile.renameForce(filePath)) {
                throw new IOException("temporary file renaming failed, src=" + tempFilePath + ", dest=" + filePath);
            }
        }
        catch (IOException ex) {
            try {
                writer.close();
            }
            catch (IOException t) {
                LOGGER.error((Throwable)t);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long size(String segmentDir) throws IOException {
        String indexPath;
        CarbonFile index;
        long size = 0L;
        FileFactory.FileType fileType = FileFactory.getFileType((String)segmentDir);
        if (FileFactory.isFileExist((String)segmentDir, (FileFactory.FileType)fileType) && (index = FileFactory.getCarbonFile((String)(indexPath = CarbonTablePath.getCarbonStreamIndexFilePath((String)segmentDir)), (FileFactory.FileType)fileType)).exists()) {
            CarbonIndexFileReader indexReader = new CarbonIndexFileReader();
            try {
                indexReader.openThriftReader(indexPath);
                while (indexReader.hasNext()) {
                    BlockIndex blockIndex = indexReader.readBlockIndexInfo();
                    size += blockIndex.getFile_size();
                }
            }
            finally {
                indexReader.closeThriftReader();
            }
        }
        return size;
    }
}

