/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.streaming;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.util.CarbonMetadataUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.format.FileHeader;
import org.apache.carbondata.processing.loading.BadRecordsLogger;
import org.apache.carbondata.processing.loading.BadRecordsLoggerProvider;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.DataLoadProcessBuilder;
import org.apache.carbondata.processing.loading.converter.DictionaryCardinalityFinder;
import org.apache.carbondata.processing.loading.converter.RowConverter;
import org.apache.carbondata.processing.loading.converter.impl.RowConverterImpl;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.loading.parser.RowParser;
import org.apache.carbondata.processing.loading.parser.impl.RowParserImpl;
import org.apache.carbondata.processing.store.writer.AbstractFactDataWriter;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;
import org.apache.carbondata.streaming.CarbonStreamOutputFormat;
import org.apache.carbondata.streaming.StreamBlockletWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.thrift.TBase;

public class CarbonStreamRecordWriter
extends RecordWriter<Void, Object> {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)CarbonStreamRecordWriter.class.getName());
    private Configuration hadoopConf;
    private CarbonLoadModel carbonLoadModel;
    private CarbonDataLoadConfiguration configuration;
    private CarbonTable carbonTable;
    private int maxRowNums;
    private int maxCacheSize;
    private RowParser rowParser;
    private BadRecordsLogger badRecordLogger;
    private RowConverter converter;
    private CarbonRow currentRow = new CarbonRow(null);
    private DataField[] dataFields;
    private BitSet nullBitSet;
    private boolean[] isNoDictionaryDimensionColumn;
    private int dimensionWithComplexCount;
    private int measureCount;
    private DataType[] measureDataTypes;
    private StreamBlockletWriter output = null;
    private String segmentDir;
    private String fileName;
    private DataOutputStream outputStream;
    private boolean isFirstRow = true;
    private boolean hasException = false;

    CarbonStreamRecordWriter(TaskAttemptContext job) throws IOException {
        this.initialize(job);
    }

    public CarbonStreamRecordWriter(TaskAttemptContext job, CarbonLoadModel carbonLoadModel) throws IOException {
        this.carbonLoadModel = carbonLoadModel;
        this.initialize(job);
    }

    private void initialize(TaskAttemptContext job) throws IOException {
        this.hadoopConf = job.getConfiguration();
        if (this.carbonLoadModel == null) {
            this.carbonLoadModel = CarbonStreamOutputFormat.getCarbonLoadModel(this.hadoopConf);
            if (this.carbonLoadModel == null) {
                throw new IOException("CarbonStreamRecordWriter require configuration: mapreduce.output.carbon.load.model");
            }
        }
        String segmentId = CarbonStreamOutputFormat.getSegmentId(this.hadoopConf);
        this.carbonLoadModel.setSegmentId(segmentId);
        this.carbonTable = this.carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable();
        long taskNo = TaskID.forName((String)this.hadoopConf.get("mapred.tip.id")).getId();
        this.carbonLoadModel.setTaskNo("" + taskNo);
        this.configuration = DataLoadProcessBuilder.createConfiguration((CarbonLoadModel)this.carbonLoadModel);
        this.maxRowNums = this.hadoopConf.getInt("carbon.stream.blocklet.row.nums", 32000) - 1;
        this.maxCacheSize = this.hadoopConf.getInt("carbon.stream.cache.size", 0x2000000);
        this.segmentDir = CarbonTablePath.getSegmentPath((String)this.carbonTable.getAbsoluteTableIdentifier().getTablePath(), (String)segmentId);
        this.fileName = CarbonTablePath.getCarbonDataFileName((Integer)0, (Long)taskNo, (int)0, (int)0, (String)"0");
    }

    private void initializeAtFirstRow() throws IOException, InterruptedException {
        this.isNoDictionaryDimensionColumn = CarbonDataProcessorUtil.getNoDictionaryMapping((DataField[])this.configuration.getDataFields());
        this.dimensionWithComplexCount = this.configuration.getDimensionCount();
        this.measureCount = this.configuration.getMeasureCount();
        this.dataFields = this.configuration.getDataFields();
        this.measureDataTypes = new DataType[this.measureCount];
        for (int i = 0; i < this.measureCount; ++i) {
            this.measureDataTypes[i] = this.dataFields[this.dimensionWithComplexCount + i].getColumn().getDataType();
        }
        this.rowParser = new RowParserImpl(this.dataFields, this.configuration);
        this.badRecordLogger = BadRecordsLoggerProvider.createBadRecordLogger((CarbonDataLoadConfiguration)this.configuration);
        this.converter = new RowConverterImpl(this.configuration.getDataFields(), this.configuration, this.badRecordLogger);
        this.configuration.setCardinalityFinder((DictionaryCardinalityFinder)this.converter);
        this.converter.initialize();
        this.nullBitSet = new BitSet(this.dataFields.length);
        int rowBufferSize = this.hadoopConf.getInt("carbon.stream.row.buffer.size", 1024);
        this.output = new StreamBlockletWriter(this.maxCacheSize, this.maxRowNums, rowBufferSize);
        String filePath = this.segmentDir + File.separator + this.fileName;
        FileFactory.FileType fileType = FileFactory.getFileType((String)filePath);
        CarbonFile carbonFile = FileFactory.getCarbonFile((String)filePath, (FileFactory.FileType)fileType);
        if (carbonFile.exists()) {
            this.outputStream = FileFactory.getDataOutputStreamUsingAppend((String)filePath, (FileFactory.FileType)fileType);
        } else {
            this.outputStream = FileFactory.getDataOutputStream((String)filePath, (FileFactory.FileType)fileType);
            this.writeFileHeader();
        }
        this.isFirstRow = false;
    }

    public void write(Void key, Object value) throws IOException, InterruptedException {
        if (this.isFirstRow) {
            this.initializeAtFirstRow();
        }
        this.nullBitSet.clear();
        Object[] rowData = (Object[])value;
        this.currentRow.setRawData(rowData);
        this.currentRow.setData(this.rowParser.parseRow(rowData));
        CarbonRow updatedCarbonRow = this.converter.convert(this.currentRow);
        if (updatedCarbonRow == null) {
            this.output.skipRow();
            this.currentRow.clearData();
        } else {
            byte[] col;
            Object columnValue;
            int dimCount;
            for (int i = 0; i < this.dataFields.length; ++i) {
                if (null != this.currentRow.getObject(i)) continue;
                this.nullBitSet.set(i);
            }
            this.output.nextRow();
            byte[] b = this.nullBitSet.toByteArray();
            this.output.writeShort(b.length);
            if (b.length > 0) {
                this.output.writeBytes(b);
            }
            for (dimCount = 0; dimCount < this.isNoDictionaryDimensionColumn.length; ++dimCount) {
                columnValue = this.currentRow.getObject(dimCount);
                if (null == columnValue) continue;
                if (this.isNoDictionaryDimensionColumn[dimCount]) {
                    col = (byte[])columnValue;
                    this.output.writeShort(col.length);
                    this.output.writeBytes(col);
                    continue;
                }
                this.output.writeInt((Integer)columnValue);
            }
            while (dimCount < this.dimensionWithComplexCount) {
                columnValue = this.currentRow.getObject(dimCount);
                if (null != columnValue) {
                    col = (byte[])columnValue;
                    this.output.writeShort(col.length);
                    this.output.writeBytes(col);
                }
                ++dimCount;
            }
            for (int msrCount = 0; msrCount < this.measureCount; ++msrCount) {
                columnValue = this.currentRow.getObject(dimCount + msrCount);
                if (null == columnValue) continue;
                DataType dataType = this.measureDataTypes[msrCount];
                if (dataType == DataTypes.BOOLEAN) {
                    this.output.writeBoolean((Boolean)columnValue);
                    continue;
                }
                if (dataType == DataTypes.SHORT) {
                    this.output.writeShort(((Short)columnValue).shortValue());
                    continue;
                }
                if (dataType == DataTypes.INT) {
                    this.output.writeInt((Integer)columnValue);
                    continue;
                }
                if (dataType == DataTypes.LONG) {
                    this.output.writeLong((Long)columnValue);
                    continue;
                }
                if (dataType == DataTypes.DOUBLE) {
                    this.output.writeDouble((Double)columnValue);
                    continue;
                }
                if (DataTypes.isDecimal((DataType)dataType)) {
                    BigDecimal val = (BigDecimal)columnValue;
                    byte[] bigDecimalInBytes = DataTypeUtil.bigDecimalToByte((BigDecimal)val);
                    this.output.writeShort(bigDecimalInBytes.length);
                    this.output.writeBytes(bigDecimalInBytes);
                    continue;
                }
                String msg = "unsupported data type:" + this.dataFields[dimCount + msrCount].getColumn().getDataType().getName();
                LOGGER.error(msg);
                throw new IOException(msg);
            }
        }
        if (this.output.isFull()) {
            this.appendBlockletToDataFile();
        }
    }

    private void writeFileHeader() throws IOException {
        List wrapperColumnSchemaList = CarbonUtil.getColumnSchemaList((List)this.carbonTable.getDimensionByTableName(this.carbonTable.getTableName()), (List)this.carbonTable.getMeasureByTableName(this.carbonTable.getTableName()));
        int[] dimLensWithComplex = new int[wrapperColumnSchemaList.size()];
        for (int i = 0; i < dimLensWithComplex.length; ++i) {
            dimLensWithComplex[i] = Integer.MAX_VALUE;
        }
        int[] dictionaryColumnCardinality = CarbonUtil.getFormattedCardinality((int[])dimLensWithComplex, (List)wrapperColumnSchemaList);
        ArrayList cardinality = new ArrayList();
        List columnSchemaList = AbstractFactDataWriter.getColumnSchemaListAndCardinality(cardinality, (int[])dictionaryColumnCardinality, (List)wrapperColumnSchemaList);
        FileHeader fileHeader = CarbonMetadataUtil.getFileHeader((boolean)true, (List)columnSchemaList, (long)System.currentTimeMillis());
        fileHeader.setIs_footer_present(false);
        fileHeader.setIs_splitable(true);
        fileHeader.setSync_marker(CarbonStreamOutputFormat.CARBON_SYNC_MARKER);
        this.outputStream.write(CarbonUtil.getByteArray((TBase)fileHeader));
    }

    private void appendBlockletToDataFile() throws IOException {
        if (this.output.getRowIndex() == -1) {
            return;
        }
        this.output.apppendBlocklet(this.outputStream);
        this.outputStream.flush();
        this.output.reset();
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        block6: {
            try {
                if (this.hasException || this.isFirstRow) break block6;
                this.appendBlockletToDataFile();
                this.converter.finish();
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams((Closeable[])new Closeable[]{this.outputStream});
                if (this.output != null) {
                    this.output.close();
                }
                if (this.badRecordLogger != null) {
                    this.badRecordLogger.closeStreams();
                }
                throw throwable;
            }
        }
        CarbonUtil.closeStreams((Closeable[])new Closeable[]{this.outputStream});
        if (this.output != null) {
            this.output.close();
        }
        if (this.badRecordLogger != null) {
            this.badRecordLogger.closeStreams();
        }
    }

    public String getSegmentDir() {
        return this.segmentDir;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setHasException(boolean hasException) {
        this.hasException = hasException;
    }
}

