/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import org.apache.carbondata.core.cache.Cache;
import org.apache.carbondata.core.cache.CacheProvider;
import org.apache.carbondata.core.cache.CacheType;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.cache.dictionary.DictionaryColumnUniqueIdentifier;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.reader.CarbonHeaderReader;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.GenericQueryType;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.intf.RowImpl;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.format.BlockletHeader;
import org.apache.carbondata.format.FileHeader;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.CarbonMultiBlockSplit;
import org.apache.carbondata.hadoop.InputMetricsStats;
import org.apache.carbondata.hadoop.api.CarbonTableInputFormat;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;
import org.apache.carbondata.streaming.CarbonStreamInputFormat;
import org.apache.carbondata.streaming.StreamBlockletReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.execution.vectorized.ColumnVector;
import org.apache.spark.sql.execution.vectorized.ColumnarBatch;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public class CarbonStreamRecordReader
extends RecordReader<Void, Object> {
    private boolean isVectorReader;
    private CarbonTable carbonTable;
    private CarbonColumn[] storageColumns;
    private boolean[] isRequired;
    private org.apache.carbondata.core.metadata.datatype.DataType[] measureDataTypes;
    private int dimensionCount;
    private int measureCount;
    private FileSplit fileSplit;
    private Configuration hadoopConf;
    private StreamBlockletReader input;
    private boolean isFirstRow = true;
    private QueryModel model;
    private BitSet allNonNull;
    private boolean[] isNoDictColumn;
    private DirectDictionaryGenerator[] directDictionaryGenerators;
    private CacheProvider cacheProvider;
    private Cache<DictionaryColumnUniqueIdentifier, Dictionary> cache;
    private GenericQueryType[] queryTypes;
    private StructType outputSchema;
    private ColumnarBatch columnarBatch;
    private boolean isFinished = false;
    private FilterExecuter filter;
    private boolean[] isFilterRequired;
    private Object[] filterValues;
    private RowIntf filterRow;
    private int[] filterMap;
    private CarbonColumn[] projection;
    private boolean[] isProjectionRequired;
    private int[] projectionMap;
    private Object[] outputValues;
    private InternalRow outputRow;
    private boolean skipScanData;
    private boolean useRawRow = false;
    private InputMetricsStats inputMetricsStats;

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        int i;
        this.fileSplit = split instanceof CarbonInputSplit ? (CarbonInputSplit)split : (split instanceof CarbonMultiBlockSplit ? (FileSplit)((CarbonMultiBlockSplit)split).getAllSplits().get(0) : (FileSplit)split);
        this.hadoopConf = context.getConfiguration();
        if (this.model == null) {
            CarbonTableInputFormat format = new CarbonTableInputFormat();
            this.model = format.createQueryModel(split, context);
        }
        this.carbonTable = this.model.getTable();
        List dimensions = this.carbonTable.getDimensionByTableName(this.carbonTable.getTableName());
        this.dimensionCount = dimensions.size();
        List measures = this.carbonTable.getMeasureByTableName(this.carbonTable.getTableName());
        this.measureCount = measures.size();
        List carbonColumnList = this.carbonTable.getStreamStorageOrderColumn(this.carbonTable.getTableName());
        this.storageColumns = carbonColumnList.toArray(new CarbonColumn[carbonColumnList.size()]);
        this.isNoDictColumn = CarbonDataProcessorUtil.getNoDictionaryMapping((CarbonColumn[])this.storageColumns);
        this.directDictionaryGenerators = new DirectDictionaryGenerator[this.storageColumns.length];
        for (i = 0; i < this.storageColumns.length; ++i) {
            if (!this.storageColumns[i].hasEncoding(Encoding.DIRECT_DICTIONARY)) continue;
            this.directDictionaryGenerators[i] = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator((org.apache.carbondata.core.metadata.datatype.DataType)this.storageColumns[i].getDataType());
        }
        this.measureDataTypes = new org.apache.carbondata.core.metadata.datatype.DataType[this.measureCount];
        for (i = 0; i < this.measureCount; ++i) {
            this.measureDataTypes[i] = this.storageColumns[this.dimensionCount + i].getDataType();
        }
        this.allNonNull = new BitSet(this.storageColumns.length);
        this.projection = this.model.getProjectionColumns();
        this.isRequired = new boolean[this.storageColumns.length];
        boolean[] isFiltlerDimensions = this.model.getIsFilterDimensions();
        boolean[] isFiltlerMeasures = this.model.getIsFilterMeasures();
        this.isFilterRequired = new boolean[this.storageColumns.length];
        this.filterMap = new int[this.storageColumns.length];
        for (int i2 = 0; i2 < this.storageColumns.length; ++i2) {
            if (this.storageColumns[i2].isDimension().booleanValue()) {
                if (!isFiltlerDimensions[this.storageColumns[i2].getOrdinal()]) continue;
                this.isRequired[i2] = true;
                this.isFilterRequired[i2] = true;
                this.filterMap[i2] = this.storageColumns[i2].getOrdinal();
                continue;
            }
            if (!isFiltlerMeasures[this.storageColumns[i2].getOrdinal()]) continue;
            this.isRequired[i2] = true;
            this.isFilterRequired[i2] = true;
            this.filterMap[i2] = this.carbonTable.getDimensionOrdinalMax() + this.storageColumns[i2].getOrdinal();
        }
        this.isProjectionRequired = new boolean[this.storageColumns.length];
        this.projectionMap = new int[this.storageColumns.length];
        block3: for (int j = 0; j < this.projection.length; ++j) {
            for (int i3 = 0; i3 < this.storageColumns.length; ++i3) {
                if (!this.storageColumns[i3].getColName().equals(this.projection[j].getColName())) continue;
                this.isRequired[i3] = true;
                this.isProjectionRequired[i3] = true;
                this.projectionMap[i3] = j;
                continue block3;
            }
        }
        if (null != this.model.getFilterExpressionResolverTree()) {
            this.initializeFilter();
        } else if (this.projection.length == 0) {
            this.skipScanData = true;
        }
    }

    private void initializeFilter() {
        List wrapperColumnSchemaList = CarbonUtil.getColumnSchemaList((List)this.carbonTable.getDimensionByTableName(this.carbonTable.getTableName()), (List)this.carbonTable.getMeasureByTableName(this.carbonTable.getTableName()));
        int[] dimLensWithComplex = new int[wrapperColumnSchemaList.size()];
        for (int i = 0; i < dimLensWithComplex.length; ++i) {
            dimLensWithComplex[i] = Integer.MAX_VALUE;
        }
        int[] dictionaryColumnCardinality = CarbonUtil.getFormattedCardinality((int[])dimLensWithComplex, (List)wrapperColumnSchemaList);
        SegmentProperties segmentProperties = new SegmentProperties(wrapperColumnSchemaList, dictionaryColumnCardinality);
        HashMap complexDimensionInfoMap = new HashMap();
        FilterResolverIntf resolverIntf = this.model.getFilterExpressionResolverTree();
        this.filter = FilterUtil.getFilterExecuterTree((FilterResolverIntf)resolverIntf, (SegmentProperties)segmentProperties, complexDimensionInfoMap);
        FilterUtil.updateIndexOfColumnExpression((Expression)resolverIntf.getFilterExpression(), (int)this.carbonTable.getDimensionOrdinalMax());
    }

    public void setQueryModel(QueryModel model) {
        this.model = model;
    }

    private byte[] getSyncMarker(String filePath) throws IOException {
        CarbonHeaderReader headerReader = new CarbonHeaderReader(filePath);
        FileHeader header = headerReader.readHeader();
        return header.getSync_marker();
    }

    public void setUseRawRow(boolean useRawRow) {
        this.useRawRow = useRawRow;
    }

    private void initializeAtFirstRow() throws IOException {
        this.filterValues = new Object[this.carbonTable.getDimensionOrdinalMax() + this.measureCount];
        this.filterRow = new RowImpl();
        this.filterRow.setValues(this.filterValues);
        this.outputValues = new Object[this.projection.length];
        this.outputRow = new GenericInternalRow(this.outputValues);
        Path file = this.fileSplit.getPath();
        byte[] syncMarker = this.getSyncMarker(file.toString());
        FileSystem fs = file.getFileSystem(this.hadoopConf);
        int bufferSize = Integer.parseInt(this.hadoopConf.get("carbon.stream.read.buffer.size", "65536"));
        FSDataInputStream fileIn = fs.open(file, bufferSize);
        fileIn.seek(this.fileSplit.getStart());
        this.input = new StreamBlockletReader(syncMarker, (InputStream)fileIn, this.fileSplit.getLength(), this.fileSplit.getStart() == 0L);
        this.cacheProvider = CacheProvider.getInstance();
        this.cache = this.cacheProvider.createCache(CacheType.FORWARD_DICTIONARY);
        this.queryTypes = CarbonStreamInputFormat.getComplexDimensions(this.carbonTable, this.storageColumns, this.cache);
        this.outputSchema = new StructType((StructField[])DataTypeUtil.getDataTypeConverter().convertCarbonSchemaToSparkSchema(this.projection));
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.isFirstRow) {
            this.isFirstRow = false;
            this.initializeAtFirstRow();
        }
        if (this.isFinished) {
            return false;
        }
        if (this.isVectorReader) {
            return this.nextColumnarBatch();
        }
        return this.nextRow();
    }

    private boolean nextColumnarBatch() throws IOException {
        boolean hasNext;
        boolean scanMore = false;
        do {
            if (hasNext = this.input.nextBlocklet()) {
                BlockletHeader header = this.input.readBlockletHeader();
                if (this.isScanRequired(header)) {
                    scanMore = !this.scanBlockletAndFillVector(header);
                    continue;
                }
                this.input.skipBlockletData(true);
                scanMore = true;
                continue;
            }
            this.isFinished = true;
            scanMore = false;
        } while (scanMore);
        return hasNext;
    }

    private boolean nextRow() throws IOException {
        try {
            boolean hasNext;
            boolean scanMore = false;
            do {
                if (hasNext = this.input.hasNext()) {
                    if (this.skipScanData) {
                        this.input.nextRow();
                        scanMore = false;
                        continue;
                    }
                    if (this.useRawRow) {
                        this.readRawRowFromStream();
                    } else {
                        this.readRowFromStream();
                    }
                    if (null != this.filter) {
                        scanMore = !this.filter.applyFilter(this.filterRow, this.carbonTable.getDimensionOrdinalMax());
                        continue;
                    }
                    scanMore = false;
                    continue;
                }
                if (this.input.nextBlocklet()) {
                    BlockletHeader header = this.input.readBlockletHeader();
                    if (this.isScanRequired(header)) {
                        if (this.skipScanData) {
                            this.input.skipBlockletData(false);
                        } else {
                            this.input.readBlockletData(header);
                        }
                    } else {
                        this.input.skipBlockletData(true);
                    }
                    scanMore = true;
                    continue;
                }
                this.isFinished = true;
                scanMore = false;
            } while (scanMore);
            return hasNext;
        }
        catch (FilterUnsupportedException e) {
            throw new IOException("Failed to filter row in detail reader", e);
        }
    }

    public Void getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public Object getCurrentValue() throws IOException, InterruptedException {
        if (this.isVectorReader) {
            int value = this.columnarBatch.numValidRows();
            if (this.inputMetricsStats != null) {
                this.inputMetricsStats.incrementRecordRead(Long.valueOf(value));
            }
            return this.columnarBatch;
        }
        if (this.inputMetricsStats != null) {
            this.inputMetricsStats.incrementRecordRead(Long.valueOf(1L));
        }
        return this.outputRow;
    }

    private boolean isScanRequired(BlockletHeader header) {
        return true;
    }

    private boolean scanBlockletAndFillVector(BlockletHeader header) throws IOException {
        if (this.skipScanData) {
            int rowNums = header.getBlocklet_info().getNum_rows();
            this.columnarBatch = ColumnarBatch.allocate((StructType)this.outputSchema, (MemoryMode)MemoryMode.OFF_HEAP, (int)rowNums);
            this.columnarBatch.setNumRows(rowNums);
            this.input.skipBlockletData(true);
            return rowNums > 0;
        }
        this.input.readBlockletData(header);
        this.columnarBatch = ColumnarBatch.allocate((StructType)this.outputSchema, (MemoryMode)MemoryMode.OFF_HEAP, (int)this.input.getRowNums());
        int rowNum = 0;
        if (null == this.filter) {
            while (this.input.hasNext()) {
                this.readRowFromStream();
                this.putRowToColumnBatch(rowNum++);
            }
        } else {
            try {
                while (this.input.hasNext()) {
                    this.readRowFromStream();
                    if (!this.filter.applyFilter(this.filterRow, this.carbonTable.getDimensionOrdinalMax())) continue;
                    this.putRowToColumnBatch(rowNum++);
                }
            }
            catch (FilterUnsupportedException e) {
                throw new IOException("Failed to filter row in vector reader", e);
            }
        }
        this.columnarBatch.setNumRows(rowNum);
        return rowNum > 0;
    }

    private void readRowFromStream() {
        byte[] b;
        short v;
        int colCount;
        this.input.nextRow();
        short nullLen = this.input.readShort();
        BitSet nullBitSet = this.allNonNull;
        if (nullLen > 0) {
            nullBitSet = BitSet.valueOf(this.input.readBytes(nullLen));
        }
        for (colCount = 0; colCount < this.isNoDictColumn.length; ++colCount) {
            if (nullBitSet.get(colCount)) {
                if (this.isFilterRequired[colCount]) {
                    this.filterValues[this.filterMap[colCount]] = CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY;
                }
                if (!this.isProjectionRequired[colCount]) continue;
                this.outputValues[this.projectionMap[colCount]] = null;
                continue;
            }
            if (this.isNoDictColumn[colCount]) {
                v = this.input.readShort();
                if (this.isRequired[colCount]) {
                    b = this.input.readBytes(v);
                    if (this.isFilterRequired[colCount]) {
                        this.filterValues[this.filterMap[colCount]] = b;
                    }
                    if (!this.isProjectionRequired[colCount]) continue;
                    this.outputValues[this.projectionMap[colCount]] = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn((byte[])b, (org.apache.carbondata.core.metadata.datatype.DataType)this.storageColumns[colCount].getDataType());
                    continue;
                }
                this.input.skipBytes(v);
                continue;
            }
            if (null != this.directDictionaryGenerators[colCount]) {
                if (this.isRequired[colCount]) {
                    if (this.isFilterRequired[colCount]) {
                        this.filterValues[this.filterMap[colCount]] = this.input.copy(4);
                    }
                    if (this.isProjectionRequired[colCount]) {
                        this.outputValues[this.projectionMap[colCount]] = this.directDictionaryGenerators[colCount].getValueFromSurrogate(this.input.readInt());
                        continue;
                    }
                    this.input.skipBytes(4);
                    continue;
                }
                this.input.skipBytes(4);
                continue;
            }
            if (this.isRequired[colCount]) {
                if (this.isFilterRequired[colCount]) {
                    this.filterValues[this.filterMap[colCount]] = this.input.copy(4);
                }
                if (this.isProjectionRequired[colCount]) {
                    this.outputValues[this.projectionMap[colCount]] = this.input.readInt();
                    continue;
                }
                this.input.skipBytes(4);
                continue;
            }
            this.input.skipBytes(4);
        }
        while (colCount < this.dimensionCount) {
            if (nullBitSet.get(colCount)) {
                if (this.isFilterRequired[colCount]) {
                    this.filterValues[this.filterMap[colCount]] = null;
                }
                if (this.isProjectionRequired[colCount]) {
                    this.outputValues[this.projectionMap[colCount]] = null;
                }
            } else {
                v = this.input.readShort();
                if (this.isRequired[colCount]) {
                    b = this.input.readBytes(v);
                    if (this.isFilterRequired[colCount]) {
                        this.filterValues[this.filterMap[colCount]] = b;
                    }
                    if (this.isProjectionRequired[colCount]) {
                        this.outputValues[this.projectionMap[colCount]] = this.queryTypes[colCount].getDataBasedOnDataType(ByteBuffer.wrap(b));
                    }
                } else {
                    this.input.skipBytes(v);
                }
            }
            ++colCount;
        }
        int msrCount = 0;
        while (msrCount < this.measureCount) {
            if (nullBitSet.get(colCount)) {
                if (this.isFilterRequired[colCount]) {
                    this.filterValues[this.filterMap[colCount]] = null;
                }
                if (this.isProjectionRequired[colCount]) {
                    this.outputValues[this.projectionMap[colCount]] = null;
                }
            } else {
                org.apache.carbondata.core.metadata.datatype.DataType dataType = this.measureDataTypes[msrCount];
                if (dataType == org.apache.carbondata.core.metadata.datatype.DataTypes.BOOLEAN) {
                    if (this.isRequired[colCount]) {
                        boolean v2 = this.input.readBoolean();
                        if (this.isFilterRequired[colCount]) {
                            this.filterValues[this.filterMap[colCount]] = v2;
                        }
                        if (this.isProjectionRequired[colCount]) {
                            this.outputValues[this.projectionMap[colCount]] = v2;
                        }
                    } else {
                        this.input.skipBytes(1);
                    }
                } else if (dataType == org.apache.carbondata.core.metadata.datatype.DataTypes.SHORT) {
                    if (this.isRequired[colCount]) {
                        short v3 = this.input.readShort();
                        if (this.isFilterRequired[colCount]) {
                            this.filterValues[this.filterMap[colCount]] = v3;
                        }
                        if (this.isProjectionRequired[colCount]) {
                            this.outputValues[this.projectionMap[colCount]] = v3;
                        }
                    } else {
                        this.input.skipBytes(2);
                    }
                } else if (dataType == org.apache.carbondata.core.metadata.datatype.DataTypes.INT) {
                    if (this.isRequired[colCount]) {
                        int v4 = this.input.readInt();
                        if (this.isFilterRequired[colCount]) {
                            this.filterValues[this.filterMap[colCount]] = v4;
                        }
                        if (this.isProjectionRequired[colCount]) {
                            this.outputValues[this.projectionMap[colCount]] = v4;
                        }
                    } else {
                        this.input.skipBytes(4);
                    }
                } else if (dataType == org.apache.carbondata.core.metadata.datatype.DataTypes.LONG) {
                    if (this.isRequired[colCount]) {
                        long v5 = this.input.readLong();
                        if (this.isFilterRequired[colCount]) {
                            this.filterValues[this.filterMap[colCount]] = v5;
                        }
                        if (this.isProjectionRequired[colCount]) {
                            this.outputValues[this.projectionMap[colCount]] = v5;
                        }
                    } else {
                        this.input.skipBytes(8);
                    }
                } else if (dataType == org.apache.carbondata.core.metadata.datatype.DataTypes.DOUBLE) {
                    if (this.isRequired[colCount]) {
                        double v6 = this.input.readDouble();
                        if (this.isFilterRequired[colCount]) {
                            this.filterValues[this.filterMap[colCount]] = v6;
                        }
                        if (this.isProjectionRequired[colCount]) {
                            this.outputValues[this.projectionMap[colCount]] = v6;
                        }
                    } else {
                        this.input.skipBytes(8);
                    }
                } else if (org.apache.carbondata.core.metadata.datatype.DataTypes.isDecimal((org.apache.carbondata.core.metadata.datatype.DataType)dataType)) {
                    short len = this.input.readShort();
                    if (this.isRequired[colCount]) {
                        BigDecimal v7 = DataTypeUtil.byteToBigDecimal((byte[])this.input.readBytes(len));
                        if (this.isFilterRequired[colCount]) {
                            this.filterValues[this.filterMap[colCount]] = v7;
                        }
                        if (this.isProjectionRequired[colCount]) {
                            this.outputValues[this.projectionMap[colCount]] = DataTypeUtil.getDataTypeConverter().convertFromBigDecimalToDecimal((Object)v7);
                        }
                    } else {
                        this.input.skipBytes(len);
                    }
                }
            }
            ++msrCount;
            ++colCount;
        }
    }

    private void readRawRowFromStream() {
        short v;
        int colCount;
        this.input.nextRow();
        short nullLen = this.input.readShort();
        BitSet nullBitSet = this.allNonNull;
        if (nullLen > 0) {
            nullBitSet = BitSet.valueOf(this.input.readBytes(nullLen));
        }
        for (colCount = 0; colCount < this.isNoDictColumn.length; ++colCount) {
            if (nullBitSet.get(colCount)) {
                this.outputValues[colCount] = CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY;
                continue;
            }
            if (this.isNoDictColumn[colCount]) {
                v = this.input.readShort();
                this.outputValues[colCount] = this.input.readBytes(v);
                continue;
            }
            this.outputValues[colCount] = this.input.readInt();
        }
        while (colCount < this.dimensionCount) {
            if (nullBitSet.get(colCount)) {
                this.outputValues[colCount] = null;
            } else {
                v = this.input.readShort();
                this.outputValues[colCount] = this.input.readBytes(v);
            }
            ++colCount;
        }
        int msrCount = 0;
        while (msrCount < this.measureCount) {
            if (nullBitSet.get(colCount)) {
                this.outputValues[colCount] = null;
            } else {
                org.apache.carbondata.core.metadata.datatype.DataType dataType = this.measureDataTypes[msrCount];
                if (dataType == org.apache.carbondata.core.metadata.datatype.DataTypes.BOOLEAN) {
                    this.outputValues[colCount] = this.input.readBoolean();
                } else if (dataType == org.apache.carbondata.core.metadata.datatype.DataTypes.SHORT) {
                    this.outputValues[colCount] = this.input.readShort();
                } else if (dataType == org.apache.carbondata.core.metadata.datatype.DataTypes.INT) {
                    this.outputValues[colCount] = this.input.readInt();
                } else if (dataType == org.apache.carbondata.core.metadata.datatype.DataTypes.LONG) {
                    this.outputValues[colCount] = this.input.readLong();
                } else if (dataType == org.apache.carbondata.core.metadata.datatype.DataTypes.DOUBLE) {
                    this.outputValues[colCount] = this.input.readDouble();
                } else if (org.apache.carbondata.core.metadata.datatype.DataTypes.isDecimal((org.apache.carbondata.core.metadata.datatype.DataType)dataType)) {
                    short len = this.input.readShort();
                    this.outputValues[colCount] = DataTypeUtil.byteToBigDecimal((byte[])this.input.readBytes(len));
                }
            }
            ++msrCount;
            ++colCount;
        }
    }

    private void putRowToColumnBatch(int rowId) {
        for (int i = 0; i < this.projection.length; ++i) {
            Object value = this.outputValues[i];
            ColumnVector col = this.columnarBatch.column(i);
            DataType t = col.dataType();
            if (null == value) {
                col.putNull(rowId);
                continue;
            }
            if (t == DataTypes.BooleanType) {
                col.putBoolean(rowId, ((Boolean)value).booleanValue());
                continue;
            }
            if (t == DataTypes.ByteType) {
                col.putByte(rowId, ((Byte)value).byteValue());
                continue;
            }
            if (t == DataTypes.ShortType) {
                col.putShort(rowId, ((Short)value).shortValue());
                continue;
            }
            if (t == DataTypes.IntegerType) {
                col.putInt(rowId, ((Integer)value).intValue());
                continue;
            }
            if (t == DataTypes.LongType) {
                col.putLong(rowId, ((Long)value).longValue());
                continue;
            }
            if (t == DataTypes.FloatType) {
                col.putFloat(rowId, ((Float)value).floatValue());
                continue;
            }
            if (t == DataTypes.DoubleType) {
                col.putDouble(rowId, ((Double)value).doubleValue());
                continue;
            }
            if (t == DataTypes.StringType) {
                UTF8String v = (UTF8String)value;
                col.putByteArray(rowId, v.getBytes());
                continue;
            }
            if (t instanceof DecimalType) {
                DecimalType dt = (DecimalType)t;
                Decimal d = Decimal.fromDecimal((Object)value);
                if (dt.precision() <= Decimal.MAX_INT_DIGITS()) {
                    col.putInt(rowId, (int)d.toUnscaledLong());
                    continue;
                }
                if (dt.precision() <= Decimal.MAX_LONG_DIGITS()) {
                    col.putLong(rowId, d.toUnscaledLong());
                    continue;
                }
                BigInteger integer = d.toJavaBigDecimal().unscaledValue();
                byte[] bytes = integer.toByteArray();
                col.putByteArray(rowId, bytes, 0, bytes.length);
                continue;
            }
            if (t instanceof CalendarIntervalType) {
                CalendarInterval c = (CalendarInterval)value;
                col.getChildColumn(0).putInt(rowId, c.months);
                col.getChildColumn(1).putLong(rowId, c.microseconds);
                continue;
            }
            if (t instanceof DateType) {
                col.putInt(rowId, ((Integer)value).intValue());
                continue;
            }
            if (!(t instanceof TimestampType)) continue;
            col.putLong(rowId, ((Long)value).longValue());
        }
    }

    public float getProgress() throws IOException, InterruptedException {
        return 0.0f;
    }

    public void setVectorReader(boolean isVectorReader) {
        this.isVectorReader = isVectorReader;
    }

    public void setInputMetricsStats(InputMetricsStats inputMetricsStats) {
        this.inputMetricsStats = inputMetricsStats;
    }

    public void close() throws IOException {
        if (null != this.input) {
            this.input.close();
        }
        if (null != this.columnarBatch) {
            this.columnarBatch.close();
        }
    }
}

