/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.store;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.metadata.schema.SchemaReader;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.format.TableInfo;
import org.apache.carbondata.store.CarbonStore;

@InterfaceAudience.Internal
abstract class MetaCachedCarbonStore
implements CarbonStore {
    private Map<String, CarbonTable> cache = new HashMap<String, CarbonTable>();

    MetaCachedCarbonStore() {
    }

    CarbonTable getTable(String path) throws IOException {
        org.apache.carbondata.core.metadata.schema.table.TableInfo tableInfo;
        if (this.cache.containsKey(path)) {
            return this.cache.get(path);
        }
        String schemaPath = CarbonTablePath.getSchemaFilePath((String)path);
        if (!FileFactory.isFileExist((String)schemaPath, (FileFactory.FileType)FileFactory.getFileType((String)schemaPath))) {
            tableInfo = SchemaReader.inferSchema((AbsoluteTableIdentifier)AbsoluteTableIdentifier.from((String)path), (boolean)false);
        } else {
            TableInfo tableInfoFormat = CarbonUtil.readSchemaFile((String)CarbonTablePath.getSchemaFilePath((String)path));
            ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
            tableInfo = schemaConverter.fromExternalToWrapperTableInfo(tableInfoFormat, "", "", "");
            tableInfo.setTablePath(path);
        }
        CarbonTable table = CarbonTable.buildFromTableInfo((org.apache.carbondata.core.metadata.schema.table.TableInfo)tableInfo);
        this.cache.put(path, table);
        return table;
    }

    @Override
    public void close() throws IOException {
        this.cache.clear();
    }
}

