/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file.arrow;

import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.carbondata.sdk.file.arrow.ArrowFieldWriter;

class StructWriter
extends ArrowFieldWriter {
    private StructVector structVector;
    private ArrowFieldWriter[] children;

    public StructWriter(StructVector structVector, ArrowFieldWriter[] children) {
        super((ValueVector)structVector);
        this.structVector = structVector;
        this.children = children;
    }

    @Override
    public void setNull() {
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].setNull();
            ++this.children[i].count;
        }
        this.structVector.setNull(this.count);
    }

    @Override
    public void setValue(Object data, int ordinal) {
        Object[] struct = (Object[])data;
        for (int i = 0; i < struct.length; ++i) {
            this.children[i].write(struct[i], i);
        }
        this.structVector.setIndexDefined(this.count);
    }

    @Override
    public void finish() {
        super.finish();
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].finish();
        }
    }

    @Override
    public void reset() {
        super.reset();
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].reset();
        }
    }
}

