/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file.arrow;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.carbondata.sdk.file.arrow.ArrowFieldWriter;

class StringWriter
extends ArrowFieldWriter {
    private VarCharVector varCharVector;

    public StringWriter(VarCharVector varCharVector) {
        super((ValueVector)varCharVector);
        this.varCharVector = varCharVector;
    }

    @Override
    public void setNull() {
        this.varCharVector.setNull(this.count);
    }

    @Override
    public void setValue(Object data, int ordinal) {
        byte[] bytes = String.valueOf(data).getBytes(Charset.forName("UTF-8"));
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        this.varCharVector.setSafe(this.count, byteBuffer, byteBuffer.position(), bytes.length);
    }
}

