/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file.arrow;

import java.math.BigDecimal;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.carbondata.sdk.file.arrow.ArrowFieldWriter;

class DecimalWriter
extends ArrowFieldWriter {
    private final int precision;
    private final int scale;
    private DecimalVector decimalVector;

    public DecimalWriter(DecimalVector decimalVector, int precision, int scale) {
        super((ValueVector)decimalVector);
        this.decimalVector = decimalVector;
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public void setNull() {
        this.decimalVector.setNull(this.count);
    }

    @Override
    public void setValue(Object data, int ordinal) {
        BigDecimal decimal = (BigDecimal)data;
        this.decimalVector.setSafe(this.count, decimal);
    }
}

