/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file.arrow;

import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.carbondata.sdk.file.Schema;
import org.apache.carbondata.sdk.file.arrow.ArrayWriter;
import org.apache.carbondata.sdk.file.arrow.ArrowFieldWriter;
import org.apache.carbondata.sdk.file.arrow.ArrowUtils;
import org.apache.carbondata.sdk.file.arrow.BinaryWriter;
import org.apache.carbondata.sdk.file.arrow.BooleanWriter;
import org.apache.carbondata.sdk.file.arrow.ByteWriter;
import org.apache.carbondata.sdk.file.arrow.DateWriter;
import org.apache.carbondata.sdk.file.arrow.DecimalWriter;
import org.apache.carbondata.sdk.file.arrow.DoubleWriter;
import org.apache.carbondata.sdk.file.arrow.FloatWriter;
import org.apache.carbondata.sdk.file.arrow.IntWriter;
import org.apache.carbondata.sdk.file.arrow.LongWriter;
import org.apache.carbondata.sdk.file.arrow.ShortWriter;
import org.apache.carbondata.sdk.file.arrow.StringWriter;
import org.apache.carbondata.sdk.file.arrow.StructWriter;
import org.apache.carbondata.sdk.file.arrow.TimeStampWriter;

public class ArrowWriter {
    private VectorSchemaRoot root;
    private ArrowFieldWriter[] children;
    private int count;

    public void write(Object[] data) {
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].write(data[i], i);
        }
        ++this.count;
    }

    public void finish() {
        this.root.setRowCount(this.count);
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].finish();
        }
    }

    public void reset() {
        this.root.setRowCount(0);
        this.count = 0;
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].reset();
        }
    }

    private ArrowWriter(VectorSchemaRoot root, ArrowFieldWriter[] children) {
        this.root = root;
        this.children = children;
    }

    public static ArrowWriter create(Schema schema, String timeZoneId) {
        org.apache.arrow.vector.types.pojo.Schema arrowSchema = ArrowUtils.toArrowSchema(schema, timeZoneId);
        VectorSchemaRoot root = VectorSchemaRoot.create((org.apache.arrow.vector.types.pojo.Schema)arrowSchema, (BufferAllocator)ArrowUtils.rootAllocator);
        return ArrowWriter.create(root);
    }

    public static ArrowWriter create(VectorSchemaRoot root) {
        List fieldVectors = root.getFieldVectors();
        ArrowFieldWriter[] fieldWriters = new ArrowFieldWriter[fieldVectors.size()];
        int i = 0;
        for (FieldVector fieldVector : fieldVectors) {
            fieldWriters[i] = ArrowWriter.createFieldWriter((ValueVector)fieldVector);
            ++i;
        }
        return new ArrowWriter(root, fieldWriters);
    }

    private static ArrowFieldWriter createFieldWriter(ValueVector valueVector) {
        if (valueVector instanceof BitVector) {
            return new BooleanWriter((BitVector)valueVector);
        }
        if (valueVector instanceof TinyIntVector) {
            return new ByteWriter((TinyIntVector)valueVector);
        }
        if (valueVector instanceof SmallIntVector) {
            return new ShortWriter((SmallIntVector)valueVector);
        }
        if (valueVector instanceof IntVector) {
            return new IntWriter((IntVector)valueVector);
        }
        if (valueVector instanceof BigIntVector) {
            return new LongWriter((BigIntVector)valueVector);
        }
        if (valueVector instanceof DecimalVector) {
            DecimalVector decimalVector = (DecimalVector)valueVector;
            Field field = decimalVector.getField();
            ArrowType.Decimal c = (ArrowType.Decimal)field.getType();
            return new DecimalWriter((DecimalVector)valueVector, c.getPrecision(), c.getScale());
        }
        if (valueVector instanceof VarCharVector) {
            return new StringWriter((VarCharVector)valueVector);
        }
        if (valueVector instanceof Float4Vector) {
            return new FloatWriter((Float4Vector)valueVector);
        }
        if (valueVector instanceof Float8Vector) {
            return new DoubleWriter((Float8Vector)valueVector);
        }
        if (valueVector instanceof ListVector) {
            ArrowFieldWriter elementVector = ArrowWriter.createFieldWriter((ValueVector)((ListVector)valueVector).getDataVector());
            return new ArrayWriter((ListVector)valueVector, elementVector);
        }
        if (valueVector instanceof StructVector) {
            StructVector s = (StructVector)valueVector;
            ArrayList<ArrowFieldWriter> arrowFieldWriters = new ArrayList<ArrowFieldWriter>();
            for (int i = 0; i < s.size(); ++i) {
                arrowFieldWriters.add(ArrowWriter.createFieldWriter(s.getChildByOrdinal(i)));
            }
            return new StructWriter(s, arrowFieldWriters.toArray(new ArrowFieldWriter[arrowFieldWriters.size()]));
        }
        if (valueVector instanceof VarBinaryVector) {
            return new BinaryWriter((VarBinaryVector)valueVector);
        }
        if (valueVector instanceof DateDayVector) {
            return new DateWriter((DateDayVector)valueVector);
        }
        if (valueVector instanceof TimeStampMicroTZVector) {
            return new TimeStampWriter((TimeStampMicroTZVector)valueVector);
        }
        throw new UnsupportedOperationException("Invalid data type");
    }
}

