/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file.arrow;

import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.carbondata.sdk.file.arrow.ArrowFieldWriter;

class ArrayWriter
extends ArrowFieldWriter {
    private ListVector listVector;
    private ArrowFieldWriter elementWriter;

    public ArrayWriter(ListVector listVector, ArrowFieldWriter elementWriter) {
        super((ValueVector)listVector);
        this.listVector = listVector;
        this.elementWriter = elementWriter;
    }

    @Override
    public void setNull() {
    }

    @Override
    public void setValue(Object data, int ordinal) {
        Object[] array = (Object[])data;
        this.listVector.startNewValue(this.count);
        for (int i = 0; i < array.length; ++i) {
            this.elementWriter.write(array, i);
        }
        this.listVector.endValue(this.count, array.length);
    }

    @Override
    public void finish() {
        super.finish();
        this.elementWriter.finish();
    }

    @Override
    public void reset() {
        super.reset();
        this.elementWriter.reset();
    }
}

