/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.metadata.datatype.ArrayType;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.sdk.file.Field;

@InterfaceAudience.User
@InterfaceStability.Unstable
public class Schema {
    private Field[] fields;

    public Schema(Field[] fields) {
        this.fields = fields;
    }

    public Schema(List<ColumnSchema> columnSchemaList) {
        this.fields = new Field[columnSchemaList.size()];
        for (int i = 0; i < columnSchemaList.size(); ++i) {
            this.fields[i] = new Field(columnSchemaList.get(i));
        }
    }

    public static Schema parseJson(String json) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Field.class, (Object)new TypeAdapter<Field>(){

            public void write(JsonWriter out, Field field) throws IOException {
            }

            public Field read(JsonReader in) throws IOException {
                in.beginObject();
                Field field = new Field(in.nextName(), in.nextString());
                in.endObject();
                return field;
            }
        });
        Field[] fields = (Field[])gsonBuilder.create().fromJson(json, Field[].class);
        return new Schema(fields);
    }

    public Field[] getFields() {
        return this.fields;
    }

    public int getFieldsLength() {
        return this.fields.length;
    }

    public String getFieldName(int ordinal) {
        return this.fields[ordinal].getFieldName();
    }

    public String getFieldDataTypeName(int ordinal) {
        return this.fields[ordinal].getDataType().getName();
    }

    public String getArrayElementTypeName(int ordinal) {
        if (this.getFieldDataTypeName(ordinal).equalsIgnoreCase("ARRAY")) {
            return ((ArrayType)this.fields[ordinal].getDataType()).getElementType().getName();
        }
        throw new RuntimeException("Only support Array type.");
    }

    public Schema asOriginOrder() {
        Arrays.sort(this.fields, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return Integer.compare(o1.getSchemaOrdinal(), o2.getSchemaOrdinal());
            }
        });
        return this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Schema) {
            Schema schema = (Schema)obj;
            for (int i = 0; i < this.fields.length; ++i) {
                if (schema.fields[i].equals(this.fields[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

