/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.IOException;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.hadoop.api.CarbonTableOutputFormat;
import org.apache.carbondata.hadoop.internal.ObjectArrayWritable;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.sdk.file.CarbonWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;

@InterfaceAudience.User
public class JsonCarbonWriter
extends CarbonWriter {
    private RecordWriter<NullWritable, ObjectArrayWritable> recordWriter;
    private TaskAttemptContext context;
    private ObjectArrayWritable writable;

    JsonCarbonWriter(CarbonLoadModel loadModel) throws IOException {
        Configuration OutputHadoopConf = new Configuration();
        CarbonTableOutputFormat.setLoadModel((Configuration)OutputHadoopConf, (CarbonLoadModel)loadModel);
        CarbonTableOutputFormat outputFormat = new CarbonTableOutputFormat();
        JobID jobId = new JobID(UUID.randomUUID().toString(), 0);
        Random random = new Random();
        TaskID task = new TaskID(jobId, TaskType.MAP, random.nextInt());
        TaskAttemptID attemptID = new TaskAttemptID(task, random.nextInt());
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(OutputHadoopConf, attemptID);
        this.recordWriter = outputFormat.getRecordWriter((TaskAttemptContext)context);
        this.context = context;
        this.writable = new ObjectArrayWritable();
    }

    @Override
    public void write(Object object) throws IOException {
        Objects.requireNonNull(object, "Input cannot be null");
        try {
            Object[] jsonString = new String[]{(String)object};
            this.writable.set(jsonString);
            this.recordWriter.write((Object)NullWritable.get(), (Object)this.writable);
        }
        catch (Exception e) {
            this.close();
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.recordWriter.close(this.context);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

