/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.util.CarbonTaskInfo;
import org.apache.carbondata.core.util.ThreadLocalTaskInfo;
import org.apache.carbondata.sdk.file.CarbonReaderBuilder;
import org.apache.hadoop.mapreduce.RecordReader;

@InterfaceAudience.User
@InterfaceStability.Evolving
public class CarbonReader<T> {
    private List<RecordReader<Void, T>> readers;
    private RecordReader<Void, T> currentReader;
    private int index;
    private boolean initialise;

    CarbonReader(List<RecordReader<Void, T>> readers) {
        if (readers.size() == 0) {
            throw new IllegalArgumentException("no reader");
        }
        this.initialise = true;
        this.readers = readers;
        this.index = 0;
        this.currentReader = readers.get(0);
        CarbonTaskInfo carbonTaskInfo = new CarbonTaskInfo();
        carbonTaskInfo.setTaskId(System.nanoTime());
        ThreadLocalTaskInfo.setCarbonTaskInfo((CarbonTaskInfo)carbonTaskInfo);
    }

    public boolean hasNext() throws IOException, InterruptedException {
        this.validateReader();
        if (this.currentReader.nextKeyValue()) {
            return true;
        }
        if (this.index == this.readers.size() - 1) {
            return false;
        }
        ++this.index;
        this.currentReader.close();
        this.currentReader = this.readers.get(this.index);
        return this.currentReader.nextKeyValue();
    }

    public T readNextRow() throws IOException, InterruptedException {
        this.validateReader();
        return (T)this.currentReader.getCurrentValue();
    }

    public static CarbonReaderBuilder builder(String tablePath, String tableName) {
        return new CarbonReaderBuilder(tablePath, tableName);
    }

    public static CarbonReaderBuilder builder(String tablePath) {
        String time = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        String tableName = "UnknownTable" + time;
        return CarbonReader.builder(tablePath, tableName);
    }

    public void close() throws IOException {
        this.validateReader();
        this.currentReader.close();
        this.initialise = false;
    }

    private void validateReader() {
        if (!this.initialise) {
            throw new RuntimeException(this.getClass().getSimpleName() + " not initialise, please create it first.");
        }
    }
}

