/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.readers;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.VariableWidthBlock;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.result.vector.CarbonDictionary;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.presto.readers.PrestoVectorBlockBuilder;

public class SliceStreamReader
extends CarbonColumnVectorImpl
implements PrestoVectorBlockBuilder {
    protected int batchSize;
    protected Type type = VarcharType.VARCHAR;
    protected BlockBuilder builder;
    private Block dictionaryBlock;
    private boolean isLocalDict;
    private Dictionary globalDictionary;

    public SliceStreamReader(int batchSize, DataType dataType, Dictionary dictionary) {
        super(batchSize, dataType);
        this.globalDictionary = dictionary;
        this.batchSize = batchSize;
        this.builder = this.type.createBlockBuilder(null, batchSize);
    }

    @Override
    public Block buildBlock() {
        if (this.dictionaryBlock == null) {
            return this.builder.build();
        }
        int[] dataArray = this.isLocalDict ? (int[])((CarbonColumnVectorImpl)this.getDictionaryVector()).getDataArray() : (int[])this.getDataArray();
        return new DictionaryBlock(this.batchSize, this.dictionaryBlock, dataArray);
    }

    public void setDictionary(CarbonDictionary dictionary) {
        super.setDictionary(dictionary);
        if (dictionary == null) {
            this.dictionaryBlock = null;
            this.isLocalDict = false;
            return;
        }
        boolean[] nulls = new boolean[dictionary.getDictionarySize()];
        nulls[0] = true;
        nulls[1] = true;
        int[] dictOffsets = new int[dictionary.getDictionarySize() + 1];
        int size = 0;
        for (int i = 0; i < dictionary.getDictionarySize(); ++i) {
            dictOffsets[i] = size;
            if (dictionary.getDictionaryValue(i) == null) continue;
            size += dictionary.getDictionaryValue(i).length;
        }
        byte[] singleArrayDictValues = new byte[size];
        for (int i = 0; i < dictionary.getDictionarySize(); ++i) {
            if (dictionary.getDictionaryValue(i) == null) continue;
            System.arraycopy(dictionary.getDictionaryValue(i), 0, singleArrayDictValues, dictOffsets[i], dictionary.getDictionaryValue(i).length);
        }
        dictOffsets[dictOffsets.length - 1] = size;
        this.dictionaryBlock = new VariableWidthBlock(dictionary.getDictionarySize(), Slices.wrappedBuffer((byte[])singleArrayDictValues), dictOffsets, Optional.of(nulls));
        this.isLocalDict = true;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void putByteArray(int rowId, byte[] value) {
        this.type.writeSlice(this.builder, Slices.wrappedBuffer((byte[])value));
    }

    public void putByteArray(int rowId, int offset, int length, byte[] value) {
        this.type.writeSlice(this.builder, Slices.wrappedBuffer((byte[])value), offset, length);
    }

    public void putByteArray(int rowId, int count, byte[] value) {
        for (int i = 0; i < count; ++i) {
            this.type.writeSlice(this.builder, Slices.wrappedBuffer((byte[])value));
        }
    }

    public void putNull(int rowId) {
        if (this.dictionaryBlock == null) {
            this.builder.appendNull();
        }
    }

    public void putNulls(int rowId, int count) {
        if (this.dictionaryBlock == null) {
            for (int i = 0; i < count; ++i) {
                this.builder.appendNull();
            }
        }
    }

    public void reset() {
        this.builder = this.type.createBlockBuilder(null, this.batchSize);
    }

    public void putInt(int rowId, int value) {
        Object data = DataTypeUtil.getDataBasedOnDataType((String)this.globalDictionary.getDictionaryValueForKey(value), (DataType)DataTypes.STRING);
        if (Objects.isNull(data)) {
            this.builder.appendNull();
        } else {
            this.type.writeSlice(this.builder, Slices.wrappedBuffer((byte[])((String)data).getBytes(Charset.forName("UTF-8"))));
        }
    }

    public void putObject(int rowId, Object value) {
        if (value == null) {
            this.putNull(rowId);
        } else if (this.dictionaryBlock == null) {
            this.putByteArray(rowId, ByteUtil.toBytes((String)((String)value)));
        } else {
            this.putInt(rowId, (Integer)value);
        }
    }
}

