/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.readers;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.AbstractType;
import com.facebook.presto.spi.type.RealType;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.presto.readers.PrestoVectorBlockBuilder;

public class FloatStreamReader
extends CarbonColumnVectorImpl
implements PrestoVectorBlockBuilder {
    protected int batchSize;
    protected AbstractType type = RealType.REAL;
    protected BlockBuilder builder;
    private Dictionary dictionary;

    public FloatStreamReader(int batchSize, DataType dataType, Dictionary dictionary) {
        super(batchSize, dataType);
        this.batchSize = batchSize;
        this.builder = this.type.createBlockBuilder(null, batchSize);
        this.dictionary = dictionary;
    }

    @Override
    public Block buildBlock() {
        return this.builder.build();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void putInt(int rowId, int value) {
        Object data = DataTypeUtil.getDataBasedOnDataType((String)this.dictionary.getDictionaryValueForKey(value), (DataType)DataTypes.FLOAT);
        if (data != null) {
            this.type.writeLong(this.builder, (long)Float.floatToRawIntBits(((Float)data).floatValue()));
        } else {
            this.builder.appendNull();
        }
    }

    public void putFloat(int rowId, float value) {
        this.type.writeLong(this.builder, (long)Float.floatToRawIntBits(value));
    }

    public void putFloats(int rowId, int count, float[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            this.type.writeLong(this.builder, (long)Float.floatToRawIntBits(src[i]));
        }
    }

    public void putNull(int rowId) {
        this.builder.appendNull();
    }

    public void putNulls(int rowId, int count) {
        for (int i = 0; i < count; ++i) {
            this.builder.appendNull();
        }
    }

    public void reset() {
        this.builder = this.type.createBlockBuilder(null, this.batchSize);
    }

    public void putObject(int rowId, Object value) {
        if (value == null) {
            this.putNull(rowId);
        } else if (this.dictionary == null) {
            this.putFloat(rowId, ((Float)value).floatValue());
        } else {
            this.putInt(rowId, (Integer)value);
        }
    }
}

