/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.readers;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.presto.readers.PrestoVectorBlockBuilder;

public class DoubleStreamReader
extends CarbonColumnVectorImpl
implements PrestoVectorBlockBuilder {
    protected int batchSize;
    protected Type type = DoubleType.DOUBLE;
    protected BlockBuilder builder;
    private Dictionary dictionary;

    public DoubleStreamReader(int batchSize, DataType dataType, Dictionary dictionary) {
        super(batchSize, dataType);
        this.batchSize = batchSize;
        this.builder = this.type.createBlockBuilder(null, batchSize);
        this.dictionary = dictionary;
    }

    @Override
    public Block buildBlock() {
        return this.builder.build();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void putInt(int rowId, int value) {
        Object data = DataTypeUtil.getDataBasedOnDataType((String)this.dictionary.getDictionaryValueForKey(value), (DataType)DataTypes.DOUBLE);
        if (data != null) {
            this.type.writeDouble(this.builder, ((Double)data).doubleValue());
        } else {
            this.builder.appendNull();
        }
    }

    public void putDouble(int rowId, double value) {
        this.type.writeDouble(this.builder, value);
    }

    public void putDoubles(int rowId, int count, double value) {
        for (int i = 0; i < count; ++i) {
            this.type.writeDouble(this.builder, value);
        }
    }

    public void putNull(int rowId) {
        this.builder.appendNull();
    }

    public void putNulls(int rowId, int count) {
        for (int i = 0; i < count; ++i) {
            this.builder.appendNull();
        }
    }

    public void reset() {
        this.builder = this.type.createBlockBuilder(null, this.batchSize);
    }

    public void putObject(int rowId, Object value) {
        if (value == null) {
            this.putNull(rowId);
        } else if (this.dictionary == null) {
            this.putDouble(rowId, (Double)value);
        } else {
            this.putInt(rowId, (Integer)value);
        }
    }
}

