/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.readers;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.AbstractType;
import com.facebook.presto.spi.type.TinyintType;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.presto.readers.PrestoVectorBlockBuilder;

public class ByteStreamReader
extends CarbonColumnVectorImpl
implements PrestoVectorBlockBuilder {
    protected int batchSize;
    protected AbstractType type = TinyintType.TINYINT;
    protected BlockBuilder builder;
    private Dictionary dictionary;

    public ByteStreamReader(int batchSize, DataType dataType, Dictionary dictionary) {
        super(batchSize, dataType);
        this.batchSize = batchSize;
        this.builder = this.type.createBlockBuilder(null, batchSize);
        this.dictionary = dictionary;
    }

    @Override
    public Block buildBlock() {
        return this.builder.build();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void putInt(int rowId, int value) {
        Object data = DataTypeUtil.getDataBasedOnDataType((String)this.dictionary.getDictionaryValueForKey(value), (DataType)DataTypes.BYTE);
        if (data != null) {
            this.type.writeLong(this.builder, (long)((Byte)data).byteValue());
        } else {
            this.builder.appendNull();
        }
    }

    public void putByte(int rowId, byte value) {
        this.type.writeLong(this.builder, (long)value);
    }

    public void putBytes(int rowId, int count, byte[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            this.type.writeLong(this.builder, (long)src[i]);
        }
    }

    public void putNull(int rowId) {
        this.builder.appendNull();
    }

    public void putNulls(int rowId, int count) {
        for (int i = 0; i < count; ++i) {
            this.builder.appendNull();
        }
    }

    public void reset() {
        this.builder = this.type.createBlockBuilder(null, this.batchSize);
    }

    public void putObject(int rowId, Object value) {
        if (value == null) {
            this.putNull(rowId);
        } else if (this.dictionary == null) {
            this.putByte(rowId, (Byte)value);
        } else {
            this.putInt(rowId, (Integer)value);
        }
    }
}

