/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.impl;

import com.facebook.presto.hadoop.;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datamap.DataMapStoreManager;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonMetadata;
import org.apache.carbondata.core.metadata.SegmentFileStore;
import org.apache.carbondata.core.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.metadata.schema.PartitionInfo;
import org.apache.carbondata.core.metadata.schema.partition.PartitionType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.reader.ThriftReader;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.format.TableInfo;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.api.CarbonInputFormat;
import org.apache.carbondata.hadoop.api.CarbonTableInputFormat;
import org.apache.carbondata.presto.PrestoFilterUtil;
import org.apache.carbondata.presto.impl.CarbonLocalInputSplit;
import org.apache.carbondata.presto.impl.CarbonLocalMultiBlockSplit;
import org.apache.carbondata.presto.impl.CarbonTableCacheModel;
import org.apache.carbondata.presto.impl.CarbonTableConfig;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.log4j.Logger;
import org.apache.thrift.TBase;

public class CarbonTableReader {
    private static final PathFilter DefaultFilter = new PathFilter(){

        public boolean accept(Path path) {
            return CarbonTablePath.isCarbonDataFile((String)path.getName());
        }
    };
    public CarbonTableConfig config;
    private AtomicReference<Map<SchemaTableName, CarbonTableCacheModel>> carbonCache;
    private String queryId;
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonTableReader.class.getName());
    private List<String> schemaNames = new ArrayList<String>();

    @Inject
    public CarbonTableReader(CarbonTableConfig config) {
        this.config = Objects.requireNonNull(config, "CarbonTableConfig is null");
        this.carbonCache = new AtomicReference(new ConcurrentHashMap());
        this.populateCarbonProperties();
    }

    public CarbonTableCacheModel getCarbonCache(SchemaTableName table, String location, Configuration config) {
        this.updateSchemaTables(table, config);
        CarbonTableCacheModel carbonTableCacheModel = this.carbonCache.get().get(table);
        if (carbonTableCacheModel == null || !carbonTableCacheModel.isValid()) {
            return this.parseCarbonMetadata(table, location, config);
        }
        return carbonTableCacheModel;
    }

    private void updateSchemaTables(SchemaTableName schemaTableName, Configuration config) {
        CarbonTableCacheModel carbonTableCacheModel = this.carbonCache.get().get(schemaTableName);
        if (carbonTableCacheModel != null && carbonTableCacheModel.getCarbonTable().isTransactionalTable()) {
            CarbonTable carbonTable = carbonTableCacheModel.getCarbonTable();
            long latestTime = FileFactory.getCarbonFile((String)CarbonTablePath.getSchemaFilePath((String)carbonTable.getTablePath()), (Configuration)config).getLastModifiedTime();
            carbonTableCacheModel.setCurrentSchemaTime(latestTime);
            if (!carbonTableCacheModel.isValid()) {
                DataMapStoreManager.getInstance().clearDataMaps(carbonTableCacheModel.getCarbonTable().getAbsoluteTableIdentifier());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CarbonTableCacheModel parseCarbonMetadata(SchemaTableName table, String tablePath, Configuration config) {
        try {
            CarbonTableCacheModel cache = this.getValidCacheBySchemaTableName(table);
            if (cache != null) {
                return cache;
            }
            CarbonTableReader carbonTableReader = this;
            synchronized (carbonTableReader) {
                TableInfo tableInfo;
                CarbonTableCacheModel cacheModel = this.getValidCacheBySchemaTableName(table);
                if (cacheModel != null) {
                    return cacheModel;
                }
                String schemaFilePath = CarbonTablePath.getSchemaFilePath((String)tablePath, (Configuration)config);
                CarbonFile schemaFile = FileFactory.getCarbonFile((String)schemaFilePath, (Configuration)config);
                boolean isTransactionalTable = schemaFile.exists();
                long modifiedTime = System.currentTimeMillis();
                if (isTransactionalTable) {
                    ThriftReader.TBaseCreator createTBase = new ThriftReader.TBaseCreator(){

                        public TBase create() {
                            return new TableInfo();
                        }
                    };
                    ThriftReader thriftReader = new ThriftReader(schemaFilePath, createTBase, config);
                    thriftReader.open();
                    tableInfo = (TableInfo)thriftReader.read();
                    thriftReader.close();
                    modifiedTime = schemaFile.getLastModifiedTime();
                } else {
                    tableInfo = CarbonUtil.inferSchema((String)tablePath, (String)table.getTableName(), (boolean)false, (Configuration)config);
                }
                ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
                org.apache.carbondata.core.metadata.schema.table.TableInfo wrapperTableInfo = schemaConverter.fromExternalToWrapperTableInfo(tableInfo, table.getSchemaName(), table.getTableName(), tablePath);
                wrapperTableInfo.setTransactionalTable(isTransactionalTable);
                CarbonMetadata.getInstance().removeTable(wrapperTableInfo.getTableUniqueName());
                CarbonMetadata.getInstance().loadTableMetadata(wrapperTableInfo);
                CarbonTable carbonTable = Objects.requireNonNull(CarbonMetadata.getInstance().getCarbonTable(table.getSchemaName(), table.getTableName()), "carbontable is null");
                cache = new CarbonTableCacheModel(modifiedTime, carbonTable);
                this.carbonCache.get().put(table, cache);
                cache.setCarbonTable(carbonTable);
            }
            return cache;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private CarbonTableCacheModel getValidCacheBySchemaTableName(SchemaTableName schemaTableName) {
        CarbonTableCacheModel cache = this.carbonCache.get().get(schemaTableName);
        if (cache != null && cache.isValid()) {
            return cache;
        }
        return null;
    }

    public List<CarbonLocalMultiBlockSplit> getInputSplits2(CarbonTableCacheModel tableCacheModel, Expression filters, TupleDomain<HiveColumnHandle> constraints, Configuration config) throws IOException {
        ArrayList<CarbonLocalInputSplit> result = new ArrayList<CarbonLocalInputSplit>();
        ArrayList<CarbonLocalMultiBlockSplit> multiBlockSplitList = new ArrayList<CarbonLocalMultiBlockSplit>();
        CarbonTable carbonTable = tableCacheModel.getCarbonTable();
        org.apache.carbondata.core.metadata.schema.table.TableInfo tableInfo = tableCacheModel.getCarbonTable().getTableInfo();
        config.set("mapreduce.input.carboninputformat.segmentnumbers", "");
        String carbonTablePath = carbonTable.getAbsoluteTableIdentifier().getTablePath();
        config.set("mapreduce.input.fileinputformat.inputdir", carbonTablePath);
        config.set("mapreduce.input.carboninputformat.databaseName", carbonTable.getDatabaseName());
        config.set("mapreduce.input.carboninputformat.tableName", carbonTable.getTableName());
        config.set("query.id", this.queryId);
        CarbonInputFormat.setTransactionalTable((Configuration)config, (boolean)carbonTable.isTransactionalTable());
        CarbonInputFormat.setTableInfo((Configuration)config, (org.apache.carbondata.core.metadata.schema.table.TableInfo)carbonTable.getTableInfo());
        JobConf jobConf = new JobConf(config);
        List<PartitionSpec> filteredPartitions = new ArrayList<PartitionSpec>();
        PartitionInfo partitionInfo = carbonTable.getPartitionInfo(carbonTable.getTableName());
        LoadMetadataDetails[] loadMetadataDetails = null;
        if (partitionInfo != null && partitionInfo.getPartitionType() == PartitionType.NATIVE_HIVE) {
            try {
                loadMetadataDetails = SegmentStatusManager.readTableStatusFile((String)CarbonTablePath.getTableStatusFilePath((String)carbonTable.getTablePath()));
            }
            catch (IOException exception) {
                LOGGER.error((Object)exception.getMessage());
                throw exception;
            }
            filteredPartitions = this.findRequiredPartitions(constraints, carbonTable, loadMetadataDetails);
        }
        try {
            CarbonTableInputFormat.setTableInfo((Configuration)config, (org.apache.carbondata.core.metadata.schema.table.TableInfo)tableInfo);
            CarbonTableInputFormat<Object> carbonTableInputFormat = this.createInputFormat((Configuration)jobConf, carbonTable.getAbsoluteTableIdentifier(), filters, filteredPartitions);
            Job job = Job.getInstance((Configuration)jobConf);
            List splits = carbonTableInputFormat.getSplits((JobContext)job);
            .Gson gson = new .Gson();
            if (splits != null && splits.size() > 0) {
                for (InputSplit inputSplit : splits) {
                    CarbonInputSplit carbonInputSplit = (CarbonInputSplit)inputSplit;
                    result.add(new CarbonLocalInputSplit(carbonInputSplit.getSegmentId(), carbonInputSplit.getPath().toString(), carbonInputSplit.getStart(), carbonInputSplit.getLength(), Arrays.asList(carbonInputSplit.getLocations()), carbonInputSplit.getNumberOfBlocklets(), carbonInputSplit.getVersion().number(), carbonInputSplit.getDeleteDeltaFiles(), carbonInputSplit.getBlockletId(), gson.toJson((Object)carbonInputSplit.getDetailInfo()), carbonInputSplit.getFileFormat().ordinal()));
                }
                ArrayList<List<CarbonLocalInputSplit>> inputSplits = new ArrayList<List<CarbonLocalInputSplit>>(result.stream().map(x -> x).collect(Collectors.groupingBy(carbonInput -> carbonInput.getSegmentId().concat(carbonInput.getPath()))).values());
                if (inputSplits != null) {
                    for (int j = 0; j < inputSplits.size(); ++j) {
                        multiBlockSplitList.add(new CarbonLocalMultiBlockSplit((List)inputSplits.get(j), (String[])((List)inputSplits.get(j)).stream().flatMap(f -> Arrays.stream(this.getLocations((CarbonLocalInputSplit)f))).distinct().toArray(String[]::new)));
                    }
                }
                LOGGER.error((Object)("Size fo MultiblockList   " + multiBlockSplitList.size()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return multiBlockSplitList;
    }

    private List<PartitionSpec> findRequiredPartitions(TupleDomain<HiveColumnHandle> constraints, CarbonTable carbonTable, LoadMetadataDetails[] loadMetadataDetails) throws IOException {
        HashSet partitionSpecs = new HashSet();
        ArrayList<PartitionSpec> prunePartitions = new ArrayList<PartitionSpec>();
        for (LoadMetadataDetails loadMetadataDetail : loadMetadataDetails) {
            SegmentFileStore segmentFileStore = null;
            try {
                segmentFileStore = new SegmentFileStore(carbonTable.getTablePath(), loadMetadataDetail.getSegmentFile());
                partitionSpecs.addAll(segmentFileStore.getPartitionSpecs());
            }
            catch (IOException exception) {
                LOGGER.error((Object)exception.getMessage());
                throw exception;
            }
        }
        List<String> partitionValuesFromExpression = PrestoFilterUtil.getPartitionFilters(carbonTable, constraints);
        List partitionSpecList = partitionSpecs.stream().filter(partitionSpec -> .CollectionUtils.isSubCollection((Collection)partitionValuesFromExpression, (Collection)partitionSpec.getPartitions())).collect(Collectors.toList());
        prunePartitions.addAll(partitionSpecList);
        return prunePartitions;
    }

    private CarbonTableInputFormat<Object> createInputFormat(Configuration conf, AbsoluteTableIdentifier identifier, Expression filterExpression, List<PartitionSpec> filteredPartitions) throws IOException {
        CarbonTableInputFormat format = new CarbonTableInputFormat();
        CarbonTableInputFormat.setTablePath((Configuration)conf, (String)identifier.appendWithLocalPrefix(identifier.getTablePath()));
        CarbonTableInputFormat.setFilterPredicates((Configuration)conf, (Expression)filterExpression);
        if (filteredPartitions.size() != 0) {
            CarbonTableInputFormat.setPartitionsToPrune((Configuration)conf, filteredPartitions);
        }
        return format;
    }

    private void populateCarbonProperties() {
        this.addProperty("carbon.unsafe.working.memory.in.mb", this.config.getUnsafeMemoryInMb());
        this.addProperty("enable.unsafe.in.query.processing", this.config.getEnableUnsafeInQueryExecution());
        this.addProperty("enable.unsafe.columnpage", this.config.getEnableUnsafeColumnPage());
        this.addProperty("enable.unsafe.sort", this.config.getEnableUnsafeSort());
        this.addProperty("enable.query.statistics", this.config.getEnableQueryStatistics());
        this.addProperty("carbon.writtenby.app.name", "Presto_Server");
    }

    public Configuration updateS3Properties(Configuration configuration) {
        configuration.set("fs.s3a.access.key", Objects.toString(this.config.getS3A_AcesssKey(), ""));
        configuration.set("fs.s3a.secret.key", Objects.toString(this.config.getS3A_SecretKey()));
        configuration.set("fs.s3.awsAccessKeyId", Objects.toString(this.config.getS3_AcesssKey(), ""));
        configuration.set("fs.s3.awsSecretAccessKey", Objects.toString(this.config.getS3_SecretKey()));
        configuration.set("fs.s3n.awsAccessKeyId", Objects.toString(this.config.getS3N_AcesssKey(), ""));
        configuration.set("fs.s3n.awsSecretAccessKey", Objects.toString(this.config.getS3N_SecretKey(), ""));
        configuration.set("fs.s3a.endpoint", Objects.toString(this.config.getS3EndPoint(), ""));
        return configuration;
    }

    private void addProperty(String propertyName, String propertyValue) {
        if (propertyValue != null) {
            CarbonProperties.getInstance().addProperty(propertyName, propertyValue);
        }
    }

    private String[] getLocations(CarbonLocalInputSplit cis) {
        return cis.getLocations().toArray(new String[cis.getLocations().size()]);
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }
}

