/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.Gson;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.carbondata.core.statusmanager.FileFormat;
import org.apache.carbondata.hadoop.CarbonMultiBlockSplit;
import org.apache.carbondata.presto.impl.CarbonLocalInputSplit;

public class CarbonLocalMultiBlockSplit {
    private static final long serialVersionUID = 3520344046772190207L;
    private List<CarbonLocalInputSplit> splitList;
    private String[] locations;
    private FileFormat fileFormat = FileFormat.COLUMNAR_V3;
    private long length;

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    @JsonProperty
    public String[] getLocations() {
        return this.locations;
    }

    @JsonProperty
    public List<CarbonLocalInputSplit> getSplitList() {
        return this.splitList;
    }

    @JsonProperty
    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    @JsonCreator
    public CarbonLocalMultiBlockSplit(@JsonProperty(value="splitList") List<CarbonLocalInputSplit> splitList, @JsonProperty(value="locations") String[] locations) {
        this.splitList = splitList;
        this.locations = locations;
        if (!splitList.isEmpty()) {
            this.fileFormat = splitList.get(0).getFileFormat();
        }
    }

    public String getJsonString() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    public static CarbonMultiBlockSplit convertSplit(String multiSplitJson) {
        Gson gson = new Gson();
        CarbonLocalMultiBlockSplit carbonLocalMultiBlockSplit = (CarbonLocalMultiBlockSplit)gson.fromJson(multiSplitJson, CarbonLocalMultiBlockSplit.class);
        List carbonInputSplitList = carbonLocalMultiBlockSplit.getSplitList().stream().map(CarbonLocalInputSplit::convertSplit).collect(Collectors.toList());
        CarbonMultiBlockSplit carbonMultiBlockSplit = new CarbonMultiBlockSplit(carbonInputSplitList, carbonLocalMultiBlockSplit.getLocations());
        carbonMultiBlockSplit.setFileFormat(carbonLocalMultiBlockSplit.getFileFormat());
        return carbonMultiBlockSplit;
    }
}

