/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import java.math.BigDecimal;
import java.util.BitSet;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.CarbonDictionary;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.carbondata.core.scan.result.vector.impl.directread.SequentialFill;
import org.apache.carbondata.core.scan.scanner.LazyPageLoader;

class ColumnarVectorWrapperDirect
implements CarbonColumnVector,
SequentialFill {
    protected CarbonColumnVectorImpl columnVector;
    private DataType blockDataType;
    private CarbonColumnVector dictionaryVector;
    private BitSet nullBitset;

    ColumnarVectorWrapperDirect(CarbonColumnVectorImpl columnVector) {
        this.columnVector = columnVector;
        this.dictionaryVector = columnVector.getDictionaryVector();
        this.nullBitset = new BitSet();
    }

    public void setNullBits(BitSet nullBits) {
        this.nullBitset = nullBits;
    }

    public void putBoolean(int rowId, boolean value) {
        if (this.nullBitset.get(rowId)) {
            this.columnVector.putNull(rowId);
        } else {
            this.columnVector.putBoolean(rowId, value);
        }
    }

    public void putFloat(int rowId, float value) {
        if (this.nullBitset.get(rowId)) {
            this.columnVector.putNull(rowId);
        } else {
            this.columnVector.putFloat(rowId, value);
        }
    }

    public void putShort(int rowId, short value) {
        if (this.nullBitset.get(rowId)) {
            this.columnVector.putNull(rowId);
        } else {
            this.columnVector.putShort(rowId, value);
        }
    }

    public void putShorts(int rowId, int count, short value) {
        this.columnVector.putShorts(rowId, count, value);
    }

    public void putInt(int rowId, int value) {
        if (this.nullBitset.get(rowId)) {
            this.columnVector.putNull(rowId);
        } else {
            this.columnVector.putInt(rowId, value);
        }
    }

    public void putInts(int rowId, int count, int value) {
        this.columnVector.putInts(rowId, count, value);
    }

    public void putLong(int rowId, long value) {
        if (this.nullBitset.get(rowId)) {
            this.columnVector.putNull(rowId);
        } else {
            this.columnVector.putLong(rowId, value);
        }
    }

    public void putLongs(int rowId, int count, long value) {
        this.columnVector.putLongs(rowId, count, value);
    }

    public void putDecimal(int rowId, BigDecimal value, int precision) {
        if (this.nullBitset.get(rowId)) {
            this.columnVector.putNull(rowId);
        } else {
            this.columnVector.putDecimal(rowId, value, precision);
        }
    }

    public void putDecimals(int rowId, int count, BigDecimal value, int precision) {
        for (int i = 0; i < count; ++i) {
            if (this.nullBitset.get(rowId)) {
                this.columnVector.putNull(rowId);
            } else {
                this.columnVector.putDecimal(rowId, value, precision);
            }
            ++rowId;
        }
    }

    public void putDouble(int rowId, double value) {
        if (this.nullBitset.get(rowId)) {
            this.columnVector.putNull(rowId);
        } else {
            this.columnVector.putDouble(rowId, value);
        }
    }

    public void putDoubles(int rowId, int count, double value) {
        this.columnVector.putDoubles(rowId, count, value);
    }

    public void putByteArray(int rowId, byte[] value) {
        if (this.nullBitset.get(rowId)) {
            this.columnVector.putNull(rowId);
        } else {
            this.columnVector.putByteArray(rowId, value);
        }
    }

    public void putByteArray(int rowId, int count, byte[] value) {
        for (int i = 0; i < count; ++i) {
            this.columnVector.putByteArray(rowId++, value);
        }
    }

    public void putByteArray(int rowId, int offset, int length, byte[] value) {
        if (this.nullBitset.get(rowId)) {
            this.columnVector.putNull(rowId);
        } else {
            this.columnVector.putByteArray(rowId, offset, length, value);
        }
    }

    public void putNull(int rowId) {
        this.columnVector.putNull(rowId);
    }

    public void putNulls(int rowId, int count) {
        this.columnVector.putNulls(rowId, count);
    }

    public void putNotNull(int rowId) {
        this.columnVector.putNotNull(rowId);
    }

    public void putNotNull(int rowId, int count) {
    }

    public boolean isNull(int rowId) {
        return this.columnVector.isNullAt(rowId);
    }

    public void putObject(int rowId, Object obj) {
        throw new UnsupportedOperationException("Not supported this opeartion from " + this.getClass().getName());
    }

    public Object getData(int rowId) {
        throw new UnsupportedOperationException("Not supported this opeartion from " + this.getClass().getName());
    }

    public void reset() {
        if (null != this.dictionaryVector) {
            this.dictionaryVector.reset();
        }
    }

    public DataType getType() {
        return this.columnVector.getType();
    }

    public DataType getBlockDataType() {
        return this.blockDataType;
    }

    public void setBlockDataType(DataType blockDataType) {
        this.blockDataType = blockDataType;
    }

    public void setDictionary(CarbonDictionary dictionary) {
        this.columnVector.setDictionary(dictionary);
    }

    public boolean hasDictionary() {
        return this.columnVector.hasDictionary();
    }

    public CarbonColumnVector getDictionaryVector() {
        return this.dictionaryVector;
    }

    public void putByte(int rowId, byte value) {
        this.columnVector.putByte(rowId, value);
    }

    public void setFilteredRowsExist(boolean filteredRowsExist) {
    }

    public void putFloats(int rowId, int count, float[] src, int srcIndex) {
        for (int i = 0; i < count; ++i) {
            if (this.nullBitset.get(rowId)) {
                this.columnVector.putNull(rowId);
            } else {
                this.columnVector.putFloat(rowId, src[i]);
            }
            ++rowId;
        }
    }

    public void putShorts(int rowId, int count, short[] src, int srcIndex) {
        for (int i = 0; i < count; ++i) {
            if (this.nullBitset.get(rowId)) {
                this.columnVector.putNull(rowId);
            } else {
                this.columnVector.putShort(rowId, src[i]);
            }
            ++rowId;
        }
    }

    public void putInts(int rowId, int count, int[] src, int srcIndex) {
        for (int i = 0; i < count; ++i) {
            if (this.nullBitset.get(rowId)) {
                this.columnVector.putNull(rowId);
            } else {
                this.columnVector.putInt(rowId, src[i]);
            }
            ++rowId;
        }
    }

    public void putLongs(int rowId, int count, long[] src, int srcIndex) {
        for (int i = 0; i < count; ++i) {
            if (this.nullBitset.get(rowId)) {
                this.columnVector.putNull(rowId);
            } else {
                this.columnVector.putLong(rowId, src[i]);
            }
            ++rowId;
        }
    }

    public void putDoubles(int rowId, int count, double[] src, int srcIndex) {
        for (int i = 0; i < count; ++i) {
            if (this.nullBitset.get(rowId)) {
                this.columnVector.putNull(rowId);
            } else {
                this.columnVector.putDouble(rowId, src[i]);
            }
            ++rowId;
        }
    }

    public void putBytes(int rowId, int count, byte[] src, int srcIndex) {
        for (int i = 0; i < count; ++i) {
            if (this.nullBitset.get(rowId)) {
                this.columnVector.putNull(rowId);
            } else {
                this.columnVector.putByte(rowId, src[i]);
            }
            ++rowId;
        }
    }

    public void setLazyPage(LazyPageLoader lazyPage) {
        this.columnVector.setLazyPage(lazyPage);
    }

    public void putArray(int rowId, int offset, int length) {
        this.columnVector.putArray(rowId, offset, length);
    }

    public void putAllByteArray(byte[] data, int offset, int length) {
        this.columnVector.putAllByteArray(data, offset, length);
    }
}

