/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import com.facebook.presto.hive.CoercionPolicy;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.ForHiveClient;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveSplitManager;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveTransactionHandle;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsRecorder;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.core.util.ThreadLocalSessionInfo;
import org.apache.carbondata.presto.PrestoFilterUtil;
import org.apache.carbondata.presto.impl.CarbonLocalMultiBlockSplit;
import org.apache.carbondata.presto.impl.CarbonTableCacheModel;
import org.apache.carbondata.presto.impl.CarbonTableReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class CarbondataSplitManager
extends HiveSplitManager {
    private final CarbonTableReader carbonTableReader;
    private final Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider;
    private final HdfsEnvironment hdfsEnvironment;

    @Inject
    public CarbondataSplitManager(HiveClientConfig hiveClientConfig, Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider, NamenodeStats namenodeStats, HdfsEnvironment hdfsEnvironment, DirectoryLister directoryLister, @ForHiveClient ExecutorService executorService, CoercionPolicy coercionPolicy, CarbonTableReader reader) {
        super(hiveClientConfig, metastoreProvider, namenodeStats, hdfsEnvironment, directoryLister, executorService, coercionPolicy);
        this.carbonTableReader = Objects.requireNonNull(reader, "client is null");
        this.metastoreProvider = Objects.requireNonNull(metastoreProvider, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layoutHandle, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        HiveTableLayoutHandle layout = (HiveTableLayoutHandle)layoutHandle;
        SchemaTableName schemaTableName = layout.getSchemaTableName();
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)transactionHandle);
        Table table = (Table)metastore.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName()).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        if (!table.getStorage().getStorageFormat().getInputFormat().contains("carbon")) {
            return super.getSplits(transactionHandle, session, layoutHandle, splitSchedulingStrategy);
        }
        String location = table.getStorage().getLocation();
        String queryId = System.nanoTime() + "";
        QueryStatistic statistic = new QueryStatistic();
        QueryStatisticsRecorder statisticRecorder = CarbonTimeStatisticsFactory.createDriverRecorder();
        statistic.addStatistics("Total Time taken in block(s) allocation", System.currentTimeMillis());
        statisticRecorder.recordStatisticsForDriver(statistic, queryId);
        statistic = new QueryStatistic();
        this.carbonTableReader.setQueryId(queryId);
        TupleDomain predicate = layout.getCompactEffectivePredicate();
        Configuration configuration = this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, schemaTableName.getSchemaName(), schemaTableName.getTableName()), new Path(location));
        configuration = this.carbonTableReader.updateS3Properties(configuration);
        ThreadLocalSessionInfo.setConfigurationToCurrentThread((Configuration)configuration);
        CarbonTableCacheModel cache = this.carbonTableReader.getCarbonCache(schemaTableName, location, configuration);
        Expression filters = PrestoFilterUtil.parseFilterExpression((TupleDomain<HiveColumnHandle>)predicate);
        try {
            List<CarbonLocalMultiBlockSplit> splits = this.carbonTableReader.getInputSplits2(cache, filters, (TupleDomain<HiveColumnHandle>)predicate, configuration);
            ImmutableList.Builder cSplits = ImmutableList.builder();
            long index = 0L;
            for (CarbonLocalMultiBlockSplit split : splits) {
                ++index;
                Properties properties = new Properties();
                for (Map.Entry entry : table.getStorage().getSerdeParameters().entrySet()) {
                    properties.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
                properties.setProperty("tablePath", cache.getCarbonTable().getTablePath());
                properties.setProperty("carbonSplit", split.getJsonString());
                properties.setProperty("queryId", queryId);
                properties.setProperty("index", String.valueOf(index));
                cSplits.add((Object)new HiveSplit(schemaTableName.getSchemaName(), schemaTableName.getTableName(), schemaTableName.getTableName(), "", 0L, 0L, 0L, properties, new ArrayList(), CarbondataSplitManager.getHostAddresses(split.getLocations()), OptionalInt.empty(), false, predicate, new HashMap(), Optional.empty()));
            }
            statisticRecorder.logStatisticsAsTableDriver();
            statistic.addStatistics("Time taken to identify Block(s) to scan", System.currentTimeMillis());
            statisticRecorder.recordStatisticsForDriver(statistic, queryId);
            statisticRecorder.logStatisticsAsTableDriver();
            return new FixedSplitSource((Iterable)cSplits.build());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static List<HostAddress> getHostAddresses(String[] hosts) {
        return (List)Arrays.stream(hosts).map(HostAddress::fromString).collect(ImmutableList.toImmutableList());
    }
}

