/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HivePageSourceFactory;
import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.presto.CarbondataPageSource;
import org.apache.carbondata.presto.Types;
import org.apache.carbondata.presto.impl.CarbonTableCacheModel;
import org.apache.carbondata.presto.impl.CarbonTableReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class CarbondataPageSourceProvider
extends HivePageSourceProvider {
    private CarbonTableReader carbonTableReader;
    private String queryId;
    private HdfsEnvironment hdfsEnvironment;

    @Inject
    public CarbondataPageSourceProvider(HiveClientConfig hiveClientConfig, HdfsEnvironment hdfsEnvironment, Set<HiveRecordCursorProvider> cursorProviders, Set<HivePageSourceFactory> pageSourceFactories, TypeManager typeManager, CarbonTableReader carbonTableReader) {
        super(hiveClientConfig, hdfsEnvironment, cursorProviders, pageSourceFactories, typeManager);
        this.carbonTableReader = Objects.requireNonNull(carbonTableReader, "carbonTableReader is null");
        this.hdfsEnvironment = hdfsEnvironment;
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns) {
        HiveSplit carbonSplit = Types.checkType(split, HiveSplit.class, "split is not class HiveSplit");
        this.queryId = carbonSplit.getSchema().getProperty("queryId");
        if (this.queryId == null) {
            return super.createPageSource(transactionHandle, session, split, columns);
        }
        Configuration configuration = this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, carbonSplit.getDatabase(), carbonSplit.getTable()), new Path(carbonSplit.getSchema().getProperty("tablePath")));
        configuration = this.carbonTableReader.updateS3Properties(configuration);
        CarbonTable carbonTable = this.getCarbonTable(carbonSplit, configuration);
        boolean isDirectVectorFill = this.carbonTableReader.config.getPushRowFilter() == null || this.carbonTableReader.config.getPushRowFilter().equalsIgnoreCase("false");
        return new CarbondataPageSource(carbonTable, this.queryId, carbonSplit, columns, configuration, isDirectVectorFill);
    }

    private CarbonTable getCarbonTable(HiveSplit carbonSplit, Configuration configuration) {
        CarbonTableCacheModel tableCacheModel = this.carbonTableReader.getCarbonCache(new SchemaTableName(carbonSplit.getDatabase(), carbonSplit.getTable()), carbonSplit.getSchema().getProperty("tablePath"), configuration);
        Preconditions.checkNotNull((Object)tableCacheModel, (Object)"tableCacheModel should not be null");
        Preconditions.checkNotNull((Object)tableCacheModel.getCarbonTable(), (Object)"tableCacheModel.carbonTable should not be null");
        Preconditions.checkNotNull((Object)tableCacheModel.getCarbonTable().getTableInfo(), (Object)"tableCacheModel.carbonTable.tableInfo should not be null");
        return tableCacheModel.getCarbonTable();
    }
}

