/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import com.facebook.presto.hadoop.;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.block.LazyBlockLoader;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.scan.executor.QueryExecutor;
import org.apache.carbondata.core.scan.executor.QueryExecutorFactory;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.model.ProjectionDimension;
import org.apache.carbondata.core.scan.model.ProjectionMeasure;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.scan.result.iterator.AbstractDetailQueryResultIterator;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.carbondata.core.statusmanager.FileFormat;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.CarbonMultiBlockSplit;
import org.apache.carbondata.hadoop.CarbonProjection;
import org.apache.carbondata.hadoop.api.CarbonTableInputFormat;
import org.apache.carbondata.hadoop.stream.StreamRecordReader;
import org.apache.carbondata.presto.CarbonDictionaryDecodeReadSupport;
import org.apache.carbondata.presto.CarbonVectorBatch;
import org.apache.carbondata.presto.PrestoCarbonVectorizedRecordReader;
import org.apache.carbondata.presto.PrestoFilterUtil;
import org.apache.carbondata.presto.Types;
import org.apache.carbondata.presto.impl.CarbonLocalMultiBlockSplit;
import org.apache.carbondata.presto.readers.PrestoVectorBlockBuilder;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.log4j.Logger;

class CarbondataPageSource
implements ConnectorPageSource {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbondataPageSource.class.getName());
    private HiveSplit split;
    private CarbonTable carbonTable;
    private String queryId;
    private Configuration hadoopConf;
    private FileFormat fileFormat;
    private List<ColumnHandle> columnHandles;
    private int columnCount = 0;
    private boolean closed;
    private long sizeOfData = 0L;
    private int batchId;
    private long nanoStart;
    private long nanoEnd;
    private CarbonDictionaryDecodeReadSupport readSupport;
    private PrestoCarbonVectorizedRecordReader vectorReader;
    private boolean isDirectVectorFill;
    private StreamRecordReader rowReader;
    private StructField[] fields;
    private int batchSize = 100;
    private Dictionary[] dictionaries;
    private DataType[] dataTypes;
    private boolean isFrstPage = true;

    CarbondataPageSource(CarbonTable carbonTable, String queryId, HiveSplit split, List<ColumnHandle> columnHandles, Configuration hadoopConf, boolean isDirectVectorFill) {
        this.carbonTable = carbonTable;
        this.queryId = queryId;
        this.split = split;
        this.columnHandles = columnHandles;
        this.hadoopConf = hadoopConf;
        this.isDirectVectorFill = isDirectVectorFill;
        this.initialize();
    }

    private void initialize() {
        CarbonMultiBlockSplit carbonInputSplit = CarbonLocalMultiBlockSplit.convertSplit(this.split.getSchema().getProperty("carbonSplit"));
        this.fileFormat = carbonInputSplit.getFileFormat();
        if (this.fileFormat.ordinal() == FileFormat.ROW_V1.ordinal()) {
            this.initializeForRow();
        } else {
            this.initializeForColumnar();
        }
    }

    private void initializeForColumnar() {
        this.readSupport = new CarbonDictionaryDecodeReadSupport();
        this.vectorReader = this.createReaderForColumnar(this.split, this.columnHandles, this.readSupport, this.hadoopConf);
    }

    private void initializeForRow() {
        QueryModel queryModel = this.createQueryModel(this.split, this.columnHandles, this.hadoopConf);
        this.rowReader = new StreamRecordReader(queryModel, false);
        List queryDimension = queryModel.getProjectionDimensions();
        List queryMeasures = queryModel.getProjectionMeasures();
        this.fields = new StructField[queryDimension.size() + queryMeasures.size()];
        for (int i = 0; i < queryDimension.size(); ++i) {
            ProjectionDimension dim = (ProjectionDimension)queryDimension.get(i);
            if (dim.getDimension().hasEncoding(Encoding.DIRECT_DICTIONARY)) {
                DirectDictionaryGenerator generator = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator((DataType)dim.getDimension().getDataType());
                this.fields[dim.getOrdinal()] = new StructField(dim.getColumnName(), generator.getReturnType());
                continue;
            }
            this.fields[dim.getOrdinal()] = !dim.getDimension().hasEncoding(Encoding.DICTIONARY) ? new StructField(dim.getColumnName(), dim.getDimension().getDataType()) : (dim.getDimension().isComplex() != false ? new StructField(dim.getColumnName(), dim.getDimension().getDataType()) : new StructField(dim.getColumnName(), DataTypes.INT));
        }
        for (ProjectionMeasure msr : queryMeasures) {
            DataType dataType = msr.getMeasure().getDataType();
            if (dataType == DataTypes.BOOLEAN || dataType == DataTypes.SHORT || dataType == DataTypes.INT || dataType == DataTypes.LONG) {
                this.fields[msr.getOrdinal()] = new StructField(msr.getColumnName(), msr.getMeasure().getDataType());
                continue;
            }
            if (DataTypes.isDecimal((DataType)dataType)) {
                this.fields[msr.getOrdinal()] = new StructField(msr.getColumnName(), msr.getMeasure().getDataType());
                continue;
            }
            this.fields[msr.getOrdinal()] = new StructField(msr.getColumnName(), DataTypes.DOUBLE);
        }
        this.columnCount = this.columnHandles.size();
        this.readSupport = new CarbonDictionaryDecodeReadSupport();
        this.readSupport.initialize(queryModel.getProjectionColumns(), queryModel.getTable());
        this.dictionaries = this.readSupport.getDictionaries();
        this.dataTypes = this.readSupport.getDataTypes();
    }

    public long getCompletedBytes() {
        return this.sizeOfData;
    }

    public long getReadTimeNanos() {
        return this.nanoStart > 0L ? (this.nanoEnd == 0L ? System.nanoTime() : this.nanoEnd) - this.nanoStart : 0L;
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        if (this.fileFormat.ordinal() == FileFormat.ROW_V1.ordinal()) {
            return this.getNextPageForRow();
        }
        return this.getNextPageForColumnar();
    }

    private Page getNextPageForColumnar() {
        if (this.nanoStart == 0L) {
            this.nanoStart = System.nanoTime();
        }
        CarbonVectorBatch columnarBatch = null;
        int batchSize = 0;
        try {
            ++this.batchId;
            if (this.vectorReader.nextKeyValue()) {
                Object vectorBatch = this.vectorReader.getCurrentValue();
                if (vectorBatch instanceof CarbonVectorBatch && (batchSize = (columnarBatch = (CarbonVectorBatch)vectorBatch).numRows()) == 0) {
                    this.close();
                    return null;
                }
            } else {
                this.close();
                return null;
            }
            if (columnarBatch == null) {
                return null;
            }
            Block[] blocks = new Block[this.columnHandles.size()];
            for (int column = 0; column < blocks.length; ++column) {
                blocks[column] = new LazyBlock(batchSize, (LazyBlockLoader)new CarbondataBlockLoader(column));
            }
            Page page = new Page(batchSize, blocks);
            return page;
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw new CarbonDataLoadingException("Exception when creating the Carbon data Block", (Throwable)e);
        }
    }

    private Page getNextPageForRow() {
        if (this.isFrstPage) {
            this.isFrstPage = false;
            this.initialReaderForRow();
        }
        if (this.nanoStart == 0L) {
            this.nanoStart = System.nanoTime();
        }
        int count = 0;
        try {
            Block[] blocks = new Block[this.columnCount];
            CarbonColumnVectorImpl[] columns = new CarbonColumnVectorImpl[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                columns[i] = CarbonVectorBatch.createDirectStreamReader(this.batchSize, this.dataTypes[i], this.fields[i], this.dictionaries[i]);
            }
            while (this.rowReader.nextKeyValue()) {
                Object[] values = (Object[])this.rowReader.getCurrentValue();
                for (int index = 0; index < this.columnCount; ++index) {
                    columns[index].putObject(count, values[index]);
                }
                if (++count != this.batchSize) continue;
                break;
            }
            if (count == 0) {
                this.close();
                return null;
            }
            for (int index = 0; index < this.columnCount; ++index) {
                blocks[index] = ((PrestoVectorBlockBuilder)columns[index]).buildBlock();
                this.sizeOfData += blocks[index].getSizeInBytes();
            }
            return new Page(count, blocks);
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw new CarbonDataLoadingException("Exception when creating the Carbon data Block", (Throwable)e);
        }
    }

    private void initialReaderForRow() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        String jobTrackerId = formatter.format(new Date());
        TaskAttemptID attemptId = new TaskAttemptID(jobTrackerId, 0, TaskType.MAP, 0, 0);
        TaskAttemptContextImpl attemptContext = new TaskAttemptContextImpl(FileFactory.getConfiguration(), attemptId);
        CarbonMultiBlockSplit carbonInputSplit = CarbonLocalMultiBlockSplit.convertSplit(this.split.getSchema().getProperty("carbonSplit"));
        try {
            this.rowReader.initialize((InputSplit)carbonInputSplit, (TaskAttemptContext)attemptContext);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getSystemMemoryUsage() {
        return this.sizeOfData;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (this.vectorReader != null) {
                this.vectorReader.close();
            }
            if (this.rowReader != null) {
                this.rowReader.close();
            }
            this.nanoEnd = System.nanoTime();
        }
        catch (Exception e) {
            throw .Throwables.propagate((Throwable)e);
        }
    }

    private void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    private PrestoCarbonVectorizedRecordReader createReaderForColumnar(HiveSplit carbonSplit, List<? extends ColumnHandle> columns, CarbonDictionaryDecodeReadSupport readSupport, Configuration conf) {
        QueryModel queryModel = this.createQueryModel(carbonSplit, columns, conf);
        if (this.isDirectVectorFill) {
            queryModel.setDirectVectorFill(true);
            queryModel.setPreFetchData(false);
        }
        QueryExecutor queryExecutor = QueryExecutorFactory.getQueryExecutor((QueryModel)queryModel, (Configuration)new Configuration());
        try {
            CarbonIterator iterator = queryExecutor.execute(queryModel);
            readSupport.initialize(queryModel.getProjectionColumns(), queryModel.getTable());
            PrestoCarbonVectorizedRecordReader reader = new PrestoCarbonVectorizedRecordReader(queryExecutor, queryModel, (AbstractDetailQueryResultIterator)iterator, readSupport);
            reader.setTaskId(Long.parseLong(carbonSplit.getSchema().getProperty("index")));
            return reader;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create reader ", e);
        }
    }

    private QueryModel createQueryModel(HiveSplit carbondataSplit, List<? extends ColumnHandle> columns, Configuration conf) {
        try {
            CarbonProjection carbonProjection = this.getCarbonProjection(columns);
            conf.set("mapreduce.input.carboninputformat.segmentnumbers", "");
            String carbonTablePath = this.carbonTable.getAbsoluteTableIdentifier().getTablePath();
            CarbonTableInputFormat.setTransactionalTable((Configuration)conf, (boolean)this.carbonTable.getTableInfo().isTransactionalTable());
            CarbonTableInputFormat.setTableInfo((Configuration)conf, (TableInfo)this.carbonTable.getTableInfo());
            conf.set("mapreduce.input.fileinputformat.inputdir", carbonTablePath);
            conf.set("query.id", this.queryId);
            JobConf jobConf = new JobConf(conf);
            CarbonTableInputFormat<Object> carbonTableInputFormat = this.createInputFormat((Configuration)jobConf, this.carbonTable, PrestoFilterUtil.parseFilterExpression((TupleDomain<HiveColumnHandle>)carbondataSplit.getEffectivePredicate()), carbonProjection);
            TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl((Configuration)jobConf, new TaskAttemptID("", 1, TaskType.MAP, 0, 0));
            CarbonMultiBlockSplit carbonInputSplit = CarbonLocalMultiBlockSplit.convertSplit(carbondataSplit.getSchema().getProperty("carbonSplit"));
            QueryModel queryModel = carbonTableInputFormat.createQueryModel((InputSplit)carbonInputSplit, (TaskAttemptContext)hadoopAttemptContext);
            queryModel.setQueryId(this.queryId);
            queryModel.setVectorReader(true);
            queryModel.setStatisticsRecorder(CarbonTimeStatisticsFactory.createExecutorRecorder((String)queryModel.getQueryId()));
            List tableBlockInfoList = CarbonInputSplit.createBlocks((List)carbonInputSplit.getAllSplits());
            queryModel.setTableBlockInfos(tableBlockInfoList);
            return queryModel;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get the Query Model ", e);
        }
    }

    private CarbonTableInputFormat<Object> createInputFormat(Configuration conf, CarbonTable carbonTable, Expression filterExpression, CarbonProjection projection) {
        AbsoluteTableIdentifier identifier = carbonTable.getAbsoluteTableIdentifier();
        CarbonTableInputFormat format = new CarbonTableInputFormat();
        try {
            CarbonTableInputFormat.setTablePath((Configuration)conf, (String)identifier.appendWithLocalPrefix(identifier.getTablePath()));
            CarbonTableInputFormat.setDatabaseName((Configuration)conf, (String)identifier.getCarbonTableIdentifier().getDatabaseName());
            CarbonTableInputFormat.setTableName((Configuration)conf, (String)identifier.getCarbonTableIdentifier().getTableName());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create the CarbonTableInputFormat", e);
        }
        CarbonTableInputFormat.setFilterPredicates((Configuration)conf, (Expression)filterExpression);
        CarbonTableInputFormat.setColumnProjection((Configuration)conf, (CarbonProjection)projection);
        return format;
    }

    private CarbonProjection getCarbonProjection(List<? extends ColumnHandle> columns) {
        CarbonProjection carbonProjection = new CarbonProjection();
        ImmutableList.Builder handles = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            handles.add((Object)Types.checkType(columnHandle, HiveColumnHandle.class, "handle"));
            carbonProjection.addColumn(((HiveColumnHandle)columnHandle).getName());
        }
        return carbonProjection;
    }

    private final class CarbondataBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final int expectedBatchId;
        private final int columnIndex;
        private boolean loaded;

        CarbondataBlockLoader(int columnIndex) {
            this.expectedBatchId = CarbondataPageSource.this.batchId;
            this.columnIndex = columnIndex;
        }

        public final void load(LazyBlock lazyBlock) {
            if (this.loaded) {
                return;
            }
            Preconditions.checkState((CarbondataPageSource.this.batchId == this.expectedBatchId ? 1 : 0) != 0);
            try {
                CarbondataPageSource.this.vectorReader.getColumnarBatch().column(this.columnIndex).loadPage();
                PrestoVectorBlockBuilder blockBuilder = (PrestoVectorBlockBuilder)CarbondataPageSource.this.vectorReader.getColumnarBatch().column(this.columnIndex);
                blockBuilder.setBatchSize(lazyBlock.getPositionCount());
                Block block = blockBuilder.buildBlock();
                CarbondataPageSource.this.sizeOfData = CarbondataPageSource.this.sizeOfData + block.getSizeInBytes();
                lazyBlock.setBlock(block);
            }
            catch (Exception e) {
                throw new CarbonDataLoadingException("Error in Reading Data from Carbondata ", (Throwable)e);
            }
            this.loaded = true;
        }
    }
}

